/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.misc;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jphototagger.api.concurrent.Cancelable;
import org.jphototagger.api.concurrent.SerialTaskExecutor;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressHandle;
import org.jphototagger.api.progress.ProgressHandleFactory;
import org.jphototagger.domain.metadata.xmp.FileXmp;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.domain.repository.SaveOrUpdate;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.ThreadUtil;
import org.jphototagger.program.app.AppLifeCycle;
import org.jphototagger.program.misc.SaveToOrUpdateFilesInRepositoryImpl;
import org.jphototagger.xmp.XmpMetadata;
import org.openide.util.Lookup;

public final class SaveXmp
extends Thread
implements Cancelable {
    private static final String PROGRESSBAR_STRING = Bundle.getString(SaveXmp.class, "SaveXmp.ProgressBar.String", new Object[0]);
    private final Collection<FileXmp> imageFilesXmp;
    private volatile boolean cancel;
    private final Object source = this;
    private final XmpSidecarFileResolver xmpSidecarFileResolver = Lookup.getDefault().lookup(XmpSidecarFileResolver.class);
    private ProgressHandle progressHandle;

    private SaveXmp(Collection<FileXmp> imageFilesXmp) {
        super("JPhotoTagger: Saving XMP");
        this.imageFilesXmp = new ArrayList<FileXmp>(imageFilesXmp);
        this.addThisToSaveObjects();
    }

    private void addThisToSaveObjects() {
        AppLifeCycle.INSTANCE.addSaveObject(this);
    }

    public static synchronized void save(Collection<FileXmp> imageFilesXmp) {
        if (imageFilesXmp == null) {
            throw new NullPointerException("imageFilesXmp == null");
        }
        int fileCount = imageFilesXmp.size();
        if (fileCount >= 1) {
            SerialTaskExecutor executor = Lookup.getDefault().lookup(SerialTaskExecutor.class);
            SaveXmp saveXmp = new SaveXmp(imageFilesXmp);
            executor.addTask(saveXmp);
        }
    }

    @Override
    public void run() {
        int fileIndex = 0;
        this.progressHandle = Lookup.getDefault().lookup(ProgressHandleFactory.class).createProgressHandle(this);
        this.progressHandle.progressStarted(this.createProgressEvent(0));
        for (FileXmp fileXmp : this.imageFilesXmp) {
            File sidecarFile;
            if (this.cancel) break;
            File imageFile = fileXmp.getFile();
            Xmp xmp = fileXmp.getXmp();
            if (XmpMetadata.writeXmpToSidecarFile(xmp, sidecarFile = this.xmpSidecarFileResolver.suggestXmpSidecarFile(imageFile))) {
                this.updateRepository(imageFile);
            }
            this.progressHandle.progressPerformed(this.createProgressEvent(++fileIndex));
        }
        this.progressHandle.progressEnded();
        AppLifeCycle.INSTANCE.removeSaveObject(this);
    }

    private void updateRepository(File imageFile) {
        SaveToOrUpdateFilesInRepositoryImpl updater = new SaveToOrUpdateFilesInRepositoryImpl(Arrays.asList(imageFile), SaveOrUpdate.XMP);
        ThreadUtil.runInThisThread(updater);
    }

    private ProgressEvent createProgressEvent(int value) {
        return new ProgressEvent.Builder().source(this.source).stringPainted(true).stringToPaint(PROGRESSBAR_STRING).minimum(0).maximum(this.imageFilesXmp.size()).value(value).build();
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }
}

