/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.misc;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.api.concurrent.Cancelable;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.domain.event.listener.ProgressListenerSupport;
import org.jphototagger.domain.image.ImageFile;
import org.jphototagger.domain.metadata.event.UpdateMetadataCheckEvent;
import org.jphototagger.domain.metadata.exif.Exif;
import org.jphototagger.domain.metadata.exif.ExifUtil;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpIptc4XmpCoreDateCreatedMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpLastModifiedMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpModifier;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.domain.programs.Program;
import org.jphototagger.domain.repository.ActionsAfterRepoUpdatesRepository;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.domain.repository.SaveOrUpdate;
import org.jphototagger.domain.repository.SaveToOrUpdateFilesInRepository;
import org.jphototagger.domain.repository.ThumbnailsRepository;
import org.jphototagger.image.util.ThumbnailCreatorService;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.ThreadUtil;
import org.jphototagger.program.app.ui.AppLookAndFeel;
import org.jphototagger.program.module.programs.StartPrograms;
import org.jphototagger.xmp.XmpMetadata;
import org.openide.util.Lookup;

public final class SaveToOrUpdateFilesInRepositoryImpl
extends Thread
implements Cancelable,
SaveToOrUpdateFilesInRepository {
    private static final Logger LOGGER = Logger.getLogger(SaveToOrUpdateFilesInRepositoryImpl.class.getName());
    private final ImageFilesRepository imageFilesRepository = Lookup.getDefault().lookup(ImageFilesRepository.class);
    private final ActionsAfterRepoUpdatesRepository actionsAfterRepoUpdatesRepository = Lookup.getDefault().lookup(ActionsAfterRepoUpdatesRepository.class);
    private final ProgressListenerSupport progessListeners = new ProgressListenerSupport();
    private final ProgressEvent progressEvent = new ProgressEvent.Builder().source(this).build();
    private final Set<SaveOrUpdate> saveOrUpdate = EnumSet.noneOf(SaveOrUpdate.class);
    private final List<File> files;
    private final ThumbnailsRepository thumbnailsRepository = Lookup.getDefault().lookup(ThumbnailsRepository.class);
    private final XmpSidecarFileResolver xmpSidecarFileResolver = Lookup.getDefault().lookup(XmpSidecarFileResolver.class);
    private final Collection<? extends XmpModifier> xmpModifiers = Lookup.getDefault().lookupAll(XmpModifier.class);
    private volatile boolean cancel;

    public SaveToOrUpdateFilesInRepositoryImpl() {
        super("JPhotoTagger: Inserting image files into repository");
        this.files = new ArrayList<File>();
    }

    public SaveToOrUpdateFilesInRepositoryImpl(Collection<? extends File> files, SaveOrUpdate ... saveOrUpdate) {
        super("JPhotoTagger: Inserting image files into repository");
        if (files == null) {
            throw new NullPointerException("files == null");
        }
        if (saveOrUpdate == null) {
            throw new NullPointerException("saveOrUpdate == null");
        }
        this.files = new ArrayList<File>(files);
        this.saveOrUpdate.addAll(Arrays.asList(saveOrUpdate));
    }

    @Override
    public SaveToOrUpdateFilesInRepository createInstance(Collection<? extends File> files, SaveOrUpdate ... saveOrUpdate) {
        if (files == null) {
            throw new NullPointerException("files == null");
        }
        if (saveOrUpdate == null) {
            throw new NullPointerException("what == saveOrUpdate");
        }
        return new SaveToOrUpdateFilesInRepositoryImpl(files, saveOrUpdate);
    }

    @Override
    public void saveOrUpdateInNewThread() {
        this.start();
    }

    @Override
    public void saveOrUpdateWaitForTermination() {
        ThreadUtil.runInThisThread(this);
    }

    @Override
    public void run() {
        int index;
        int count = this.files.size();
        this.notifyStarted();
        for (index = 0; !this.cancel && !this.isInterrupted() && index < count; ++index) {
            File file = this.files.get(index);
            if (this.checkExists(file)) {
                this.deleteXmpFromRepositoryIfAbsentInFilesystem(file);
                ImageFile imageFile = this.createImageFile(file);
                if (this.isUpdate(imageFile)) {
                    this.setExifDateToXmpDateCreated(imageFile);
                    this.logInsertImageFile(imageFile);
                    this.imageFilesRepository.saveOrUpdateImageFile(imageFile);
                    this.runActionsAfterInserting(imageFile);
                }
            }
            this.notifyPerformed(index + 1, file);
        }
        this.notifyEnded(index);
    }

    private boolean isUpdate(ImageFile imageFile) {
        return imageFile.getExif() != null || imageFile.getXmp() != null || imageFile.getThumbnail() != null;
    }

    private ImageFile createImageFile(File file) {
        ImageFile imageFile = new ImageFile();
        imageFile.setFile(file);
        imageFile.setLastmodified(file.lastModified());
        imageFile.setSizeInBytes(file.length());
        if (this.isUpdateThumbnail(file)) {
            imageFile.addToSaveIntoRepository(SaveOrUpdate.THUMBNAIL);
            this.createAndSetThumbnailToImageFile(imageFile);
        }
        if (this.isUpdateXmp(file)) {
            imageFile.addToSaveIntoRepository(SaveOrUpdate.XMP);
            this.setXmpToImageFile(imageFile);
        }
        if (this.isUpdateExif(file)) {
            imageFile.addToSaveIntoRepository(SaveOrUpdate.EXIF);
            this.setExifToImageFile(imageFile);
        }
        return imageFile;
    }

    private boolean isUpdateThumbnail(File imageFile) {
        return this.saveOrUpdate.contains((Object)SaveOrUpdate.THUMBNAIL) || this.saveOrUpdate.contains((Object)SaveOrUpdate.OUT_OF_DATE) && !this.thumbnailsRepository.hasUpToDateThumbnail(imageFile);
    }

    private boolean isUpdateExif(File imageFile) {
        return this.saveOrUpdate.contains((Object)SaveOrUpdate.EXIF) || this.saveOrUpdate.contains((Object)SaveOrUpdate.OUT_OF_DATE) && !this.isImageFileUpToDate(imageFile);
    }

    private boolean isUpdateXmp(File file) {
        return this.saveOrUpdate.contains((Object)SaveOrUpdate.XMP) || this.saveOrUpdate.contains((Object)SaveOrUpdate.OUT_OF_DATE) && !this.isXmpUpToDate(file);
    }

    private boolean isImageFileUpToDate(File imageFile) {
        long repoTime = this.imageFilesRepository.findImageFilesLastModifiedTimestamp(imageFile);
        long fileTime = imageFile.lastModified();
        long repoSizeInBytes = this.imageFilesRepository.findImageFilesSizeInBytes(imageFile);
        long fileSizeInBytes = imageFile.length();
        return fileTime == repoTime && fileSizeInBytes == repoSizeInBytes;
    }

    private boolean isXmpUpToDate(File file) {
        File xmpFile = this.xmpSidecarFileResolver.getXmpSidecarFileOrNullIfNotExists(file);
        return xmpFile == null ? this.isScanForEmbeddedXmp() && this.isEmbeddedXmpUpToDate(file) : this.isXmpSidecarFileUpToDate(file, xmpFile);
    }

    private boolean isScanForEmbeddedXmp() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.ScanForEmbeddedXmp") ? prefs.getBoolean("UserSettings.ScanForEmbeddedXmp") : false;
    }

    private boolean isXmpSidecarFileUpToDate(File imageFile, File sidecarFile) {
        long repoTime = this.imageFilesRepository.findXmpFilesLastModifiedTimestamp(imageFile);
        long fileTime = sidecarFile.lastModified();
        return fileTime == repoTime;
    }

    private boolean isEmbeddedXmpUpToDate(File file) {
        boolean hasEmbeddedXmp;
        long fileTime;
        long repoTime = this.imageFilesRepository.findXmpFilesLastModifiedTimestamp(file);
        if (repoTime == (fileTime = file.lastModified())) {
            return true;
        }
        boolean bl = hasEmbeddedXmp = XmpMetadata.getEmbeddedXmp(file) != null;
        if (!hasEmbeddedXmp) {
            this.imageFilesRepository.setLastModifiedToXmpSidecarFileOfImageFile(file, fileTime);
        }
        return !hasEmbeddedXmp;
    }

    private void createAndSetThumbnailToImageFile(ImageFile imageFile) {
        File file = imageFile.getFile();
        Image thumbnail = ThumbnailCreatorService.INSTANCE.createThumbnail(file);
        imageFile.setThumbnail(thumbnail);
        if (thumbnail == null) {
            this.logErrorNullThumbnail(file);
            imageFile.setThumbnail(AppLookAndFeel.ERROR_THUMBNAIL);
        }
    }

    private void setExifToImageFile(ImageFile imageFile) {
        File file = imageFile.getFile();
        Exif exif = ExifUtil.readExif(file);
        imageFile.setExif(exif);
    }

    private void setXmpToImageFile(ImageFile imageFile) {
        Xmp xmp;
        File file = imageFile.getFile();
        try {
            xmp = this.xmpSidecarFileResolver.hasXmpSidecarFile(file) ? XmpMetadata.getXmpFromSidecarFileOf(file) : (this.isScanForEmbeddedXmp() ? XmpMetadata.getEmbeddedXmp(file) : null);
        }
        catch (IOException ex) {
            Logger.getLogger(SaveToOrUpdateFilesInRepositoryImpl.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        this.modifyXmp(this.xmpSidecarFileResolver.findSidecarFile(this.xmpSidecarFileResolver.suggestXmpSidecarFile(file)), xmp);
        this.writeSidecarFileIfNotExists(file, xmp);
        if (xmp != null && !xmp.isEmpty()) {
            imageFile.setXmp(xmp);
        }
    }

    private void modifyXmp(File sidecarFile, Xmp xmp) {
        if (sidecarFile == null || xmp == null) {
            return;
        }
        for (XmpModifier xmpModifier : this.xmpModifiers) {
            if (!xmpModifier.modifyXmp(sidecarFile, xmp)) continue;
            XmpMetadata.writeXmpToSidecarFile(xmp, sidecarFile);
        }
    }

    private void setExifDateToXmpDateCreated(ImageFile imageFile) {
        boolean hasExifDate;
        Exif exif = imageFile.getExif();
        Xmp xmp = imageFile.getXmp();
        boolean hasExif = exif != null;
        boolean hasXmp = xmp != null;
        boolean hasXmpDateCreated = hasXmp && xmp.contains(XmpIptc4XmpCoreDateCreatedMetaDataValue.INSTANCE);
        boolean bl = hasExifDate = hasExif && exif.getDateTimeOriginal() != null;
        if (hasXmpDateCreated || !hasXmp || !hasExif || !hasExifDate) {
            return;
        }
        xmp.setValue(XmpIptc4XmpCoreDateCreatedMetaDataValue.INSTANCE, exif.getXmpDateCreated());
        File sidecarFile = this.xmpSidecarFileResolver.suggestXmpSidecarFile(imageFile.getFile());
        if (sidecarFile.canWrite()) {
            XmpMetadata.writeXmpToSidecarFile(xmp, sidecarFile);
            xmp.setValue(XmpLastModifiedMetaDataValue.INSTANCE, sidecarFile.lastModified());
        }
    }

    private void writeSidecarFileIfNotExists(File imageFile, Xmp xmp) {
        if (xmp != null && !this.xmpSidecarFileResolver.hasXmpSidecarFile(imageFile) && XmpMetadata.canWriteSidecarFileForImageFile(imageFile)) {
            File sidecarFile = this.xmpSidecarFileResolver.suggestXmpSidecarFile(imageFile);
            XmpMetadata.writeXmpToSidecarFile(xmp, sidecarFile);
        }
    }

    private void runActionsAfterInserting(ImageFile imageFile) {
        if (!this.isRunActionsAfterInserting(imageFile)) {
            return;
        }
        File file = imageFile.getFile();
        List<Program> actions = this.actionsAfterRepoUpdatesRepository.findAllActions();
        for (Program action : actions) {
            StartPrograms programStarter = new StartPrograms();
            programStarter.startProgram(action, Collections.singletonList(file), true);
        }
    }

    private void deleteXmpFromRepositoryIfAbsentInFilesystem(File file) {
        if (this.xmpSidecarFileResolver.hasXmpSidecarFile(file)) {
            return;
        }
        if (this.imageFilesRepository.existsXmpForFile(file)) {
            LOGGER.log(Level.INFO, "Deleting from Repository XMP of file ''{0}'' - it does not have (anymore) a XMP sidecar file", file);
            this.imageFilesRepository.deleteXmpOfFile(file);
        }
    }

    private boolean isRunActionsAfterInserting(ImageFile imageFile) {
        return this.isExecuteActionsAfterImageChangeInDbAlways() || this.isExecuteActionsAfterImageChangeInDbIfImageHasXmp() && imageFile.getXmp() != null;
    }

    private boolean isExecuteActionsAfterImageChangeInDbIfImageHasXmp() {
        Preferences preferences = Lookup.getDefault().lookup(Preferences.class);
        return preferences.containsKey("UserSettings.ExecuteActionsAfterImageChangeInDbIfImageHasXmp") ? preferences.getBoolean("UserSettings.ExecuteActionsAfterImageChangeInDbIfImageHasXmp") : false;
    }

    private boolean isExecuteActionsAfterImageChangeInDbAlways() {
        Preferences preferences = Lookup.getDefault().lookup(Preferences.class);
        return preferences.containsKey("UserSettings.ExecuteActionsAfterImageChangeInDbAlways") ? preferences.getBoolean("UserSettings.ExecuteActionsAfterImageChangeInDbAlways") : false;
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    private void notifyUpdateMetadataCheckListener(UpdateMetadataCheckEvent.Type type, File file) {
        UpdateMetadataCheckEvent evt = new UpdateMetadataCheckEvent(type, file);
        EventBus.publish(evt);
    }

    @Override
    public void addProgressListener(ProgressListener progessListener) {
        if (progessListener == null) {
            throw new NullPointerException("progessListener == null");
        }
        this.progessListeners.add(progessListener);
    }

    @Override
    public void removeProgressListener(ProgressListener progessListener) {
        if (progessListener == null) {
            throw new NullPointerException("progessListener == null");
        }
        this.progessListeners.remove(progessListener);
    }

    private void notifyStarted() {
        this.notifyUpdateMetadataCheckListener(UpdateMetadataCheckEvent.Type.CHECK_STARTED, null);
        this.progressEvent.setMinimum(0);
        this.progressEvent.setMaximum(this.files.size());
        this.progressEvent.setValue(0);
        this.progessListeners.notifyStarted(this.progressEvent);
    }

    private void notifyPerformed(int value, File file) {
        this.logPerformed(file);
        this.notifyUpdateMetadataCheckListener(UpdateMetadataCheckEvent.Type.CHECKING_FILE, file);
        this.progressEvent.setValue(value);
        this.progressEvent.setInfo(file);
        this.progessListeners.notifyPerformed(this.progressEvent);
    }

    private void notifyEnded(int filecount) {
        this.logEnded(filecount);
        this.notifyUpdateMetadataCheckListener(UpdateMetadataCheckEvent.Type.CHECK_FINISHED, null);
        this.progessListeners.notifyEnded(this.progressEvent);
    }

    private void logErrorNullThumbnail(File file) {
        LOGGER.log(Level.WARNING, "Thumbnail couldn''t be created for image file ''{0}''", file);
    }

    private void logPerformed(File file) {
        LOGGER.log(Level.FINEST, "Synchronizing ''{0}'' with the repository", file);
    }

    private void logEnded(int filecount) {
        LOGGER.log(Level.INFO, "Synchronized {0} image files with the repository", filecount);
    }

    private boolean checkExists(File imageFile) {
        if (!imageFile.exists()) {
            LOGGER.log(Level.INFO, "Image file ''{0}'' does not (longer) exist and will not be updated in the repository", imageFile);
            return false;
        }
        return true;
    }

    private void logInsertImageFile(ImageFile data) {
        Object[] params = new Object[]{data.getFile().getAbsolutePath(), data.getExif() == null ? Bundle.getString(SaveToOrUpdateFilesInRepositoryImpl.class, "SaveToOrUpdateFilesInRepositoryImpl.Info.StartInsert.No", new Object[0]) : Bundle.getString(SaveToOrUpdateFilesInRepositoryImpl.class, "SaveToOrUpdateFilesInRepositoryImpl.Info.StartInsert.Yes", new Object[0]), data.getXmp() == null ? Bundle.getString(SaveToOrUpdateFilesInRepositoryImpl.class, "SaveToOrUpdateFilesInRepositoryImpl.Info.StartInsert.No", new Object[0]) : Bundle.getString(SaveToOrUpdateFilesInRepositoryImpl.class, "SaveToOrUpdateFilesInRepositoryImpl.Info.StartInsert.Yes", new Object[0]), data.getThumbnail() == null ? Bundle.getString(SaveToOrUpdateFilesInRepositoryImpl.class, "SaveToOrUpdateFilesInRepositoryImpl.Info.StartInsert.No", new Object[0]) : Bundle.getString(SaveToOrUpdateFilesInRepositoryImpl.class, "SaveToOrUpdateFilesInRepositoryImpl.Info.StartInsert.Yes", new Object[0])};
        LOGGER.log(Level.INFO, "Add metadata into the repository of file ''{0}'': EXIF: {1}, XMP: {2}, Thumbnail: {3}", params);
    }
}

