/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.misc;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.lib.concurrent.HelperThread;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class RenameLongXmpSidecarFilenames
extends HelperThread {
    private static final String INFO = Bundle.getString(RenameLongXmpSidecarFilenames.class, "RenameLongXmpSidecarFilenames.Info", new Object[0]);
    private static final Logger LOGGER = Logger.getLogger(RenameLongXmpSidecarFilenames.class.getName());
    private final XmpSidecarFileResolver xmpSidecarFileResolver = Lookup.getDefault().lookup(XmpSidecarFileResolver.class);
    private volatile boolean cancel;
    private final boolean setLongNames;

    public RenameLongXmpSidecarFilenames(boolean setLongNames) {
        super("JPhotoTagger: Setting " + (setLongNames ? " long " : " default ") + " sidecar filenames");
        this.setLongNames = setLongNames;
    }

    @Override
    public void run() {
        LOGGER.log(Level.INFO, "Setting {0} XMP sidecar filenames", this.setLongNames ? " long " : " default ");
        ImageFilesRepository fileRepo = Lookup.getDefault().lookup(ImageFilesRepository.class);
        List<File> files = fileRepo.findAllImageFiles();
        int filecount = files.size();
        this.progressStarted(0, 0, filecount, INFO);
        for (int index = 0; !this.cancel && index < filecount; ++index) {
            this.renameXmpSidecarFile(files.get(index));
            this.progressPerformed(index + 1, INFO);
        }
        this.progressEnded(INFO);
        LOGGER.log(Level.INFO, "{0} XMP sidecar filenames has been set", this.setLongNames ? " long " : " default ");
    }

    private void renameXmpSidecarFile(File file) {
        boolean isRename;
        File longSidecarFile = this.xmpSidecarFileResolver.suggestLongSidecarFile(file);
        File defaultSidecarFile = this.xmpSidecarFileResolver.suggestDefaultSidecarFile(file);
        File fromFile = this.xmpSidecarFileResolver.findSidecarFile(this.setLongNames ? defaultSidecarFile : longSidecarFile);
        File toFile = this.setLongNames ? longSidecarFile : defaultSidecarFile;
        boolean fromFileExists = fromFile != null;
        File foundToFile = this.xmpSidecarFileResolver.findSidecarFile(toFile);
        boolean toFileExists = foundToFile != null;
        boolean bl = isRename = fromFileExists && !toFileExists;
        if (isRename) {
            LOGGER.log(Level.INFO, "Renaming XMP sidecar file ''{0}'' to ''{1}", new Object[]{fromFile, toFile});
            boolean renamed = fromFile.renameTo(toFile);
            if (!renamed) {
                LOGGER.log(Level.WARNING, "Sidecar file ''{0}'' couldn''t be renamed to ''{1}''", new Object[]{fromFile, toFile});
            }
        }
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }
}

