/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.misc;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.storage.Persistence;
import org.jphototagger.lib.help.HelpPageProvider;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class PerformanceSettingsPanel
extends JPanel
implements Persistence,
HelpPageProvider {
    private static final long serialVersionUID = 1L;
    private boolean listen;
    private JCheckBox checkBoxAutocompleteFastSearchIgnoreCase;
    private JCheckBox checkBoxAutoscanDirectories;
    private JCheckBox checkBoxEnableAutocomplete;
    private JCheckBox checkBoxSaveInputEarly;
    private JCheckBox checkBoxScanForEmbeddedXmp;
    private JCheckBox checkBoxUpdateAutocomplete;
    private JLabel labelMaximumSecondsToTerminateExternalPrograms;
    private JPanel panelAutocomplete;
    private JPanel panelMaximumSecondsToTerminateExternalPrograms;
    private JSpinner spinnerMaximumSecondsToTerminateExternalPrograms;

    public PerformanceSettingsPanel() {
        this.initComponents();
        MnemonicUtil.setMnemonics(this);
    }

    @Override
    public void restore() {
        this.listen = false;
        this.checkBoxScanForEmbeddedXmp.setSelected(this.lookupScanForEmbeddedXmp());
        this.checkBoxSaveInputEarly.setSelected(this.lookupSaveInputEarly());
        this.spinnerMaximumSecondsToTerminateExternalPrograms.getModel().setValue(this.getMaxSecondsToTerminateExternalPrograms());
        this.checkBoxEnableAutocomplete.setSelected(this.lookupEnableAutocomplete());
        this.checkBoxUpdateAutocomplete.setSelected(this.lookupUpdateAutocomplete());
        this.checkBoxUpdateAutocomplete.setEnabled(this.checkBoxEnableAutocomplete.isSelected());
        this.checkBoxAutocompleteFastSearchIgnoreCase.setSelected(this.lookupAutocompleteFastSearchIgnoreCase());
        this.checkBoxAutoscanDirectories.setSelected(this.lookupAutoscanDirectories());
        this.listen = true;
    }

    @Override
    public void persist() {
    }

    @Override
    public String getHelpPageUrl() {
        return Bundle.getString(PerformanceSettingsPanel.class, "PerformanceSettingsPanel.HelpPage", new Object[0]);
    }

    private void persistMaximumSecondsToTerminateExternalPrograms() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        SpinnerModel model = this.spinnerMaximumSecondsToTerminateExternalPrograms.getModel();
        Integer adjustedSeconds = (Integer)model.getValue();
        prefs.setInt("UserSettings.MaximumSecondsToTerminateExternalPrograms", adjustedSeconds);
    }

    private int getMaxSecondsToTerminateExternalPrograms() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.MaximumSecondsToTerminateExternalPrograms") ? prefs.getInt("UserSettings.MaximumSecondsToTerminateExternalPrograms") : 60;
    }

    private void persistScanForEmbeddedXmp() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        boolean scanForEmbeddedXmpSelected = this.checkBoxScanForEmbeddedXmp.isSelected();
        prefs.setBoolean("UserSettings.ScanForEmbeddedXmp", scanForEmbeddedXmpSelected);
    }

    private boolean lookupScanForEmbeddedXmp() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.ScanForEmbeddedXmp") ? prefs.getBoolean("UserSettings.ScanForEmbeddedXmp") : false;
    }

    private void persistSaveInputEarly() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        boolean saveInputEarlySelected = this.checkBoxSaveInputEarly.isSelected();
        prefs.setBoolean("UserSettings.SaveInputEarly", saveInputEarlySelected);
    }

    private boolean lookupSaveInputEarly() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.SaveInputEarly") ? prefs.getBoolean("UserSettings.SaveInputEarly") : true;
    }

    private void persistUpdateAutocomplete() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        boolean updateAutocompleteSelected = this.checkBoxUpdateAutocomplete.isSelected();
        prefs.setBoolean("UserSettings.UpdateAutocomplete", updateAutocompleteSelected);
    }

    private boolean lookupUpdateAutocomplete() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.UpdateAutocomplete") ? prefs.getBoolean("UserSettings.UpdateAutocomplete") : true;
    }

    private void persistEnableAutocomplete() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        boolean enableAutocompleteSelected = this.checkBoxEnableAutocomplete.isSelected();
        prefs.setBoolean("UserSettings.EnableAutoComplete", enableAutocompleteSelected);
        this.checkBoxUpdateAutocomplete.setEnabled(enableAutocompleteSelected);
    }

    private boolean lookupEnableAutocomplete() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.EnableAutoComplete") ? prefs.getBoolean("UserSettings.EnableAutoComplete") : true;
    }

    private void persistAutocompleteFastSearchIgnoreCase() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        boolean autocompleteIgnoreCaseSelected = this.checkBoxAutocompleteFastSearchIgnoreCase.isSelected();
        prefs.setBoolean("UserSettings.Autocomplete.IgnoreCase", autocompleteIgnoreCaseSelected);
    }

    private boolean lookupAutocompleteFastSearchIgnoreCase() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.Autocomplete.IgnoreCase") ? prefs.getBoolean("UserSettings.Autocomplete.IgnoreCase") : false;
    }

    private void persistAutoscanDirectories() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        boolean autoscanDirectoriesSelected = this.checkBoxAutoscanDirectories.isSelected();
        prefs.setBoolean("Preferences.Autoscan.Directories", autoscanDirectoriesSelected);
    }

    private boolean lookupAutoscanDirectories() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("Preferences.Autoscan.Directories") ? prefs.getBoolean("Preferences.Autoscan.Directories") : false;
    }

    private void initComponents() {
        this.panelMaximumSecondsToTerminateExternalPrograms = new JPanel();
        this.labelMaximumSecondsToTerminateExternalPrograms = new JLabel();
        this.spinnerMaximumSecondsToTerminateExternalPrograms = new JSpinner();
        this.checkBoxScanForEmbeddedXmp = new JCheckBox();
        this.checkBoxAutoscanDirectories = new JCheckBox();
        this.checkBoxSaveInputEarly = new JCheckBox();
        this.panelAutocomplete = new JPanel();
        this.checkBoxEnableAutocomplete = new JCheckBox();
        this.checkBoxUpdateAutocomplete = new JCheckBox();
        this.checkBoxAutocompleteFastSearchIgnoreCase = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.panelMaximumSecondsToTerminateExternalPrograms.setLayout(new GridBagLayout());
        this.labelMaximumSecondsToTerminateExternalPrograms.setLabelFor(this.spinnerMaximumSecondsToTerminateExternalPrograms);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/misc/Bundle");
        this.labelMaximumSecondsToTerminateExternalPrograms.setText(bundle.getString("PerformanceSettingsPanel.labelMaximumSecondsToTerminateExternalPrograms.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.panelMaximumSecondsToTerminateExternalPrograms.add((Component)this.labelMaximumSecondsToTerminateExternalPrograms, gridBagConstraints);
        this.spinnerMaximumSecondsToTerminateExternalPrograms.setModel(new SpinnerNumberModel(60, 10, 600, 1));
        this.spinnerMaximumSecondsToTerminateExternalPrograms.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PerformanceSettingsPanel.this.spinnerMaximumSecondsToTerminateExternalProgramsStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 2, 0, 10);
        this.panelMaximumSecondsToTerminateExternalPrograms.add((Component)this.spinnerMaximumSecondsToTerminateExternalPrograms, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.panelMaximumSecondsToTerminateExternalPrograms, gridBagConstraints);
        this.checkBoxScanForEmbeddedXmp.setText(bundle.getString("PerformanceSettingsPanel.checkBoxScanForEmbeddedXmp.text"));
        this.checkBoxScanForEmbeddedXmp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerformanceSettingsPanel.this.checkBoxScanForEmbeddedXmpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add((Component)this.checkBoxScanForEmbeddedXmp, gridBagConstraints);
        this.checkBoxAutoscanDirectories.setText(bundle.getString("PerformanceSettingsPanel.checkBoxAutoscanDirectories.text"));
        this.checkBoxAutoscanDirectories.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerformanceSettingsPanel.this.checkBoxAutoscanDirectoriesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.checkBoxAutoscanDirectories, gridBagConstraints);
        this.checkBoxSaveInputEarly.setText(bundle.getString("PerformanceSettingsPanel.checkBoxSaveInputEarly.text"));
        this.checkBoxSaveInputEarly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerformanceSettingsPanel.this.checkBoxSaveInputEarlyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.checkBoxSaveInputEarly, gridBagConstraints);
        this.panelAutocomplete.setBorder(BorderFactory.createTitledBorder(bundle.getString("PerformanceSettingsPanel.panelAutocomplete.border.title")));
        this.panelAutocomplete.setLayout(new GridBagLayout());
        this.checkBoxEnableAutocomplete.setText(bundle.getString("PerformanceSettingsPanel.checkBoxEnableAutocomplete.text"));
        this.checkBoxEnableAutocomplete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerformanceSettingsPanel.this.checkBoxEnableAutocompleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelAutocomplete.add((Component)this.checkBoxEnableAutocomplete, gridBagConstraints);
        this.checkBoxUpdateAutocomplete.setText(bundle.getString("PerformanceSettingsPanel.checkBoxUpdateAutocomplete.text"));
        this.checkBoxUpdateAutocomplete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerformanceSettingsPanel.this.checkBoxUpdateAutocompleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panelAutocomplete.add((Component)this.checkBoxUpdateAutocomplete, gridBagConstraints);
        this.checkBoxAutocompleteFastSearchIgnoreCase.setText(bundle.getString("PerformanceSettingsPanel.checkBoxAutocompleteFastSearchIgnoreCase.text"));
        this.checkBoxAutocompleteFastSearchIgnoreCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerformanceSettingsPanel.this.checkBoxAutocompleteFastSearchIgnoreCaseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelAutocomplete.add((Component)this.checkBoxAutocompleteFastSearchIgnoreCase, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add((Component)this.panelAutocomplete, gridBagConstraints);
    }

    private void spinnerMaximumSecondsToTerminateExternalProgramsStateChanged(ChangeEvent evt) {
        if (this.listen) {
            this.persistMaximumSecondsToTerminateExternalPrograms();
        }
    }

    private void checkBoxScanForEmbeddedXmpActionPerformed(ActionEvent evt) {
        if (this.listen) {
            this.persistScanForEmbeddedXmp();
        }
    }

    private void checkBoxSaveInputEarlyActionPerformed(ActionEvent evt) {
        if (this.listen) {
            this.persistSaveInputEarly();
        }
    }

    private void checkBoxEnableAutocompleteActionPerformed(ActionEvent evt) {
        if (this.listen) {
            this.persistEnableAutocomplete();
        }
    }

    private void checkBoxUpdateAutocompleteActionPerformed(ActionEvent evt) {
        if (this.listen) {
            this.persistUpdateAutocomplete();
        }
    }

    private void checkBoxAutocompleteFastSearchIgnoreCaseActionPerformed(ActionEvent evt) {
        if (this.listen) {
            this.persistAutocompleteFastSearchIgnoreCase();
        }
    }

    private void checkBoxAutoscanDirectoriesActionPerformed(ActionEvent evt) {
        if (this.listen) {
            this.persistAutoscanDirectories();
        }
    }
}

