/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.misc;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileSystemView;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.concurrent.SerialTaskExecutor;
import org.jphototagger.api.file.CopyMoveFilesOptions;
import org.jphototagger.api.file.FilenameTokens;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.api.storage.Persistence;
import org.jphototagger.api.windows.OptionPageProvider;
import org.jphototagger.domain.repository.FileRepositoryProvider;
import org.jphototagger.lib.api.LayerUtil;
import org.jphototagger.lib.api.PositionProviderAscendingComparator;
import org.jphototagger.lib.help.HelpPageProvider;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.swing.DirectoryChooser;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.misc.RenameLongXmpSidecarFilenames;
import org.jphototagger.program.module.wordsets.WordsetPreferences;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class MiscSettingsPanel
extends JPanel
implements Persistence,
HelpPageProvider {
    private static final long serialVersionUID = 1L;
    private static final String PREFERENCES_KEY_TABBED_PANE = "MiscSettingsPanel.TabbedPane";
    private final Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
    private boolean listenToUseLongXmpSidecarFileNames;
    private JButton buttonChooseRepositoryDirectory;
    private ButtonGroup buttonGroupCopyMoveFiles;
    private JButton buttonSetDefaultRepositoryDirectoryName;
    private JCheckBox checkBoxCheckForUpdates;
    private JCheckBox checkBoxDisplaySearchButton;
    private JCheckBox checkBoxDisplayWordsetsEditPanel;
    private JCheckBox checkBoxEnableDeleteDirectories;
    private JCheckBox checkBoxIsAcceptHiddenDirectories;
    private JCheckBox checkBoxUseLongXmpSidecarFileNames;
    private JLabel labelInfoRepositoryDirectory;
    private JLabel labelMdTextAreasColumnsInfo;
    private JLabel labelMdTextAreasColumnsPropmpt;
    private JLabel labelRepositoryDirectory;
    private JPanel panelButtonsRepositoryDirectory;
    private JPanel panelCheckForUpdates;
    private JPanel panelCopyMoveFiles;
    private JPanel panelDefault;
    private JPanel panelEditMetadata;
    private JPanel panelFill;
    private JPanel panelMdTextAreasColumns;
    private JPanel panelRepositoryDirectory;
    private JRadioButton radioButtonCopyMoveFileConfirmOverwrite;
    private JRadioButton radioButtonCopyMoveFileRenameIfExists;
    private JSpinner spinnerMdTextAreasColumns;
    private JTabbedPane tabbedPane;

    public MiscSettingsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.lookupMiscOptionPages();
        this.restoreTabbedPaneSettings();
        MnemonicUtil.setMnemonics(this);
        AnnotationProcessor.process(this);
    }

    private File chooseDirectory(File startDirectory) {
        File dir = null;
        DirectoryChooser.Option showHiddenDirs = this.getDirChooserOptionShowHiddenDirs();
        DirectoryChooser dlg = new DirectoryChooser((Frame)GUI.getAppFrame(), startDirectory, showHiddenDirs);
        dlg.setPreferencesKey("MiscSettingsPanel.DirChooser");
        dlg.setVisible(true);
        ComponentUtil.parentWindowToFront(this);
        if (dlg.isAccepted()) {
            dir = dlg.getSelectedDirectories().get(0);
        }
        return dir;
    }

    private DirectoryChooser.Option getDirChooserOptionShowHiddenDirs() {
        return this.isAcceptHiddenDirectories() ? DirectoryChooser.Option.DISPLAY_HIDDEN_DIRECTORIES : DirectoryChooser.Option.NO_OPTION;
    }

    private boolean isAcceptHiddenDirectories() {
        return this.prefs.containsKey("UserSettings.IsAcceptHiddenDirectories") ? this.prefs.getBoolean("UserSettings.IsAcceptHiddenDirectories") : false;
    }

    private void setAcceptHiddenDirectories() {
        this.setAcceptHiddenDirectories(this.checkBoxIsAcceptHiddenDirectories.isSelected());
    }

    private void setAcceptHiddenDirectories(boolean accept) {
        this.prefs.setBoolean("UserSettings.IsAcceptHiddenDirectories", accept);
    }

    private boolean isDeleteDirectoriesEnabled() {
        return this.prefs.containsKey("Preferences.Enable.DeleteDirectories") ? this.prefs.getBoolean("Preferences.Enable.DeleteDirectories") : true;
    }

    private void setDeleteDirectoriesEnabled() {
        this.prefs.setBoolean("Preferences.Enable.DeleteDirectories", this.checkBoxEnableDeleteDirectories.isSelected());
    }

    private void chooseRepositoryDirectory() {
        FileRepositoryProvider provider = Lookup.getDefault().lookup(FileRepositoryProvider.class);
        File repositoryDirectory = provider.getFileRepositoryDirectory();
        File file = this.chooseDirectory(repositoryDirectory);
        if (file != null) {
            this.setRepositoryDirectoryName(file.getAbsolutePath());
            this.displayRepositoryDirectoryInfo();
        }
    }

    private void setRepositoryDirectoryName(String directoryName) {
        this.setIconRepositoryDirectory();
        this.labelRepositoryDirectory.setText(directoryName);
        this.prefs.setString("UserSettings.DatabaseDirectoryName", directoryName);
    }

    private void setIconRepositoryDirectory() {
        File dir = new File(this.labelRepositoryDirectory.getText());
        if (dir.isDirectory()) {
            Icon icon = FileSystemView.getFileSystemView().getSystemIcon(dir);
            this.labelRepositoryDirectory.setIcon(icon);
        }
    }

    private void setDefaultRepositoryDirectory() {
        FileRepositoryProvider provider = Lookup.getDefault().lookup(FileRepositoryProvider.class);
        this.setRepositoryDirectoryName(provider.getDefaultFileRepositoryDirectory().getAbsolutePath());
    }

    private void displayRepositoryDirectoryInfo() {
        FileRepositoryProvider provider = Lookup.getDefault().lookup(FileRepositoryProvider.class);
        String repositoryFileName = provider.getFileRepositoryFileName(FilenameTokens.FULL_PATH);
        String repositoryPattern = FileUtil.getAbsolutePathnamePrefix(repositoryFileName);
        String message = Bundle.getString(MiscSettingsPanel.class, "MiscSettingsPanel.RepositoryDirectoryInfo.Text", repositoryPattern);
        MessageDisplayer.information(this, message);
    }

    private void setDisplaySearchButton() {
        this.setDisplaySearchButton(this.checkBoxDisplaySearchButton.isSelected());
    }

    private void setDisplaySearchButton(boolean display) {
        this.prefs.setBoolean("UserSettings.DisplaySearchButton", display);
    }

    private void setDisplayWordsetsEditPanel() {
        boolean display = this.checkBoxDisplayWordsetsEditPanel.isSelected();
        this.prefs.setBoolean("UserSettings.DisplayWordSettingsEditPanel", display);
    }

    private void setCopyMoveFiles() {
        boolean isConfirmOverwrite = this.radioButtonCopyMoveFileConfirmOverwrite.isSelected();
        boolean renameSourceFileIfTargetFileExists = this.radioButtonCopyMoveFileRenameIfExists.isSelected();
        CopyMoveFilesOptions options = isConfirmOverwrite ? CopyMoveFilesOptions.CONFIRM_OVERWRITE : (renameSourceFileIfTargetFileExists ? CopyMoveFilesOptions.RENAME_SOURCE_FILE_IF_TARGET_FILE_EXISTS : CopyMoveFilesOptions.CONFIRM_OVERWRITE);
        this.setCopyMoveFilesOptions(options);
    }

    private void setCopyMoveFilesOptions(CopyMoveFilesOptions options) {
        this.prefs.setInt("UserSettings.CopyMoveFiles", options.getInt());
    }

    private void setCheckForUpdates() {
        this.setCheckForUpdates(this.checkBoxCheckForUpdates.isSelected());
    }

    private void setCheckForUpdates(boolean auto) {
        this.prefs.setBoolean("UserSettings.AutoDownloadNewerVersions", auto);
    }

    private void setUseLongXmpSidecarFileNames() {
        String message;
        if (!this.listenToUseLongXmpSidecarFileNames) {
            return;
        }
        boolean useLongSidecarFileNames = this.checkBoxUseLongXmpSidecarFileNames.isSelected();
        String string = message = useLongSidecarFileNames ? Bundle.getString(MiscSettingsPanel.class, "MiscSettingsPanel.Confirm.UseLongXmpSidecarFileNames", new Object[0]) : Bundle.getString(MiscSettingsPanel.class, "MiscSettingsPanel.Confirm.UseDefaultXmpSidecarFileNames", new Object[0]);
        if (MessageDisplayer.confirmYesNo(this, message)) {
            this.prefs.setBoolean("XmpPreferences.UsingLongSidecarFilename", useLongSidecarFileNames);
            SerialTaskExecutor executor = Lookup.getDefault().lookup(SerialTaskExecutor.class);
            RenameLongXmpSidecarFilenames task = new RenameLongXmpSidecarFilenames(useLongSidecarFileNames);
            executor.addTask(task);
        } else {
            this.listenToUseLongXmpSidecarFileNames = false;
            this.checkBoxUseLongXmpSidecarFileNames.setSelected(!useLongSidecarFileNames);
            this.listenToUseLongXmpSidecarFileNames = true;
        }
    }

    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void applySettings(PreferencesChangedEvent evt) {
        if ("UserSettings.AutoDownloadNewerVersions".equals(evt.getKey())) {
            this.checkBoxCheckForUpdates.setSelected((Boolean)evt.getNewValue());
        }
    }

    @Override
    public void restore() {
        FileRepositoryProvider provider = Lookup.getDefault().lookup(FileRepositoryProvider.class);
        this.checkBoxCheckForUpdates.setSelected(this.isCheckForUpdates());
        this.checkBoxDisplaySearchButton.setSelected(this.isDisplaySearchButton());
        this.checkBoxIsAcceptHiddenDirectories.setSelected(this.isAcceptHiddenDirectories());
        this.checkBoxEnableDeleteDirectories.setSelected(this.isDeleteDirectoriesEnabled());
        this.checkBoxDisplayWordsetsEditPanel.setSelected(WordsetPreferences.isDisplayWordsetsEditPanel());
        this.labelRepositoryDirectory.setText(provider.getFileRepositoryDirectory().getAbsolutePath());
        this.radioButtonCopyMoveFileConfirmOverwrite.setSelected(this.getCopyMoveFilesOptions().equals((Object)CopyMoveFilesOptions.CONFIRM_OVERWRITE));
        this.radioButtonCopyMoveFileRenameIfExists.setSelected(this.getCopyMoveFilesOptions().equals((Object)CopyMoveFilesOptions.RENAME_SOURCE_FILE_IF_TARGET_FILE_EXISTS));
        this.setIconRepositoryDirectory();
        this.restoreUseLongXmpSidecarFileNames();
        this.restoreTabbedPaneSettings();
        this.restoreMetaDataTextAreasColumns();
    }

    private void restoreTabbedPaneSettings() {
        if (this.prefs != null) {
            this.prefs.applyTabbedPaneSettings(PREFERENCES_KEY_TABBED_PANE, this.tabbedPane, null);
        }
    }

    private void persistMdTextAreasColumns() {
        int value = (Integer)this.spinnerMdTextAreasColumns.getModel().getValue();
        if (value >= 10 && value <= 100) {
            this.prefs.setInt("UserSettings.Columns.MetadataInputTextAreas", value);
        }
    }

    private void restoreMetaDataTextAreasColumns() {
        int value;
        if (this.prefs.containsKey("UserSettings.Columns.MetadataInputTextAreas") && (value = this.prefs.getInt("UserSettings.Columns.MetadataInputTextAreas")) >= 10 && value <= 100) {
            this.spinnerMdTextAreasColumns.getModel().setValue(value);
        }
    }

    private void restoreUseLongXmpSidecarFileNames() {
        this.listenToUseLongXmpSidecarFileNames = false;
        if (this.prefs != null && this.prefs.containsKey("XmpPreferences.UsingLongSidecarFilename")) {
            this.checkBoxUseLongXmpSidecarFileNames.setSelected(this.prefs.getBoolean("XmpPreferences.UsingLongSidecarFilename"));
        }
        this.listenToUseLongXmpSidecarFileNames = true;
    }

    private boolean isCheckForUpdates() {
        return this.prefs.containsKey("UserSettings.AutoDownloadNewerVersions") ? this.prefs.getBoolean("UserSettings.AutoDownloadNewerVersions") : true;
    }

    private boolean isDisplaySearchButton() {
        return this.prefs.containsKey("UserSettings.DisplaySearchButton") ? this.prefs.getBoolean("UserSettings.DisplaySearchButton") : true;
    }

    private CopyMoveFilesOptions getCopyMoveFilesOptions() {
        return this.prefs.containsKey("UserSettings.CopyMoveFiles") ? CopyMoveFilesOptions.parseInteger(this.prefs.getInt("UserSettings.CopyMoveFiles")) : CopyMoveFilesOptions.CONFIRM_OVERWRITE;
    }

    @Override
    public void persist() {
        this.prefs.setTabbedPane(PREFERENCES_KEY_TABBED_PANE, this.tabbedPane, null);
    }

    private void lookupMiscOptionPages() {
        ArrayList<OptionPageProvider> providers = new ArrayList<OptionPageProvider>(Lookup.getDefault().lookupAll(OptionPageProvider.class));
        Collections.sort(providers, PositionProviderAscendingComparator.INSTANCE);
        LayerUtil.logWarningIfNotUniquePositions(providers);
        for (OptionPageProvider provider : providers) {
            if (!provider.isMiscOptionPage()) continue;
            this.addTab(provider.getComponent(), provider.getTitle(), provider.getIcon());
        }
    }

    private void addTab(Component component, String title, Icon icon) {
        if (component == null) {
            throw new NullPointerException("component == null");
        }
        if (title == null) {
            throw new NullPointerException("title == null");
        }
        this.tabbedPane.add(title, component);
        if (icon != null) {
            this.tabbedPane.setIconAt(this.tabbedPane.indexOfComponent(component), icon);
        }
    }

    @Override
    public String getHelpPageUrl() {
        return Bundle.getString(MiscSettingsPanel.class, "MiscSettingsPanel.HelpPage", new Object[0]);
    }

    private void initComponents() {
        this.buttonGroupCopyMoveFiles = new ButtonGroup();
        this.tabbedPane = new JTabbedPane();
        this.panelDefault = new JPanel();
        this.checkBoxIsAcceptHiddenDirectories = new JCheckBox();
        this.checkBoxEnableDeleteDirectories = new JCheckBox();
        this.panelCheckForUpdates = new JPanel();
        this.checkBoxCheckForUpdates = new JCheckBox();
        this.checkBoxDisplaySearchButton = new JCheckBox();
        this.checkBoxUseLongXmpSidecarFileNames = new JCheckBox();
        this.panelEditMetadata = new JPanel();
        this.panelMdTextAreasColumns = new JPanel();
        this.labelMdTextAreasColumnsPropmpt = new JLabel();
        this.spinnerMdTextAreasColumns = new JSpinner();
        this.labelMdTextAreasColumnsInfo = new JLabel();
        this.checkBoxDisplayWordsetsEditPanel = new JCheckBox();
        this.panelCopyMoveFiles = new JPanel();
        this.radioButtonCopyMoveFileConfirmOverwrite = new JRadioButton();
        this.radioButtonCopyMoveFileRenameIfExists = new JRadioButton();
        this.panelRepositoryDirectory = new JPanel();
        this.labelInfoRepositoryDirectory = new JLabel();
        this.panelButtonsRepositoryDirectory = new JPanel();
        this.buttonChooseRepositoryDirectory = new JButton();
        this.buttonSetDefaultRepositoryDirectoryName = new JButton();
        this.labelRepositoryDirectory = new JLabel();
        this.panelFill = new JPanel();
        this.panelDefault.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/misc/Bundle");
        this.checkBoxIsAcceptHiddenDirectories.setText(bundle.getString("MiscSettingsPanel.checkBoxIsAcceptHiddenDirectories.text"));
        this.checkBoxIsAcceptHiddenDirectories.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MiscSettingsPanel.this.checkBoxIsAcceptHiddenDirectoriesActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.panelDefault.add((Component)this.checkBoxIsAcceptHiddenDirectories, gridBagConstraints);
        this.checkBoxEnableDeleteDirectories.setText(bundle.getString("MiscSettingsPanel.checkBoxEnableDeleteDirectories.text"));
        this.checkBoxEnableDeleteDirectories.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MiscSettingsPanel.this.checkBoxEnableDeleteDirectoriesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.panelDefault.add((Component)this.checkBoxEnableDeleteDirectories, gridBagConstraints);
        this.panelCheckForUpdates.setLayout(new GridBagLayout());
        this.checkBoxCheckForUpdates.setText(bundle.getString("MiscSettingsPanel.checkBoxCheckForUpdates.text"));
        this.checkBoxCheckForUpdates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MiscSettingsPanel.this.checkBoxCheckForUpdatesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.panelCheckForUpdates.add((Component)this.checkBoxCheckForUpdates, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.panelDefault.add((Component)this.panelCheckForUpdates, gridBagConstraints);
        this.checkBoxDisplaySearchButton.setText(bundle.getString("MiscSettingsPanel.checkBoxDisplaySearchButton.text"));
        this.checkBoxDisplaySearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MiscSettingsPanel.this.checkBoxDisplaySearchButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.panelDefault.add((Component)this.checkBoxDisplaySearchButton, gridBagConstraints);
        this.checkBoxUseLongXmpSidecarFileNames.setText(bundle.getString("MiscSettingsPanel.checkBoxUseLongXmpSidecarFileNames.text"));
        this.checkBoxUseLongXmpSidecarFileNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MiscSettingsPanel.this.checkBoxUseLongXmpSidecarFileNamesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.panelDefault.add((Component)this.checkBoxUseLongXmpSidecarFileNames, gridBagConstraints);
        this.panelEditMetadata.setBorder(BorderFactory.createTitledBorder(bundle.getString("MiscSettingsPanel.panelEditMetadata.border.title")));
        this.panelEditMetadata.setLayout(new GridBagLayout());
        this.panelMdTextAreasColumns.setLayout(new GridBagLayout());
        this.labelMdTextAreasColumnsPropmpt.setText(bundle.getString("MiscSettingsPanel.labelMdTextAreasColumnsPropmpt.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelMdTextAreasColumns.add((Component)this.labelMdTextAreasColumnsPropmpt, gridBagConstraints);
        this.spinnerMdTextAreasColumns.setModel(new SpinnerNumberModel(40, 10, 100, 5));
        this.spinnerMdTextAreasColumns.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MiscSettingsPanel.this.spinnerMdTextAreasColumnsStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelMdTextAreasColumns.add((Component)this.spinnerMdTextAreasColumns, gridBagConstraints);
        this.labelMdTextAreasColumnsInfo.setText(bundle.getString("MiscSettingsPanel.labelMdTextAreasColumnsInfo.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelMdTextAreasColumns.add((Component)this.labelMdTextAreasColumnsInfo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelEditMetadata.add((Component)this.panelMdTextAreasColumns, gridBagConstraints);
        this.checkBoxDisplayWordsetsEditPanel.setText(bundle.getString("MiscSettingsPanel.checkBoxDisplayWordsetsEditPanel.text"));
        this.checkBoxDisplayWordsetsEditPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MiscSettingsPanel.this.checkBoxDisplayWordsetsEditPanelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEditMetadata.add((Component)this.checkBoxDisplayWordsetsEditPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.panelDefault.add((Component)this.panelEditMetadata, gridBagConstraints);
        this.panelCopyMoveFiles.setBorder(BorderFactory.createTitledBorder(bundle.getString("MiscSettingsPanel.panelCopyMoveFiles.border.title")));
        this.panelCopyMoveFiles.setLayout(new GridBagLayout());
        this.buttonGroupCopyMoveFiles.add(this.radioButtonCopyMoveFileConfirmOverwrite);
        this.radioButtonCopyMoveFileConfirmOverwrite.setText(bundle.getString("MiscSettingsPanel.radioButtonCopyMoveFileConfirmOverwrite.text"));
        this.radioButtonCopyMoveFileConfirmOverwrite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MiscSettingsPanel.this.radioButtonCopyMoveFileConfirmOverwriteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelCopyMoveFiles.add((Component)this.radioButtonCopyMoveFileConfirmOverwrite, gridBagConstraints);
        this.buttonGroupCopyMoveFiles.add(this.radioButtonCopyMoveFileRenameIfExists);
        this.radioButtonCopyMoveFileRenameIfExists.setText(bundle.getString("MiscSettingsPanel.radioButtonCopyMoveFileRenameIfExists.text"));
        this.radioButtonCopyMoveFileRenameIfExists.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MiscSettingsPanel.this.radioButtonCopyMoveFileRenameIfExistsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelCopyMoveFiles.add((Component)this.radioButtonCopyMoveFileRenameIfExists, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.panelDefault.add((Component)this.panelCopyMoveFiles, gridBagConstraints);
        this.panelRepositoryDirectory.setBorder(BorderFactory.createTitledBorder(bundle.getString("MiscSettingsPanel.panelRepositoryDirectory.border.title")));
        this.panelRepositoryDirectory.setLayout(new GridBagLayout());
        this.labelInfoRepositoryDirectory.setText(bundle.getString("MiscSettingsPanel.labelInfoRepositoryDirectory.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelRepositoryDirectory.add((Component)this.labelInfoRepositoryDirectory, gridBagConstraints);
        this.panelButtonsRepositoryDirectory.setLayout(new GridLayout(1, 0, 5, 0));
        this.buttonChooseRepositoryDirectory.setText(bundle.getString("MiscSettingsPanel.buttonChooseRepositoryDirectory.text"));
        this.buttonChooseRepositoryDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MiscSettingsPanel.this.buttonChooseRepositoryDirectoryActionPerformed(evt);
            }
        });
        this.panelButtonsRepositoryDirectory.add(this.buttonChooseRepositoryDirectory);
        this.buttonSetDefaultRepositoryDirectoryName.setText(bundle.getString("MiscSettingsPanel.buttonSetDefaultRepositoryDirectoryName.text"));
        this.buttonSetDefaultRepositoryDirectoryName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MiscSettingsPanel.this.buttonSetDefaultRepositoryDirectoryNameActionPerformed(evt);
            }
        });
        this.panelButtonsRepositoryDirectory.add(this.buttonSetDefaultRepositoryDirectoryName);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelRepositoryDirectory.add((Component)this.panelButtonsRepositoryDirectory, gridBagConstraints);
        this.labelRepositoryDirectory.setText(" ");
        this.labelRepositoryDirectory.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelRepositoryDirectory.add((Component)this.labelRepositoryDirectory, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.panelDefault.add((Component)this.panelRepositoryDirectory, gridBagConstraints);
        GroupLayout panelFillLayout = new GroupLayout(this.panelFill);
        this.panelFill.setLayout(panelFillLayout);
        panelFillLayout.setHorizontalGroup(panelFillLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panelFillLayout.setVerticalGroup(panelFillLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.panelDefault.add((Component)this.panelFill, gridBagConstraints);
        this.tabbedPane.addTab(bundle.getString("MiscSettingsPanel.panelDefault.TabConstraints.tabTitle"), this.panelDefault);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane).addContainerGap()));
    }

    private void checkBoxCheckForUpdatesActionPerformed(ActionEvent evt) {
        this.setCheckForUpdates();
    }

    private void radioButtonCopyMoveFileRenameIfExistsActionPerformed(ActionEvent evt) {
        this.setCopyMoveFiles();
    }

    private void radioButtonCopyMoveFileConfirmOverwriteActionPerformed(ActionEvent evt) {
        this.setCopyMoveFiles();
    }

    private void checkBoxIsAcceptHiddenDirectoriesActionPerformed(ActionEvent evt) {
        this.setAcceptHiddenDirectories();
    }

    private void buttonChooseRepositoryDirectoryActionPerformed(ActionEvent evt) {
        this.chooseRepositoryDirectory();
    }

    private void buttonSetDefaultRepositoryDirectoryNameActionPerformed(ActionEvent evt) {
        this.setDefaultRepositoryDirectory();
        this.displayRepositoryDirectoryInfo();
    }

    private void checkBoxDisplaySearchButtonActionPerformed(ActionEvent evt) {
        this.setDisplaySearchButton();
    }

    private void checkBoxDisplayWordsetsEditPanelActionPerformed(ActionEvent evt) {
        this.setDisplayWordsetsEditPanel();
    }

    private void checkBoxUseLongXmpSidecarFileNamesActionPerformed(ActionEvent evt) {
        this.setUseLongXmpSidecarFileNames();
    }

    private void spinnerMdTextAreasColumnsStateChanged(ChangeEvent evt) {
        this.persistMdTextAreasColumns();
    }

    private void checkBoxEnableDeleteDirectoriesActionPerformed(ActionEvent evt) {
        this.setDeleteDirectoriesEnabled();
    }
}

