/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.thumbnails.OriginOfDisplayedThumbnails;
import org.jphototagger.domain.thumbnails.event.ThumbnailsChangedEvent;
import org.jphototagger.domain.thumbnails.event.ThumbnailsSelectionChangedEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.program.module.thumbnails.ThumbnailsPanel;
import org.jphototagger.program.module.thumbnails.ThumbnailsPopupMenu;
import org.jphototagger.program.resource.GUI;

public final class MenuItemEnablerController
implements PopupMenuListener {
    private final Map<JMenuItem, List<OriginOfDisplayedThumbnails>> originsOfItemsRequiresSelImages = new HashMap<JMenuItem, List<OriginOfDisplayedThumbnails>>();
    private final List<JMenuItem> itemsRequiresSelImages = new ArrayList<JMenuItem>();

    public MenuItemEnablerController() {
        this.init();
        this.listen();
    }

    private void listen() {
        ThumbnailsPopupMenu.INSTANCE.addPopupMenuListener(this);
        AnnotationProcessor.process(this);
    }

    private void init() {
        ArrayList<OriginOfDisplayedThumbnails> contents = new ArrayList<OriginOfDisplayedThumbnails>();
        ThumbnailsPopupMenu popupThumbnails = ThumbnailsPopupMenu.INSTANCE;
        contents.add(OriginOfDisplayedThumbnails.FILES_IN_SAME_DIRECTORY);
        contents.add(OriginOfDisplayedThumbnails.FILES_IN_DIRECTORY_RECURSIVE);
        contents.add(OriginOfDisplayedThumbnails.FILES_IN_SAME_FAVORITE_DIRECTORY);
        contents.add(OriginOfDisplayedThumbnails.FILES_IN_FAVORITE_DIRECTORY_RECURSIVE);
        this.originsOfItemsRequiresSelImages.put(ThumbnailsPopupMenu.INSTANCE.getItemFileSystemMoveFiles(), contents);
        contents = new ArrayList();
        contents.add(OriginOfDisplayedThumbnails.FILES_OF_AN_IMAGE_COLLECTION);
        this.originsOfItemsRequiresSelImages.put(popupThumbnails.getItemDeleteFromImageCollection(), contents);
        this.itemsRequiresSelImages.add(popupThumbnails.getItemUpdateThumbnail());
        this.itemsRequiresSelImages.add(popupThumbnails.getItemUpdateMetadata());
        this.itemsRequiresSelImages.add(popupThumbnails.getItemDeleteImageFromRepository());
        this.itemsRequiresSelImages.add(popupThumbnails.getItemCreateImageCollection());
        this.itemsRequiresSelImages.add(popupThumbnails.getItemAddToImageCollection());
        this.itemsRequiresSelImages.add(popupThumbnails.getItemRotateThumbnail90());
        this.itemsRequiresSelImages.add(popupThumbnails.getItemRotateThumbnai180());
        this.itemsRequiresSelImages.add(popupThumbnails.getItemRotateThumbnail270());
        this.itemsRequiresSelImages.add(popupThumbnails.getItemFileSystemCopyToDirectory());
        this.itemsRequiresSelImages.add(popupThumbnails.getItemFileSystemDeleteFiles());
        this.itemsRequiresSelImages.add(popupThumbnails.getItemFileSystemRenameFiles());
        this.itemsRequiresSelImages.add(popupThumbnails.getItemPick());
        this.itemsRequiresSelImages.add(popupThumbnails.getItemCopyMetadata());
        this.itemsRequiresSelImages.add(popupThumbnails.getItemCopyToClipboard());
        this.itemsRequiresSelImages.add(popupThumbnails.getItemCutToClipboard());
        this.itemsRequiresSelImages.add(popupThumbnails.getItemFileSystemCopyToDirectory());
        this.itemsRequiresSelImages.add(popupThumbnails.getItemFileSystemDeleteFiles());
        this.itemsRequiresSelImages.add(popupThumbnails.getItemFileSystemMoveFiles());
        this.itemsRequiresSelImages.add(popupThumbnails.getItemFileSystemRenameFiles());
        this.itemsRequiresSelImages.add(popupThumbnails.getItemPasteMetadata());
        this.itemsRequiresSelImages.add(popupThumbnails.getItemReject());
        this.itemsRequiresSelImages.add(popupThumbnails.getMenuImageCollection());
        this.itemsRequiresSelImages.add(popupThumbnails.getMenuMetadata());
        this.itemsRequiresSelImages.add(popupThumbnails.getMenuPlugins());
        this.itemsRequiresSelImages.add(popupThumbnails.getMenuPrograms());
        this.itemsRequiresSelImages.add(popupThumbnails.getMenuRating());
        this.itemsRequiresSelImages.add(popupThumbnails.getMenuRotateThumbnail());
        this.itemsRequiresSelImages.add(popupThumbnails.getMenuSelection());
    }

    private void setEnabled() {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                ThumbnailsPanel tnPanel = GUI.getThumbnailsPanel();
                OriginOfDisplayedThumbnails originOfOfDisplayedThumbnails = tnPanel.getOriginOfDisplayedThumbnails();
                boolean fileSelected = tnPanel.isAFileSelected();
                for (JMenuItem item : MenuItemEnablerController.this.itemsRequiresSelImages) {
                    item.setEnabled(fileSelected);
                }
                for (JMenuItem item : MenuItemEnablerController.this.originsOfItemsRequiresSelImages.keySet()) {
                    item.setEnabled(fileSelected && ((List)MenuItemEnablerController.this.originsOfItemsRequiresSelImages.get(item)).contains((Object)originOfOfDisplayedThumbnails));
                }
                ThumbnailsPopupMenu.INSTANCE.getItemOpenFilesWithStandardApp().setEnabled(fileSelected);
                ThumbnailsPopupMenu.INSTANCE.getMenuPrograms().setEnabled(fileSelected);
            }
        });
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
        Object source = evt.getSource();
        if (source == ThumbnailsPopupMenu.INSTANCE) {
            this.popupMenuThumbnailsBecomeVisible();
        }
    }

    private void popupMenuThumbnailsBecomeVisible() {
        ThumbnailsPanel tnPanel = GUI.getThumbnailsPanel();
        ThumbnailsPopupMenu popupThumbnails = ThumbnailsPopupMenu.INSTANCE;
        popupThumbnails.getItemSelectAll().setEnabled(tnPanel.hasFiles());
        popupThumbnails.getItemSelectNothing().setEnabled(tnPanel.isAFileSelected());
    }

    @EventSubscriber(eventClass=ThumbnailsSelectionChangedEvent.class)
    public void thumbnailsSelectionChanged(ThumbnailsSelectionChangedEvent evt) {
        this.setEnabled();
    }

    @EventSubscriber(eventClass=ThumbnailsChangedEvent.class)
    public void thumbnailsChanged(ThumbnailsChangedEvent evt) {
        this.setEnabled();
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent evt) {
    }
}

