/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.misc;

import java.util.Arrays;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.JXTree;
import org.jphototagger.api.windows.SelectionItemSelectedEvent;
import org.jphototagger.domain.thumbnails.OriginOfDisplayedThumbnails;
import org.jphototagger.domain.thumbnails.event.ThumbnailsChangedEvent;
import org.jphototagger.program.resource.GUI;

public final class MaximumOneTreeOrListItemSelectedController
implements TreeSelectionListener,
ListSelectionListener {
    private boolean listen = true;
    private final List<JXList> selectionLists = GUI.getAppPanel().getSelectionLists();
    private final List<JTree> selectionTrees = GUI.getAppPanel().getSelectionTrees();

    public MaximumOneTreeOrListItemSelectedController() {
        this.listen();
    }

    private void listen() {
        for (JTree tree : this.selectionTrees) {
            tree.addTreeSelectionListener(this);
        }
        for (JXList list : this.selectionLists) {
            list.addListSelectionListener(this);
        }
        AnnotationProcessor.process(this);
    }

    @EventSubscriber(eventClass=SelectionItemSelectedEvent.class)
    public void sectionItemSelected(SelectionItemSelectedEvent evt) {
        Object source = evt.getSource();
        boolean sourceIsKnownList = false;
        boolean sourceIsKnownTree = false;
        if (source instanceof JXList) {
            sourceIsKnownList = this.selectionLists.contains((JXList)source);
        }
        if (source instanceof JXTree) {
            sourceIsKnownTree = this.selectionTrees.contains((JXTree)source);
        }
        if (!sourceIsKnownList && !sourceIsKnownTree) {
            this.clearSelectionAllTrees();
            this.clearSelectionAllLists();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        Object o = evt.getSource();
        if (this.listen && evt.isAddedPath() && o instanceof JTree) {
            this.handleTreeSelected((JTree)o);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        JXList list;
        Object o = evt.getSource();
        if (this.listen && !evt.getValueIsAdjusting() && o instanceof JXList && (list = (JXList)o).getSelectedIndex() >= 0) {
            this.handleListSelected(list);
        }
    }

    private void handleTreeSelected(JTree currentSelectedTree) {
        EventBus.publish(new SelectionItemSelectedEvent(currentSelectedTree, Arrays.asList(currentSelectedTree.getSelectionPaths())));
        this.clearSelectionAllLists();
        this.clearSelectionOtherTrees(currentSelectedTree);
    }

    private void handleListSelected(JXList currentSelectedList) {
        EventBus.publish(new SelectionItemSelectedEvent(currentSelectedList, currentSelectedList.getSelectedValuesList()));
        this.clearSelectionAllTrees();
        this.clearSelectionOtherLists(currentSelectedList);
    }

    private void clearSelectionOtherLists(JXList list) {
        this.listen = false;
        for (JXList aList : GUI.getAppPanel().getSelectionLists()) {
            if (aList == list || aList.isSelectionEmpty()) continue;
            aList.clearSelection();
        }
        this.listen = true;
    }

    private void clearSelectionOtherTrees(JTree tree) {
        this.listen = false;
        for (JTree aTree : GUI.getAppPanel().getSelectionTrees()) {
            if (aTree == tree || aTree.getSelectionCount() <= 0) continue;
            aTree.clearSelection();
        }
        this.listen = true;
    }

    private void clearSelectionAllTrees() {
        for (JTree tree : GUI.getAppPanel().getSelectionTrees()) {
            tree.clearSelection();
        }
    }

    private void clearSelectionAllLists() {
        for (JXList list : GUI.getAppPanel().getSelectionLists()) {
            list.clearSelection();
        }
    }

    @EventSubscriber(eventClass=ThumbnailsChangedEvent.class)
    public void thumbnailsChanged(ThumbnailsChangedEvent evt) {
        OriginOfDisplayedThumbnails origin = evt.getOriginOfDisplayedThumbnails();
        if (OriginOfDisplayedThumbnails.UNDEFINED_ORIGIN.equals((Object)origin)) {
            this.clearSelectionAllTrees();
            this.clearSelectionAllLists();
        }
    }
}

