/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.misc;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.lib.api.LookAndFeelChangedEvent;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.util.TabbedPaneUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.datatransfer.DragListItemsTransferHandler;
import org.jphototagger.program.datatransfer.Flavor;
import org.jphototagger.program.misc.MiscXmpMetadataPanel;
import org.jphototagger.program.module.keywords.KeywordsPanel;
import org.jphototagger.program.module.metadatatemplates.MetaDataTemplatesPanel;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public class InputHelperDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    public static final InputHelperDialog INSTANCE = new InputHelperDialog();
    private static final String KEY_SEL_INDEX_TABBED_PANE = "InputHelperDialog.SelIndexTabbedPane";
    private static final String KEY_TREE_MISC_XMP = "InputHelperDialog.TreeMiscXmpMetadata";
    private JLabel labelInfo;
    private KeywordsPanel panelKeywords;
    private MetaDataTemplatesPanel panelMetaDataTemplates;
    private MiscXmpMetadataPanel panelMiscXmpMetadata;
    private JTabbedPane tabbedPane;

    private InputHelperDialog() {
        super((Frame)GUI.getAppFrame(), false);
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.setHelpPage();
        this.setKeyCards();
        TabbedPaneUtil.setMnemonics(this.tabbedPane);
        AnnotationProcessor.process(this);
    }

    private void setKeyCards() {
        this.panelKeywords.setKeyCard("InputHelperDialog.Keywords.Card");
        this.panelKeywords.setKeyTree("InputHelperDialog.Keywords.Tree");
    }

    private void setHelpPage() {
        this.setHelpPageUrl(Bundle.getString(InputHelperDialog.class, "InputHelperDialog.HelpPage", new Object[0]));
    }

    public void setModelKeywords(ListModel<?> model) {
        if (model == null) {
            throw new NullPointerException("model == null");
        }
        this.panelKeywords.setListModel(model);
    }

    private void readProperties() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        this.panelKeywords.readProperties();
        prefs.applyTreeSettings(KEY_TREE_MISC_XMP, this.panelMiscXmpMetadata.getTree());
        int selIndexTabbedPane = prefs.getInt(KEY_SEL_INDEX_TABBED_PANE);
        if (selIndexTabbedPane >= 0 && selIndexTabbedPane < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setSelectedIndex(selIndexTabbedPane);
        }
    }

    private void writeProperties() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setInt(KEY_SEL_INDEX_TABBED_PANE, this.tabbedPane.getSelectedIndex());
        prefs.setTree(KEY_TREE_MISC_XMP, this.panelMiscXmpMetadata.getTree());
        this.panelKeywords.writeProperties();
    }

    @Override
    protected void escape() {
        this.setVisible(false);
    }

    public KeywordsPanel getPanelKeywords() {
        return this.panelKeywords;
    }

    public MetaDataTemplatesPanel getPanelMetaDataTemplates() {
        return this.panelMetaDataTemplates;
    }

    public MiscXmpMetadataPanel getPanelMiscXmpMetadata() {
        return this.panelMiscXmpMetadata;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.readProperties();
        } else {
            this.writeProperties();
        }
        super.setVisible(visible);
    }

    @EventSubscriber(eventClass=LookAndFeelChangedEvent.class)
    public void lookAndFeelChanged(LookAndFeelChangedEvent evt) {
        SwingUtilities.updateComponentTreeUI(this);
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.panelKeywords = new KeywordsPanel();
        this.panelMiscXmpMetadata = new MiscXmpMetadataPanel();
        this.panelMetaDataTemplates = new MetaDataTemplatesPanel();
        this.panelMetaDataTemplates.getList().setTransferHandler(new DragListItemsTransferHandler(Flavor.METADATA_TEMPLATES));
        this.labelInfo = new JLabel();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/misc/Bundle");
        this.setTitle(bundle.getString("InputHelperDialog.title"));
        this.setAlwaysOnTop(true);
        this.setName("Form");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                InputHelperDialog.this.formWindowClosing(evt);
            }
        });
        this.tabbedPane.setTabLayoutPolicy(1);
        this.tabbedPane.setName("tabbedPane");
        this.panelKeywords.setName("panelKeywords");
        this.tabbedPane.addTab(bundle.getString("InputHelperDialog.panelKeywords.TabConstraints.tabTitle"), this.panelKeywords);
        this.panelMiscXmpMetadata.setName("panelMiscXmpMetadata");
        this.tabbedPane.addTab(bundle.getString("InputHelperDialog.panelMiscXmpMetadata.TabConstraints.tabTitle"), this.panelMiscXmpMetadata);
        this.panelMetaDataTemplates.setName("panelMetaDataTemplates");
        this.tabbedPane.addTab(bundle.getString("InputHelperDialog.panelMetaDataTemplates.TabConstraints.tabTitle"), this.panelMetaDataTemplates);
        this.labelInfo.setText(bundle.getString("InputHelperDialog.labelInfo.text"));
        this.labelInfo.setName("labelInfo");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane, GroupLayout.Alignment.TRAILING, -2, 283, Short.MAX_VALUE).addComponent(this.labelInfo, -1, 283, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -1, 254, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelInfo, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                InputHelperDialog dialog = new InputHelperDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

