/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.misc;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import org.jphototagger.program.app.ui.AppFrame;
import org.jphototagger.program.app.ui.AppPanel;
import org.jphototagger.program.resource.GUI;

public final class GoToController
implements ActionListener {
    private final Map<AppFrame.GoTo, Component> componentOfGoTo = new EnumMap<AppFrame.GoTo, Component>(AppFrame.GoTo.class);
    private final Map<AppFrame.GoTo, JTabbedPane> tabbedPaneOfGoTo = new EnumMap<AppFrame.GoTo, JTabbedPane>(AppFrame.GoTo.class);

    private void initMaps() {
        AppPanel appPanel = GUI.getAppPanel();
        this.componentOfGoTo.put(AppFrame.GoTo.IMAGE_COLLECTIONS, appPanel.getTabSelectionImageCollections());
        this.componentOfGoTo.put(AppFrame.GoTo.DIRECTORIES, appPanel.getTabSelectionDirectories());
        this.componentOfGoTo.put(AppFrame.GoTo.FAVORITES, appPanel.getTabSelectionFavoriteDirectories());
        this.componentOfGoTo.put(AppFrame.GoTo.SAVED_SEARCHES, appPanel.getTabSelectionSavedSearches());
        this.componentOfGoTo.put(AppFrame.GoTo.KEYWORDS_SEL, appPanel.getTabSelectionKeywords());
        this.componentOfGoTo.put(AppFrame.GoTo.TIMELINE, appPanel.getTabSelectionTimeline());
        this.componentOfGoTo.put(AppFrame.GoTo.MISC_METADATA, appPanel.getTabSelectionMiscMetadata());
        this.componentOfGoTo.put(AppFrame.GoTo.KEYWORDS_EDIT, appPanel.getTabEditKeywords());
        this.tabbedPaneOfGoTo.put(AppFrame.GoTo.IMAGE_COLLECTIONS, appPanel.getTabbedPaneSelection());
        this.tabbedPaneOfGoTo.put(AppFrame.GoTo.DIRECTORIES, appPanel.getTabbedPaneSelection());
        this.tabbedPaneOfGoTo.put(AppFrame.GoTo.FAVORITES, appPanel.getTabbedPaneSelection());
        this.tabbedPaneOfGoTo.put(AppFrame.GoTo.SAVED_SEARCHES, appPanel.getTabbedPaneSelection());
        this.tabbedPaneOfGoTo.put(AppFrame.GoTo.KEYWORDS_SEL, appPanel.getTabbedPaneSelection());
        this.tabbedPaneOfGoTo.put(AppFrame.GoTo.TIMELINE, appPanel.getTabbedPaneSelection());
        this.tabbedPaneOfGoTo.put(AppFrame.GoTo.MISC_METADATA, appPanel.getTabbedPaneSelection());
        this.tabbedPaneOfGoTo.put(AppFrame.GoTo.KEYWORDS_EDIT, appPanel.getTabbedPaneMetadata());
    }

    public GoToController() {
        this.initMaps();
        this.listen();
    }

    private void listen() {
        AppFrame appFrame = GUI.getAppFrame();
        for (AppFrame.GoTo gt : AppFrame.GoTo.values()) {
            JMenuItem menuItem = appFrame.getMenuItemOfGoto(gt);
            menuItem.addActionListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.selectComponent((JMenuItem)evt.getSource());
    }

    private void selectComponent(JMenuItem item) {
        AppFrame.GoTo goTo = GUI.getAppFrame().getGotoOfMenuItem(item);
        if (this.tabbedPaneOfGoTo.containsKey((Object)goTo)) {
            this.tabbedPaneOfGoTo.get((Object)goTo).setSelectedComponent(this.componentOfGoTo.get((Object)goTo));
            this.componentOfGoTo.get((Object)goTo).requestFocusInWindow();
        }
    }
}

