/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.misc;

import java.io.File;
import java.util.List;
import javax.swing.DefaultListModel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.repository.AutoscanDirectoriesRepository;
import org.jphototagger.domain.repository.Repository;
import org.jphototagger.domain.repository.event.autoscandirectories.AutoscanDirectoryDeletedEvent;
import org.jphototagger.domain.repository.event.autoscandirectories.AutoscanDirectoryInsertedEvent;
import org.openide.util.Lookup;

public final class AutoscanDirectoriesListModel
extends DefaultListModel<Object> {
    private static final long serialVersionUID = 1L;
    private final AutoscanDirectoriesRepository autoscanDirsRepo = Lookup.getDefault().lookup(AutoscanDirectoriesRepository.class);

    public AutoscanDirectoriesListModel() {
        this.addElements();
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    private void addElements() {
        Repository repo = Lookup.getDefault().lookup(Repository.class);
        if (repo == null || !repo.isInit()) {
            return;
        }
        List<File> directories = this.autoscanDirsRepo.findAllAutoscanDirectories();
        for (File directory : directories) {
            if (!directory.isDirectory() || !directory.exists()) continue;
            this.addElement(directory);
        }
    }

    private void removeDirectory(File directory) {
        if (this.contains(directory)) {
            this.removeElement(directory);
        }
    }

    private void addDirectory(File directory) {
        if (!this.contains(directory)) {
            this.addElement(directory);
        }
    }

    @EventSubscriber(eventClass=AutoscanDirectoryInsertedEvent.class)
    public void directoryInserted(AutoscanDirectoryInsertedEvent evt) {
        File directory = evt.getDirectory();
        this.addDirectory(directory);
    }

    @EventSubscriber(eventClass=AutoscanDirectoryDeletedEvent.class)
    public void directoryDeleted(AutoscanDirectoryDeletedEvent evt) {
        File directory = evt.getDirectory();
        this.removeDirectory(directory);
    }
}

