/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.selections.AutoCompleteData;
import org.jphototagger.domain.metadata.selections.AutoCompleteDataOfMetaDataValue;
import org.jphototagger.domain.metadata.selections.FastSearchMetaDataValues;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.lib.swing.util.Autocomplete;
import org.openide.util.Lookup;

public final class AutocompleteUtil {
    private AutocompleteUtil() {
    }

    public static void addAutocompleteData(MetaDataValue value, Autocomplete ac, Xmp xmp) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        if (ac == null) {
            throw new NullPointerException("ac == null");
        }
        if (xmp == null) {
            throw new NullPointerException("xmp == null");
        }
        AutoCompleteData acData = AutoCompleteDataOfMetaDataValue.INSTANCE.get(value);
        if (acData == null || !AutocompleteUtil.isUpdateAutocomplete()) {
            return;
        }
        AutocompleteUtil.add(value, acData, ac, xmp);
    }

    private static boolean isUpdateAutocomplete() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.UpdateAutocomplete") ? prefs.getBoolean("UserSettings.UpdateAutocomplete") : true;
    }

    public static void addFastSearchAutocompleteData(Autocomplete ac, Xmp xmp) {
        if (ac == null) {
            throw new NullPointerException("ac == null");
        }
        if (xmp == null) {
            throw new NullPointerException("xmp == null");
        }
        AutoCompleteData acData = AutoCompleteDataOfMetaDataValue.INSTANCE.getFastSearchData();
        if (acData == null || !AutocompleteUtil.isUpdateAutocomplete()) {
            return;
        }
        for (MetaDataValue vaue : FastSearchMetaDataValues.get()) {
            AutocompleteUtil.add(vaue, acData, ac, xmp);
        }
    }

    private static void add(MetaDataValue value, AutoCompleteData acData, Autocomplete ac, Xmp xmp) {
        Object xmpValue = xmp.getValue(value);
        if (xmpValue == null || !AutocompleteUtil.isUpdateAutocomplete()) {
            return;
        }
        List<String> words = new ArrayList<String>();
        if (xmpValue instanceof String) {
            words.add((String)xmpValue);
        } else if (xmpValue instanceof List) {
            boolean isStringList;
            List list = (List)xmpValue;
            boolean bl = isStringList = list.size() > 0 ? list.get(0) instanceof String : false;
            if (isStringList) {
                words = list;
            }
        }
        for (String word : words) {
            acData.add(word);
            ac.add(word);
        }
    }

    public static void addAutocompleteData(MetaDataValue value, Autocomplete ac, Collection<String> words) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        if (ac == null) {
            throw new NullPointerException("ac == null");
        }
        if (words == null) {
            throw new NullPointerException("words == null");
        }
        AutoCompleteData acData = AutoCompleteDataOfMetaDataValue.INSTANCE.get(value);
        if (acData == null || !AutocompleteUtil.isUpdateAutocomplete()) {
            return;
        }
        for (String word : words) {
            acData.add(word);
            ac.add(word);
        }
    }
}

