/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.help;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import org.jphototagger.lib.awt.DesktopUtil;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.Main;

final class ShowPdfUserManualAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ShowPdfUserManualAction.class.getName());

    ShowPdfUserManualAction() {
        super(Bundle.getString(ShowPdfUserManualAction.class, "ShowPdfUserManualAction.Name", new Object[0]));
        this.putValue("SmallIcon", IconUtil.getImageIcon(ShowPdfUserManualAction.class, "pdf_manual.png"));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.openPdfUserManual();
    }

    private void openPdfUserManual() {
        File manualPath = ShowPdfUserManualAction.getPdfUserManualPath();
        if (manualPath != null) {
            DesktopUtil.open(manualPath, "JPhotoTagger.PdfViewer");
        }
    }

    private static File getPdfUserManualPath() {
        String manualPath = "";
        try {
            File jarPath = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            ShowPdfUserManualAction.logJar(jarPath);
            if (jarPath.exists() && jarPath.getParentFile() != null) {
                File dir = jarPath.getParentFile();
                String pathPrefix = dir.getAbsolutePath() + File.separator + "Manual";
                manualPath = pathPrefix + "_" + Locale.getDefault().getLanguage() + ".pdf";
                File fileLocaleSensitive = new File(manualPath);
                ShowPdfUserManualAction.logIfNotExists(fileLocaleSensitive);
                if (fileLocaleSensitive.exists()) {
                    return fileLocaleSensitive;
                }
                manualPath = pathPrefix + "_de.pdf";
                File fileDefault = new File(manualPath);
                ShowPdfUserManualAction.logIfNotExists(fileDefault);
                if (fileDefault.exists()) {
                    return fileDefault;
                }
            }
        }
        catch (Throwable t) {
            Logger.getLogger(ShowPdfUserManualAction.class.getName()).log(Level.SEVERE, null, t);
        }
        String message = Bundle.getString(ShowPdfUserManualAction.class, "HelpController.Error.NoPdfFile", manualPath);
        MessageDisplayer.error(null, message);
        return null;
    }

    private static void logJar(File jarPath) {
        ShowPdfUserManualAction.logJarFile(jarPath);
        ShowPdfUserManualAction.logJarDir(jarPath.getParentFile());
        ShowPdfUserManualAction.logIfNotExists(jarPath);
        ShowPdfUserManualAction.logIfNotExists(jarPath.getParentFile());
    }

    private static void logJarDir(File jarPath) {
        File parentFile = jarPath.getParentFile();
        LOGGER.log(Level.FINEST, "Got folder to JAR file: ''{0}''", parentFile);
    }

    private static void logJarFile(File jarPath) {
        LOGGER.log(Level.FINEST, "Got path to JAR file: ''{0}''", jarPath);
    }

    private static void logIfNotExists(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            LOGGER.log(Level.FINEST, "File ''{0}'' does not exist", file);
        }
    }
}

