/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.help;

import java.awt.Desktop;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.help.ShowHelpAction;

final class SendMail {
    private static final Logger LOGGER = Logger.getLogger(SendMail.class.getName());

    static void sendMail(String to, String subject, String body) {
        try {
            URI uri = SendMail.getMailtoUri(to, subject, body);
            LOGGER.log(Level.INFO, "Sending email to this URI: ''{0}''", uri);
            Desktop.getDesktop().mail(uri);
        }
        catch (Throwable t) {
            Logger.getLogger(ShowHelpAction.class.getName()).log(Level.SEVERE, null, t);
            String message = Bundle.getString(ShowHelpAction.class, "SendMail.Error.SendMail", new Object[0]);
            MessageDisplayer.error(null, message);
        }
    }

    static URI getMailtoUri(String to, String subject, String body) throws URISyntaxException, UnsupportedEncodingException {
        String bodyPart = body == null || body.trim().isEmpty() ? "" : "&body=" + body;
        return new URI("mailto", to + "?subject=" + subject + bodyPart, null);
    }

    private SendMail() {
    }
}

