/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.help;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.jphototagger.lib.awt.DesktopUtil;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.app.AppInfo;
import org.jphototagger.program.app.logging.AppLoggingSystem;
import org.jphototagger.program.help.SendMail;
import org.jphototagger.program.help.ShowHelpAction;

final class SendBugReportMailAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    SendBugReportMailAction() {
        super(Bundle.getString(SendBugReportMailAction.class, "SendBugReportMailAction.Name", new Object[0]));
        this.putValue("SmallIcon", IconUtil.getImageIcon(SendBugReportMailAction.class, "mail.png"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.sentMail();
    }

    private void sentMail() {
        String mailto = "support@jphototagger.org";
        String subject = AppInfo.MAIL_SUBJECT_BUGS;
        String allMessagesLogfilePath = AppLoggingSystem.getAllMessagesLogfilePath();
        String errorMessagesLogfilePath = AppLoggingSystem.getErrorMessagesLogfilePath();
        String message = Bundle.getString(ShowHelpAction.class, "SendBugReportMailAction.Info.AttachLogfile", allMessagesLogfilePath, errorMessagesLogfilePath);
        this.openLogfileDirectory();
        SendMail.sendMail(mailto, subject, message);
    }

    private void openLogfileDirectory() {
        String message = Bundle.getString(SendBugReportMailAction.class, "SendBugReportMailAction.Confirm.OpenLogfileDir", new Object[0]);
        if (MessageDisplayer.confirmYesNo(null, message)) {
            DesktopUtil.open(AppLoggingSystem.getLofileDirectory(), "SendBugReportMailAction.OpenLogfileDirectory");
        }
    }
}

