/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.help;

import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.lib.help.HelpBrowser;
import org.jphototagger.lib.help.HelpBrowserEvent;
import org.jphototagger.lib.help.HelpBrowserListener;
import org.jphototagger.lib.help.HelpContentProvider;
import org.jphototagger.lib.help.HelpDisplayer;
import org.jphototagger.lib.help.HelpNode;
import org.jphototagger.lib.help.HelpUtil;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.StringUtil;
import org.openide.util.Lookup;

public final class HelpBrowserDisplayer
implements HelpDisplayer,
HelpContentProvider {
    private static final String KEY_CURRENT_URL = HelpBrowserDisplayer.class.getName() + ".CurrentURL";
    private static final HelpBrowser HELP_BROWSER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void browseHelp(String helpPageUrl) {
        if (StringUtil.hasContent(helpPageUrl)) {
            Class<HelpBrowser> clazz = HelpBrowser.class;
            synchronized (HelpBrowser.class) {
                HELP_BROWSER.setDisplayUrl(helpPageUrl);
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else {
            HelpBrowserDisplayer.restoreCurrentUrl();
        }
        {
            ComponentUtil.show(HELP_BROWSER);
            return;
        }
    }

    @Override
    public void displayHelp(String url) {
        HelpBrowserDisplayer.browseHelp(url);
    }

    @Override
    public String getHelpContentUrl() {
        return "/org/jphototagger/program/resource/doc/de/contents.xml";
    }

    @Override
    public int getPosition() {
        return Integer.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void restoreCurrentUrl() {
        Preferences preferences = Lookup.getDefault().lookup(Preferences.class);
        if (!preferences.containsKey(KEY_CURRENT_URL)) return;
        String currentUrl = preferences.getString(KEY_CURRENT_URL);
        Class<HelpBrowser> clazz = HelpBrowser.class;
        synchronized (HelpBrowser.class) {
            HELP_BROWSER.setDisplayUrl(currentUrl);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static void persistCurrentUrl(String currentUrl) {
        Preferences preferences = Lookup.getDefault().lookup(Preferences.class);
        preferences.setString(KEY_CURRENT_URL, currentUrl);
    }

    static {
        HelpNode rootNode = HelpUtil.createNodeFromHelpContentProviders();
        rootNode.setTitle(Bundle.getString(HelpBrowserDisplayer.class, "HelpBrowser.RootNode.Title", new Object[0]));
        HELP_BROWSER = new HelpBrowser(rootNode);
        HELP_BROWSER.setTitle(Bundle.getString(HelpBrowserDisplayer.class, "HelpBrowserDisplayer.Title", new Object[0]));
        HelpBrowserDisplayer.restoreCurrentUrl();
        HELP_BROWSER.addHelpBrowserListener(new ContentsHelpBrowserListener());
    }

    private static class ContentsHelpBrowserListener
    implements HelpBrowserListener {
        private ContentsHelpBrowserListener() {
        }

        @Override
        public void actionPerformed(HelpBrowserEvent evt) {
            if (evt.getType().equals((Object)HelpBrowserEvent.Type.URL_CHANGED)) {
                String currentUrl = HELP_BROWSER.toPageUrl(evt.getUrl());
                HelpBrowserDisplayer.persistCurrentUrl(currentUrl);
            }
        }
    }
}

