/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.filefilter;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.component.DisplayNameProvider;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpRatingMetaDataValue;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.xmp.XmpMetadata;

public final class XmpRatingFileFilter
implements FileFilter,
DisplayNameProvider {
    private final int rating;
    private static final String DISPLAY_NAME_UNDEFINED = Bundle.getString(XmpRatingFileFilter.class, "XmpRatingFileFilter.DisplayName.Undefined", new Object[0]);
    private static final Map<Integer, String> DISPLAY_NAME_OF_RATING = new HashMap<Integer, String>();

    public XmpRatingFileFilter(int rating) {
        this.rating = rating;
    }

    @Override
    public boolean accept(File imageFile) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        Xmp xmp = null;
        try {
            xmp = XmpMetadata.getXmpFromSidecarFileOf(imageFile);
        }
        catch (IOException ex) {
            Logger.getLogger(XmpRatingFileFilter.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (xmp == null) {
            return false;
        }
        Object fileRating = xmp.getValue(XmpRatingMetaDataValue.INSTANCE);
        if (fileRating instanceof Long) {
            return (Long)fileRating >= (long)this.rating;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XmpRatingFileFilter other = (XmpRatingFileFilter)obj;
        return this.rating == other.rating;
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + this.rating;
        return hash;
    }

    @Override
    public String getDisplayName() {
        String displayName = DISPLAY_NAME_OF_RATING.get(this.rating);
        return displayName == null ? DISPLAY_NAME_UNDEFINED : displayName;
    }

    static {
        DISPLAY_NAME_OF_RATING.put(1, Bundle.getString(XmpRatingFileFilter.class, "XmpRatingFileFilter.DisplayName.1Star", new Object[0]));
        DISPLAY_NAME_OF_RATING.put(2, Bundle.getString(XmpRatingFileFilter.class, "XmpRatingFileFilter.DisplayName.2Stars", new Object[0]));
        DISPLAY_NAME_OF_RATING.put(3, Bundle.getString(XmpRatingFileFilter.class, "XmpRatingFileFilter.DisplayName.3Stars", new Object[0]));
        DISPLAY_NAME_OF_RATING.put(4, Bundle.getString(XmpRatingFileFilter.class, "XmpRatingFileFilter.DisplayName.4Stars", new Object[0]));
        DISPLAY_NAME_OF_RATING.put(5, Bundle.getString(XmpRatingFileFilter.class, "XmpRatingFileFilter.DisplayName.5Stars", new Object[0]));
    }
}

