/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.filefilter;

import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.filetypes.UserDefinedFileType;
import org.jphototagger.domain.repository.UserDefinedFileTypesRepository;
import org.jphototagger.domain.repository.event.userdefinedfiletypes.UserDefinedFileTypeDeletedEvent;
import org.jphototagger.domain.repository.event.userdefinedfiletypes.UserDefinedFileTypeInsertedEvent;
import org.jphototagger.domain.repository.event.userdefinedfiletypes.UserDefinedFileTypeUpdatedEvent;
import org.jphototagger.domain.thumbnails.ThumbnailCreator;
import org.jphototagger.lib.io.filefilter.RegexFileFilter;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.filefilter.NoXmpFileFilter;
import org.jphototagger.program.filefilter.XmpRatingFileFilter;
import org.openide.util.Lookup;

public final class AppFileFilters {
    public static final NoXmpFileFilter NO_XMP = NoXmpFileFilter.INSTANCE;
    public static final FileFilter XMP_RATING_1_STAR = new XmpRatingFileFilter(1);
    public static final FileFilter XMP_RATING_2_STARS = new XmpRatingFileFilter(2);
    public static final FileFilter XMP_RATING_3_STARS = new XmpRatingFileFilter(3);
    public static final FileFilter XMP_RATING_4_STARS = new XmpRatingFileFilter(4);
    public static final FileFilter XMP_RATING_5_STARS = new XmpRatingFileFilter(5);
    private final Set<String> allAcceptedSuffixes = new HashSet<String>();
    private final Set<String> acceptedRawSuffixes = new HashSet<String>();
    private final Set<String> userDefinedFileTypesSuffixes = new HashSet<String>();
    private RegexFileFilter allAcceptedImageFilesFilter;
    private final RegexFileFilter acceptedRawFilesFilter;
    private final RegexFileFilter acceptedDngFilesFilter = this.createAcceptedDngFilesFiter();
    private final RegexFileFilter acceptedJpegFilesFilter = this.createAcceptedJpegFilesFiter();
    private final RegexFileFilter acceptedTiffFilesFilter = this.createAcceptedTiffFilesFiter();
    private RegexFileFilter userDefinedFileTypesFilter;
    public static final AppFileFilters INSTANCE = new AppFileFilters();

    private AppFileFilters() {
        this.acceptedRawFilesFilter = this.createAcceptedRawFilesFilter();
        this.userDefinedFileTypesFilter = this.createUserDefinedFileFilter();
        this.allAcceptedImageFilesFilter = this.createAllAcceptedImagesFileFilter();
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    public RegexFileFilter createAcceptedRawFilesFilter() {
        this.setAcceptedRawFilesSuffixes();
        RegexFileFilter filter = this.createRegexFileFilterFromSuffixes(this.acceptedRawSuffixes);
        filter.setDisplayname(Bundle.getString(AppFileFilters.class, "AppFileFilters.DisplayName.RAW", new Object[0]));
        return filter;
    }

    private RegexFileFilter createAcceptedDngFilesFiter() {
        RegexFileFilter filter = new RegexFileFilter(".*\\.[dD][nN][gG];", ";");
        filter.setDisplayname(Bundle.getString(AppFileFilters.class, "AppFileFilters.DisplayName.DNG", new Object[0]));
        return filter;
    }

    private RegexFileFilter createAcceptedJpegFilesFiter() {
        RegexFileFilter filter = new RegexFileFilter(".*\\.[jJ][pP][gG];.*\\.[jJ][pP][eE][gG];", ";");
        filter.setDisplayname(Bundle.getString(AppFileFilters.class, "AppFileFilters.DisplayName.JPEG", new Object[0]));
        return filter;
    }

    private RegexFileFilter createAcceptedTiffFilesFiter() {
        RegexFileFilter filter = new RegexFileFilter(".*\\.[tT][iI][fF];.*\\.[tT][iI][fF][fF];", ";");
        filter.setDisplayname(Bundle.getString(AppFileFilters.class, "AppFileFilters.DisplayName.TIFF", new Object[0]));
        return filter;
    }

    private synchronized void setAcceptedRawFilesSuffixes() {
        Collection<ThumbnailCreator> tnCreators = Lookup.getDefault().lookupAll(ThumbnailCreator.class);
        this.acceptedRawSuffixes.clear();
        for (ThumbnailCreator tnCreator : tnCreators) {
            Set<String> tnCreatorSuffixes = tnCreator.getSupportedRawFormatFileTypeSuffixes();
            this.acceptedRawSuffixes.addAll(tnCreatorSuffixes);
        }
    }

    public synchronized RegexFileFilter createUserDefinedFileFilter() {
        RegexFileFilter filter;
        this.setUserDefindedFileTypesSuffixes();
        RegexFileFilter regexFileFilter = filter = this.userDefinedFileTypesSuffixes.isEmpty() ? null : this.createRegexFileFilterFromSuffixes(this.userDefinedFileTypesSuffixes);
        if (filter != null) {
            filter.setDisplayname(Bundle.getString(AppFileFilters.class, "AppFileFilters.DisplayName.UserDefinedFileTypes", new Object[0]));
        }
        return filter;
    }

    private synchronized void setUserDefindedFileTypesSuffixes() {
        UserDefinedFileTypesRepository repo = Lookup.getDefault().lookup(UserDefinedFileTypesRepository.class);
        if (repo == null) {
            return;
        }
        List<UserDefinedFileType> fileTypes = repo.findAllUserDefinedFileTypes();
        this.userDefinedFileTypesSuffixes.clear();
        for (UserDefinedFileType fileType : fileTypes) {
            this.userDefinedFileTypesSuffixes.add(fileType.getSuffix());
        }
    }

    public synchronized RegexFileFilter createAllAcceptedImagesFileFilter() {
        this.setAllAcceptedImagesFileSuffixes();
        RegexFileFilter filter = this.createRegexFileFilterFromSuffixes(this.allAcceptedSuffixes);
        filter.setDisplayname(Bundle.getString(AppFileFilters.class, "AppFileFilters.DisplayName.ALL", new Object[0]));
        return filter;
    }

    private synchronized void setAllAcceptedImagesFileSuffixes() {
        Collection<ThumbnailCreator> tnCreators = Lookup.getDefault().lookupAll(ThumbnailCreator.class);
        this.allAcceptedSuffixes.clear();
        for (ThumbnailCreator tnCreator : tnCreators) {
            Set<String> tnCreatorSuffixes = tnCreator.getAllSupportedFileTypeSuffixes();
            this.allAcceptedSuffixes.addAll(tnCreatorSuffixes);
        }
        this.allAcceptedSuffixes.addAll(this.userDefinedFileTypesSuffixes);
    }

    private RegexFileFilter createRegexFileFilterFromSuffixes(Collection<? extends String> suffixes) {
        StringBuilder sb = new StringBuilder();
        String delimiter = ";";
        boolean isFirst = true;
        for (String string : suffixes) {
            String ignoreCaseuffix = this.toIgnoreCasePattern(string);
            sb.append(isFirst ? "" : ";").append(".*\\.").append(ignoreCaseuffix);
            isFirst = false;
        }
        return new RegexFileFilter(sb.toString(), delimiter);
    }

    private String toIgnoreCasePattern(String pattern) {
        int patternLength = pattern.length();
        StringBuilder sb = new StringBuilder(patternLength * 2);
        for (int index = 0; index < patternLength; ++index) {
            char character = pattern.charAt(index);
            sb.append("[");
            sb.append(Character.toUpperCase(character));
            sb.append(Character.toLowerCase(character));
            sb.append("]");
        }
        return sb.toString();
    }

    public RegexFileFilter getAcceptedDngFilesFilter() {
        return new RegexFileFilter(this.acceptedDngFilesFilter);
    }

    public RegexFileFilter getAcceptedJpegFilesFilter() {
        return new RegexFileFilter(this.acceptedJpegFilesFilter);
    }

    public RegexFileFilter getAcceptedRawFilesFilter() {
        return new RegexFileFilter(this.acceptedRawFilesFilter);
    }

    public RegexFileFilter getAcceptedTiffFilesFilter() {
        return new RegexFileFilter(this.acceptedTiffFilesFilter);
    }

    public synchronized RegexFileFilter getAllAcceptedImageFilesFilter() {
        return new RegexFileFilter(this.allAcceptedImageFilesFilter);
    }

    public synchronized RegexFileFilter getUserDefinedFileTypesFilter() {
        return this.userDefinedFileTypesFilter == null ? null : new RegexFileFilter(this.userDefinedFileTypesFilter);
    }

    public boolean isAcceptedImageFile(File imageFile) {
        return this.allAcceptedImageFilesFilter.accept(imageFile);
    }

    public boolean isUserDefinedFileType(File imageFile) {
        return this.userDefinedFileTypesFilter == null ? false : this.userDefinedFileTypesFilter.accept(imageFile);
    }

    @EventSubscriber(eventClass=UserDefinedFileTypeInsertedEvent.class)
    public void userDefinedFileFilterInserted(UserDefinedFileTypeInsertedEvent evt) {
        this.reCreateUserDefinedAndAllAcceptedFilters();
    }

    @EventSubscriber(eventClass=UserDefinedFileTypeUpdatedEvent.class)
    public void userDefinedFileFilterUpdated(UserDefinedFileTypeUpdatedEvent evt) {
        this.reCreateUserDefinedAndAllAcceptedFilters();
    }

    @EventSubscriber(eventClass=UserDefinedFileTypeDeletedEvent.class)
    public void userDefinedFileFilterDeleted(UserDefinedFileTypeDeletedEvent evt) {
        this.reCreateUserDefinedAndAllAcceptedFilters();
    }

    private synchronized void reCreateUserDefinedAndAllAcceptedFilters() {
        this.userDefinedFileTypesFilter = this.createUserDefinedFileFilter();
        this.allAcceptedImageFilesFilter = this.createAllAcceptedImagesFileFilter();
    }
}

