/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.factory;

import java.io.File;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.FileImportService;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.app.AppCommandLineOptions;
import org.jphototagger.program.app.AppInit;
import org.jphototagger.program.factory.Support;
import org.jphototagger.program.module.thumbnails.ThumbnailsPopupMenu;
import org.jphototagger.program.tasks.ScheduledTasks;
import org.openide.util.Lookup;

public final class TerminateFactory {
    static final TerminateFactory INSTANCE = new TerminateFactory();
    private volatile boolean init = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        TerminateFactory terminateFactory = this;
        synchronized (terminateFactory) {
            if (!Support.checkInitOnlyOneTimes(this.getClass(), this.init)) {
                return;
            }
            this.init = true;
        }
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                String message = Bundle.getString(TerminateFactory.class, "MiscFactory.Init.Start", new Object[0]);
                Support.setStatusbarInfo(message);
                ThumbnailsPopupMenu.INSTANCE.setOtherPrograms();
                ScheduledTasks.INSTANCE.run();
                TerminateFactory.this.checkImportImageFiles();
                message = Bundle.getString(TerminateFactory.class, "MiscFactory.Init.Finished", new Object[0]);
                Support.setStatusbarInfo(message);
            }
        });
    }

    private boolean isAutocomplete() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.EnableAutoComplete") ? prefs.getBoolean("UserSettings.EnableAutoComplete") : true;
    }

    private void checkImportImageFiles() {
        AppCommandLineOptions cmdLineOptions = AppInit.INSTANCE.getCommandLineOptions();
        if (cmdLineOptions.isImportImageFiles()) {
            String dirName = cmdLineOptions.getFileImportDir();
            File dir = null;
            if (dirName != null && new File(dirName).isDirectory()) {
                dir = new File(dirName);
            }
            FileImportService service = Lookup.getDefault().lookup(FileImportService.class);
            service.importFilesFromDirectory(dir);
        }
    }
}

