/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.messages.MessageType;
import org.jphototagger.api.windows.MainWindowManager;
import org.openide.util.Lookup;

final class Support {
    private static final Logger LOGGER = Logger.getLogger(Support.class.getName());
    private final Map<Class<?>, List<Object>> classInstances = new HashMap();

    Support() {
    }

    synchronized <T> List<T> getAll(Class<T> type) {
        return Collections.unmodifiableList(this.classInstances.get(type));
    }

    synchronized <T> T getFirst(Class<T> type) {
        List<Object> instances = this.classInstances.get(type);
        return (T)(instances == null ? null : instances.get(0));
    }

    synchronized void add(Object instance) {
        List<Object> instances = this.classInstances.get(instance.getClass());
        if (instances == null) {
            instances = new ArrayList<Object>();
            this.classInstances.put(instance.getClass(), instances);
        }
        instances.add(instance);
    }

    static void setStatusbarInfo(String message) {
        MainWindowManager messageDisplayer = Lookup.getDefault().lookup(MainWindowManager.class);
        messageDisplayer.setMainWindowStatusbarText(message, MessageType.INFO, 2000L);
    }

    static boolean checkInitOnlyOneTimes(Class<?> c, boolean init) {
        if (init) {
            LOGGER.log(Level.WARNING, "{0}: Initalized Meta-Factory again!", c.getName());
            return false;
        }
        return true;
    }
}

