/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.factory;

import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.util.ListItemTempSelectionRowSetter;
import org.jphototagger.lib.swing.util.TreeItemTempSelectionRowSetter;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.app.ui.AppPanel;
import org.jphototagger.program.factory.Support;
import org.jphototagger.program.misc.InputHelperDialog;
import org.jphototagger.program.module.directories.DirectoriesPopupMenu;
import org.jphototagger.program.module.favorites.FavoritesPopupMenu;
import org.jphototagger.program.module.imagecollections.ImageCollectionsPopupMenu;
import org.jphototagger.program.module.keywords.tree.KeywordsTreePopupMenu;
import org.jphototagger.program.module.search.SavedSearchesPopupMenu;
import org.jphototagger.program.resource.GUI;

public final class RendererFactory {
    static final RendererFactory INSTANCE = new RendererFactory();
    private final Support support = new Support();
    private volatile boolean init;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void init() {
        RendererFactory rendererFactory = this;
        synchronized (rendererFactory) {
            if (!Support.checkInitOnlyOneTimes(this.getClass(), this.init)) {
                return;
            }
            this.init = true;
        }
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                String message = Bundle.getString(RendererFactory.class, "RendererFactory.Init.Start", new Object[0]);
                Support.setStatusbarInfo(message);
                RendererFactory.this.setPopupMenuHighlighter();
                message = Bundle.getString(RendererFactory.class, "RendererFactory.Init.Finished", new Object[0]);
                Support.setStatusbarInfo(message);
            }
        });
    }

    private void setPopupMenuHighlighter() {
        AppPanel appPanel = GUI.getAppPanel();
        this.support.add(new TreeItemTempSelectionRowSetter(appPanel.getTreeFavorites(), FavoritesPopupMenu.INSTANCE));
        this.support.add(new TreeItemTempSelectionRowSetter(appPanel.getTreeDirectories(), DirectoriesPopupMenu.INSTANCE));
        this.support.add(new TreeItemTempSelectionRowSetter(appPanel.getTreeEditKeywords(), KeywordsTreePopupMenu.INSTANCE));
        this.support.add(new TreeItemTempSelectionRowSetter(InputHelperDialog.INSTANCE.getPanelKeywords().getTree(), KeywordsTreePopupMenu.INSTANCE));
        this.support.add(new ListItemTempSelectionRowSetter(appPanel.getListImageCollections(), ImageCollectionsPopupMenu.INSTANCE));
        this.support.add(new ListItemTempSelectionRowSetter(appPanel.getListSavedSearches(), SavedSearchesPopupMenu.INSTANCE));
    }
}

