/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.factory;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jphototagger.api.plugin.Plugin;
import org.jphototagger.api.preferences.Preferences;
import org.openide.util.Lookup;

public class PluginManager<T extends Plugin> {
    private static final String PROPERTY_STRING_VALUE_FALSE = "0";
    private static final String PROPERTY_STRING_VALUE_TRUE = "1";
    private final Set<T> ALL_PLUGINS = new LinkedHashSet<T>();
    private final Set<T> ENABLED_PLUGINS = new LinkedHashSet<T>();
    private final Class<T> pluginClass;

    protected PluginManager(Class<T> pluginClass) {
        this.pluginClass = pluginClass;
        this.init();
    }

    private void init() {
        for (Plugin plugin : Lookup.getDefault().lookupAll(this.pluginClass)) {
            this.ALL_PLUGINS.add(plugin);
            if (!this.isFlaggedAsEnabeld(plugin)) continue;
            this.ENABLED_PLUGINS.add(plugin);
        }
    }

    private boolean isFlaggedAsEnabeld(T plugin) {
        String key;
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        if (!prefs.containsKey(key = this.getEnabledPropertyKeyForPlugin(plugin))) {
            return true;
        }
        return prefs.getString(key).equals(PROPERTY_STRING_VALUE_TRUE);
    }

    private String getEnabledPropertyKeyForPlugin(T plugin) {
        return "Plugin." + plugin.getClass().getName() + ".Enabled";
    }

    public Collection<T> getAllPlugins() {
        return Collections.unmodifiableCollection(this.ALL_PLUGINS);
    }

    public Collection<T> getEnabledPlugins() {
        return Collections.unmodifiableCollection(this.ENABLED_PLUGINS);
    }

    public boolean isEnabled(T plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin == null");
        }
        return this.ENABLED_PLUGINS.contains(plugin);
    }

    public void setEnabled(T plugin, boolean enabled) {
        if (plugin == null) {
            throw new NullPointerException("plugin == null");
        }
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        String key = this.getEnabledPropertyKeyForPlugin(plugin);
        if (enabled) {
            this.ENABLED_PLUGINS.add(plugin);
            prefs.setString(key, PROPERTY_STRING_VALUE_TRUE);
        } else {
            this.ENABLED_PLUGINS.remove(plugin);
            prefs.setString(key, PROPERTY_STRING_VALUE_FALSE);
        }
    }

    public boolean hasEnabledPlugins() {
        return !this.ENABLED_PLUGINS.isEmpty();
    }
}

