/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.factory;

import java.awt.Cursor;
import java.io.File;
import java.util.List;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.SortOrder;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.sort.ListSortController;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.imagecollections.ImageCollectionSortAscendingComparator;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.io.filefilter.DirectoryFilter;
import org.jphototagger.lib.swing.AllSystemDirectoriesTreeModel;
import org.jphototagger.lib.swing.SelectRootFilesPanel;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.app.ui.AppPanel;
import org.jphototagger.program.app.ui.AppWindowPersistence;
import org.jphototagger.program.factory.Support;
import org.jphototagger.program.misc.InputHelperDialog;
import org.jphototagger.program.module.favorites.FavoritesTreeModel;
import org.jphototagger.program.module.imagecollections.ImageCollectionsListModel;
import org.jphototagger.program.module.keywords.KeywordHighlightPredicate;
import org.jphototagger.program.module.keywords.KeywordsPanel;
import org.jphototagger.program.module.keywords.list.KeywordsListModel;
import org.jphototagger.program.module.keywords.tree.KeywordsTreeModel;
import org.jphototagger.program.module.metadatatemplates.MetadataTemplatesListModel;
import org.jphototagger.program.module.miscmetadata.MiscMetadataTreeModel;
import org.jphototagger.program.module.search.SavedSearchesListModel;
import org.jphototagger.program.module.timeline.TimelineTreeModel;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class ModelFactory {
    public static final ModelFactory INSTANCE = new ModelFactory();
    private final Support support = new Support();
    private volatile boolean init;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        ModelFactory modelFactory = this;
        synchronized (modelFactory) {
            if (!Support.checkInitOnlyOneTimes(this.getClass(), this.init)) {
                return;
            }
            this.init = true;
        }
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                AppPanel appPanel = GUI.getAppPanel();
                String message = Bundle.getString(ModelFactory.class, "ModelFactory.Init.Start", new Object[0]);
                Support.setStatusbarInfo(message);
                ModelFactory.this.setListModels(appPanel);
                ModelFactory.this.setTreeModels(appPanel);
                message = Bundle.getString(ModelFactory.class, "ModelFactory.Init.Finished", new Object[0]);
                Support.setStatusbarInfo(message);
            }
        });
    }

    private void setListModels(AppPanel appPanel) {
        this.setListModelSavedSearches(appPanel);
        this.setListModelImageCollections(appPanel);
        this.setListModelKeywords(appPanel);
    }

    private void setListModelSavedSearches(final AppPanel appPanel) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String message = Bundle.getString(ModelFactory.class, "ModelFactory.Starting.ListModelSavedSearches", new Object[0]);
                Support.setStatusbarInfo(message);
                final JXList list = appPanel.getListSavedSearches();
                final Cursor listCursor = ModelFactory.this.setWaitCursor(list);
                final SavedSearchesListModel model = new SavedSearchesListModel();
                ModelFactory.this.support.add(model);
                EventQueueUtil.invokeInDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        list.setModel((ListModel)model);
                        list.setAutoCreateRowSorter(true);
                        list.setSortOrder(SortOrder.ASCENDING);
                        AppWindowPersistence.readListSavedSearches();
                        list.setCursor(listCursor);
                        String message = Bundle.getString(ModelFactory.class, "ModelFactory.Finished.ListModelSavedSearches", new Object[0]);
                        Support.setStatusbarInfo(message);
                    }
                });
            }
        }, "JPhotoTagger: Creating Saved Searches List").start();
    }

    private void setListModelImageCollections(final AppPanel appPanel) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String message = Bundle.getString(ModelFactory.class, "ModelFactory.Starting.ListModelImageCollections", new Object[0]);
                Support.setStatusbarInfo(message);
                final JXList list = appPanel.getListImageCollections();
                final Cursor listCursor = ModelFactory.this.setWaitCursor(list);
                final ImageCollectionsListModel model = new ImageCollectionsListModel();
                ModelFactory.this.support.add(model);
                EventQueueUtil.invokeInDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        list.setModel((ListModel)model);
                        ListSortController<ImageCollectionsListModel> sorter = new ListSortController<ImageCollectionsListModel>(model);
                        sorter.setComparator(0, new ImageCollectionSortAscendingComparator());
                        list.setRowSorter(sorter);
                        list.setSortOrder(SortOrder.ASCENDING);
                        AppWindowPersistence.readListImageCollections();
                        list.setCursor(listCursor);
                        String message = Bundle.getString(ModelFactory.class, "ModelFactory.Finished.ListModelImageCollections", new Object[0]);
                        Support.setStatusbarInfo(message);
                    }
                });
            }
        }, "JPhotoTagger: Creating Image Collections List").start();
    }

    private void setListModelKeywords(final AppPanel appPanel) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String message = Bundle.getString(ModelFactory.class, "ModelFactory.Starting.ListModelKeywords", new Object[0]);
                Support.setStatusbarInfo(message);
                final JXList listSelectedKeywords = appPanel.getListSelKeywords();
                final KeywordsPanel panelEditKeywords = appPanel.getPanelEditKeywords();
                final Cursor listCursor = ModelFactory.this.setWaitCursor(listSelectedKeywords);
                final KeywordsListModel modelKeywords = new KeywordsListModel();
                ModelFactory.this.support.add(modelKeywords);
                EventQueueUtil.invokeInDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        listSelectedKeywords.setModel((ListModel)modelKeywords);
                        listSelectedKeywords.setAutoCreateRowSorter(true);
                        listSelectedKeywords.setSortOrder(SortOrder.ASCENDING);
                        listSelectedKeywords.addHighlighter(KeywordHighlightPredicate.getHighlighter());
                        panelEditKeywords.setListModel(modelKeywords);
                        InputHelperDialog.INSTANCE.setModelKeywords(modelKeywords);
                        AppWindowPersistence.readListSelKeywords();
                        listSelectedKeywords.setCursor(listCursor);
                        String message = Bundle.getString(ModelFactory.class, "ModelFactory.Finished.ListModelKeywords", new Object[0]);
                        Support.setStatusbarInfo(message);
                    }
                });
            }
        }, "JPhotoTagger: Creating Keywords list").start();
    }

    private void setTreeModels(AppPanel appPanel) {
        this.setTreeModelKeywords(appPanel);
        this.setTreeModelTimeline(appPanel);
        this.setTreeModelMiscMetadata(appPanel);
        this.setTreeModelFavorites(appPanel);
        this.setTreeModelDirectories(appPanel);
    }

    private void setTreeModelKeywords(final AppPanel appPanel) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String message = Bundle.getString(ModelFactory.class, "ModelFactory.Starting.TreeModelKeywords", new Object[0]);
                Support.setStatusbarInfo(message);
                final KeywordsTreeModel treeModelKeywords = new KeywordsTreeModel();
                final MetadataTemplatesListModel listModelTemplates = new MetadataTemplatesListModel();
                ModelFactory.this.support.add(treeModelKeywords);
                ModelFactory.this.support.add(listModelTemplates);
                EventQueueUtil.invokeInDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        JTree treeSelKeywords = appPanel.getTreeSelKeywords();
                        treeSelKeywords.setModel(treeModelKeywords);
                        AppWindowPersistence.readTreeSelKeywords();
                        JTree treeEditKeywords = appPanel.getTreeEditKeywords();
                        treeEditKeywords.setModel(treeModelKeywords);
                        AppWindowPersistence.readTreeEditKeywords();
                        InputHelperDialog.INSTANCE.getPanelKeywords().getTree().setModel(treeModelKeywords);
                        InputHelperDialog.INSTANCE.getPanelMetaDataTemplates().getList().setModel((ListModel)listModelTemplates);
                        String message = Bundle.getString(ModelFactory.class, "ModelFactory.Finished.TreeModelKeywords", new Object[0]);
                        Support.setStatusbarInfo(message);
                    }
                });
            }
        }, "JPhotoTagger: Creating Keywords Trees").start();
    }

    private void setTreeModelMiscMetadata(final AppPanel appPanel) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String message = Bundle.getString(ModelFactory.class, "ModelFactory.Starting.TreeModelMiscMetadata", new Object[0]);
                Support.setStatusbarInfo(message);
                final JTree tree = appPanel.getTreeMiscMetadata();
                final Cursor treeCursor = ModelFactory.this.setWaitCursor(tree);
                final MiscMetadataTreeModel modelApp = new MiscMetadataTreeModel(false);
                final MiscMetadataTreeModel modelInputHelper = new MiscMetadataTreeModel(true);
                ModelFactory.this.support.add(modelApp);
                ModelFactory.this.support.add(modelInputHelper);
                EventQueueUtil.invokeInDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        InputHelperDialog.INSTANCE.getPanelMiscXmpMetadata().getTree().setModel(modelInputHelper);
                        tree.setModel(modelApp);
                        AppWindowPersistence.readTreeMiscMetadata();
                        tree.setCursor(treeCursor);
                        String message = Bundle.getString(ModelFactory.class, "ModelFactory.Finished.TreeModelMiscMetadata", new Object[0]);
                        Support.setStatusbarInfo(message);
                    }
                });
            }
        }, "JPhotoTagger: Creating Misc Metadata Tree").start();
    }

    private void setTreeModelTimeline(final AppPanel appPanel) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String message = Bundle.getString(ModelFactory.class, "ModelFactory.Starting.TreeModelTimeline", new Object[0]);
                Support.setStatusbarInfo(message);
                final JTree tree = appPanel.getTreeTimeline();
                final Cursor treeCursor = ModelFactory.this.setWaitCursor(tree);
                final TimelineTreeModel model = new TimelineTreeModel();
                ModelFactory.this.support.add(model);
                EventQueueUtil.invokeInDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        tree.setModel(model);
                        AppWindowPersistence.readTreeTimeline();
                        tree.setCursor(treeCursor);
                        String message = Bundle.getString(ModelFactory.class, "ModelFactory.Finished.TreeModelTimeline", new Object[0]);
                        Support.setStatusbarInfo(message);
                    }
                });
            }
        }, "JPhotoTagger: Creating Timeline Tree").start();
    }

    private void setTreeModelFavorites(final AppPanel appPanel) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String message = Bundle.getString(ModelFactory.class, "ModelFactory.Starting.TreeModelFavorites", new Object[0]);
                Support.setStatusbarInfo(message);
                final JTree tree = appPanel.getTreeFavorites();
                final Cursor treeCursor = ModelFactory.this.setWaitCursor(tree);
                final FavoritesTreeModel model = new FavoritesTreeModel(tree);
                EventQueueUtil.invokeInDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        ModelFactory.this.support.add(model);
                        tree.setModel(model);
                        model.readFromProperties();
                        tree.setCursor(treeCursor);
                        if (ModelFactory.lookupAutoScanDirectories()) {
                            model.startAutoUpdate();
                        }
                        String message = Bundle.getString(ModelFactory.class, "ModelFactory.Finished.TreeModelFavorites", new Object[0]);
                        Support.setStatusbarInfo(message);
                    }
                });
            }
        }, "JPhotoTagger: Creating Favorites Tree").start();
    }

    private void setTreeModelDirectories(final AppPanel appPanel) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String message = Bundle.getString(ModelFactory.class, "ModelFactory.Starting.TreeModelDirectories", new Object[0]);
                Support.setStatusbarInfo(message);
                final JTree tree = appPanel.getTreeDirectories();
                final Cursor treeCursor = ModelFactory.this.setWaitCursor(tree);
                List<File> hideRootFiles = SelectRootFilesPanel.readPersistentRootFiles("UserSettings.HideRootFilesFromDirectoriesTab");
                final AllSystemDirectoriesTreeModel model = new AllSystemDirectoriesTreeModel(tree, hideRootFiles, ModelFactory.this.getDirFilterOptionShowHiddenFiles());
                ModelFactory.this.support.add(model);
                EventQueueUtil.invokeInDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        tree.setModel(model);
                        AppWindowPersistence.readTreeDirectories();
                        tree.setCursor(treeCursor);
                        String message = Bundle.getString(ModelFactory.class, "ModelFactory.Finished.TreeModelDirectories", new Object[0]);
                        Support.setStatusbarInfo(message);
                        if (ModelFactory.lookupAutoScanDirectories()) {
                            model.startAutoUpdate();
                        }
                    }
                });
            }
        }, "JPhotoTagger: Creating Directories Tree").start();
    }

    private DirectoryFilter.Option getDirFilterOptionShowHiddenFiles() {
        return this.isAcceptHiddenDirectories() ? DirectoryFilter.Option.ACCEPT_HIDDEN_FILES : DirectoryFilter.Option.NO_OPTION;
    }

    private boolean isAcceptHiddenDirectories() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.IsAcceptHiddenDirectories") ? prefs.getBoolean("UserSettings.IsAcceptHiddenDirectories") : false;
    }

    public <T> List<T> getModels(Class<T> modelClass) {
        if (modelClass == null) {
            throw new NullPointerException("modelClass == null");
        }
        return this.support.getAll(modelClass);
    }

    public <T> T getModel(Class<T> modelClass) {
        if (modelClass == null) {
            throw new NullPointerException("modelClass == null");
        }
        return this.support.getFirst(modelClass);
    }

    private Cursor setWaitCursor(JList<?> list) {
        Cursor listCursor = list.getCursor();
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        list.setCursor(waitCursor);
        return listCursor;
    }

    private synchronized Cursor setWaitCursor(JTree tree) {
        Cursor treeCursor = tree.getCursor();
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        tree.setCursor(waitCursor);
        return treeCursor;
    }

    private static boolean lookupAutoScanDirectories() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("Preferences.Autoscan.Directories") ? prefs.getBoolean("Preferences.Autoscan.Directories") : false;
    }
}

