/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.factory;

import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.api.applifecycle.AppUpdater;
import org.jphototagger.api.branding.AppProperties;
import org.jphototagger.api.modules.Module;
import org.jphototagger.api.modules.ModulesWereInitEvent;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.util.Version;
import org.jphototagger.program.app.ui.AppWindowPersistence;
import org.jphototagger.program.app.update.UpdateDownload;
import org.jphototagger.program.factory.ActionKeyListenerFactory;
import org.jphototagger.program.factory.ControllerFactory;
import org.jphototagger.program.factory.ModelFactory;
import org.jphototagger.program.factory.MouseListenerFactory;
import org.jphototagger.program.factory.RendererFactory;
import org.jphototagger.program.factory.Support;
import org.jphototagger.program.factory.TerminateFactory;
import org.openide.util.Lookup;

public final class MetaFactory
implements Runnable {
    public static final MetaFactory INSTANCE = new MetaFactory();
    private Collection<? extends Module> modules;
    private boolean init = false;

    @Override
    public void run() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        MetaFactory metaFactory = this;
        synchronized (metaFactory) {
            if (!Support.checkInitOnlyOneTimes(this.getClass(), this.init)) {
                return;
            }
            this.init = true;
        }
        AppWindowPersistence appPersistence = new AppWindowPersistence();
        appPersistence.readAppFrameFromProperties();
        ModelFactory.INSTANCE.init();
        RendererFactory.INSTANCE.init();
        ControllerFactory.INSTANCE.init();
        ActionKeyListenerFactory.INSTANCE.init();
        MouseListenerFactory.INSTANCE.init();
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                TerminateFactory.INSTANCE.init();
            }
        });
        this.installModules();
        this.readPreferences(appPersistence);
        this.notifyUpdaters();
        this.checkForDownload();
    }

    private void notifyUpdaters() {
        Collection<AppUpdater> appUpdaters = Lookup.getDefault().lookupAll(AppUpdater.class);
        AppProperties appProperties = Lookup.getDefault().lookup(AppProperties.class);
        Version version = Version.parseVersion(appProperties.getAppVersionString(), ".");
        int major = version.getMajor();
        int minor1 = version.getMinor1();
        int minor2 = version.getMinor2();
        for (AppUpdater appUpdater : appUpdaters) {
            appUpdater.updateToVersion(major, minor1, minor2);
        }
    }

    private void checkForDownload() {
        UpdateDownload.askOnceCheckForNewerVersion();
        if (this.isCheckForUpdates()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(60000L);
                        UpdateDownload.checkForNewerVersion();
                    }
                    catch (Throwable t) {
                        Logger.getLogger(MetaFactory.class.getName()).log(Level.SEVERE, null, t);
                    }
                }
            }, "JPhotoTagger: Checking for a newer version").start();
        }
    }

    private boolean isCheckForUpdates() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.AutoDownloadNewerVersions") ? prefs.getBoolean("UserSettings.AutoDownloadNewerVersions") : true;
    }

    private void installModules() {
        this.modules = Lookup.getDefault().lookupAll(Module.class);
        for (Module module : this.modules) {
            module.init();
        }
        EventBus.publish(new ModulesWereInitEvent(this, Collections.unmodifiableCollection(this.modules)));
    }

    public Collection<Module> getModules() {
        return this.modules == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.modules);
    }

    private void readPreferences(final AppWindowPersistence appPersistence) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                appPersistence.readAppPanelFromProperties();
            }
        });
    }
}

