/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.factory;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.swingx.JXLabel;
import org.jphototagger.api.modules.Module;
import org.jphototagger.api.modules.ModuleDescription;
import org.jphototagger.api.windows.OptionPageProvider;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.factory.MetaFactory;

public class InstalledModulesPanel
extends JPanel
implements OptionPageProvider {
    private static final long serialVersionUID = 1L;
    private final ModulesListModel modulesListModel = new ModulesListModel();
    private Module selectedModule;
    private JLabel labelInfo;
    private JXLabel labelModuleDescription;
    private JList<Object> listModules;
    private JPanel panelModuleDescription;
    private JScrollPane scrollPaneModules;
    private BindingGroup bindingGroup;

    public InstalledModulesPanel() {
        this.initComponents();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public String getTitle() {
        return Bundle.getString(InstalledModulesPanel.class, "InstalledModulesPanel.Name", new Object[0]);
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public boolean isMiscOptionPage() {
        return true;
    }

    @Override
    public int getPosition() {
        return 1000000;
    }

    public Module getSelectedModule() {
        return this.selectedModule;
    }

    public void setSelectedModule(Module selectedModule) {
        this.selectedModule = selectedModule;
        if (selectedModule instanceof ModuleDescription) {
            ModuleDescription moduleDescription = (ModuleDescription)((Object)selectedModule);
            this.labelModuleDescription.setText(moduleDescription.getLocalizedDescription());
            ComponentUtil.forceRepaint(this);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.labelInfo = new JLabel();
        this.scrollPaneModules = new JScrollPane();
        this.listModules = new JList();
        this.panelModuleDescription = new JPanel();
        this.labelModuleDescription = new JXLabel();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/factory/Bundle");
        this.labelInfo.setText(bundle.getString("InstalledModulesPanel.labelInfo.text"));
        this.labelInfo.setName("labelInfo");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.labelInfo, gridBagConstraints);
        this.scrollPaneModules.setName("scrollPaneModules");
        this.listModules.setModel(this.modulesListModel);
        this.listModules.setSelectionMode(0);
        this.listModules.setName("listModules");
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this, ELProperty.create("${selectedModule}"), this.listModules, BeanProperty.create("selectedElement"));
        this.bindingGroup.addBinding(binding);
        this.scrollPaneModules.setViewportView(this.listModules);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.scrollPaneModules, gridBagConstraints);
        this.panelModuleDescription.setBorder(BorderFactory.createTitledBorder(bundle.getString("InstalledModulesPanel.panelModuleDescription.border.title")));
        this.panelModuleDescription.setName("panelModuleDescription");
        this.panelModuleDescription.setPreferredSize(new Dimension(100, 75));
        this.panelModuleDescription.setLayout(new GridBagLayout());
        this.labelModuleDescription.setLineWrap(true);
        this.labelModuleDescription.setVerticalAlignment(1);
        this.labelModuleDescription.setName("labelModuleDescription");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelModuleDescription.add((Component)this.labelModuleDescription, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelModuleDescription, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private static class ModulesListModel
    extends DefaultListModel<Object> {
        private static final long serialVersionUID = 1L;

        ModulesListModel() {
            Collection<Module> modules = MetaFactory.INSTANCE.getModules();
            for (Module module : modules) {
                this.addElement(module);
            }
        }
    }
}

