/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.factory;

import java.util.List;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.app.logging.ErrorLogHandler;
import org.jphototagger.program.factory.Support;
import org.jphototagger.program.help.ShowAboutJPhotoTaggerAction;
import org.jphototagger.program.misc.GoToController;
import org.jphototagger.program.misc.InputHelperDialog;
import org.jphototagger.program.misc.MaximumOneTreeOrListItemSelectedController;
import org.jphototagger.program.misc.MenuItemEnablerController;
import org.jphototagger.program.module.actions.ActionsMenuUpdater;
import org.jphototagger.program.module.directories.CreateDirectoryController;
import org.jphototagger.program.module.directories.DeleteDirectoryController;
import org.jphototagger.program.module.directories.DirectorySelectedController;
import org.jphototagger.program.module.directories.OpenDirectoryInDesktopController;
import org.jphototagger.program.module.directories.PasteFilesIntoDirectoryController;
import org.jphototagger.program.module.directories.RefreshDirectoryTreeController;
import org.jphototagger.program.module.directories.RenameDirectoryController;
import org.jphototagger.program.module.favorites.AddFilesystemFolderToFavoritesController;
import org.jphototagger.program.module.favorites.DeleteFavoriteController;
import org.jphototagger.program.module.favorites.DeleteFilesystemFolderFromFavoritesController;
import org.jphototagger.program.module.favorites.FavoriteSelectedController;
import org.jphototagger.program.module.favorites.InsertFavoriteController;
import org.jphototagger.program.module.favorites.MoveFavoriteController;
import org.jphototagger.program.module.favorites.OpenFavoriteInDesktopController;
import org.jphototagger.program.module.favorites.OpenFavoriteInDirectoriesTreeController;
import org.jphototagger.program.module.favorites.RefreshFavoritesController;
import org.jphototagger.program.module.favorites.RenameFilesystemFolderInFavoritesController;
import org.jphototagger.program.module.favorites.UpdateFavoriteController;
import org.jphototagger.program.module.filesystem.CopyFilesToDirectoryController;
import org.jphototagger.program.module.filesystem.DeleteFilesController;
import org.jphototagger.program.module.filesystem.FilesystemRepositoryUpdater;
import org.jphototagger.program.module.filesystem.MoveFilesController;
import org.jphototagger.program.module.filesystem.RenameFilesController;
import org.jphototagger.program.module.imagecollections.AddImageCollectionController;
import org.jphototagger.program.module.imagecollections.AddToImageCollectionController;
import org.jphototagger.program.module.imagecollections.DeleteFromImageCollectionController;
import org.jphototagger.program.module.imagecollections.DeleteImageCollectionController;
import org.jphototagger.program.module.imagecollections.ImageCollectionSelectedController;
import org.jphototagger.program.module.imagecollections.PickRejectController;
import org.jphototagger.program.module.imagecollections.RenameImageCollectionController;
import org.jphototagger.program.module.keywords.KeywordsPanel;
import org.jphototagger.program.module.keywords.list.DeleteKeywordsController;
import org.jphototagger.program.module.keywords.list.DeleteKeywordsFromEditPanelController;
import org.jphototagger.program.module.keywords.list.DisplayKeywordController;
import org.jphototagger.program.module.keywords.list.EditKeywordSynonymsController;
import org.jphototagger.program.module.keywords.list.InsertKeywordsController;
import org.jphototagger.program.module.keywords.list.KeywordListItemSelectedController;
import org.jphototagger.program.module.keywords.list.RenameKeywordsController;
import org.jphototagger.program.module.keywords.tree.AddKeywordToTreeController;
import org.jphototagger.program.module.keywords.tree.AddKeywordsToEditPanelController;
import org.jphototagger.program.module.keywords.tree.CopyCutPasteKeywordController;
import org.jphototagger.program.module.keywords.tree.DeleteKeywordFromEditPanelController;
import org.jphototagger.program.module.keywords.tree.DeleteKeywordsFromTreeController;
import org.jphototagger.program.module.keywords.tree.HighlightKeywordsTreeController;
import org.jphototagger.program.module.keywords.tree.KeywordsDisplayImagesController;
import org.jphototagger.program.module.keywords.tree.KeywordsRepositoryUpdatesController;
import org.jphototagger.program.module.keywords.tree.KeywordsTreeItemSelectedController;
import org.jphototagger.program.module.keywords.tree.RenameKeywordController;
import org.jphototagger.program.module.keywords.tree.ToggleButtonExpandKeywordsTreeController;
import org.jphototagger.program.module.keywords.tree.ToggleRealKeywordController;
import org.jphototagger.program.module.metadatatemplates.AddMetadataTemplateController;
import org.jphototagger.program.module.metadatatemplates.DeleteMetadataTemplateController;
import org.jphototagger.program.module.metadatatemplates.EditMetadataTemplateController;
import org.jphototagger.program.module.metadatatemplates.RenameMetadataTemplateController;
import org.jphototagger.program.module.metadatatemplates.SetMetadataTemplateToSelectedImagesController;
import org.jphototagger.program.module.miscmetadata.AddMetadataToSelectedImagesController;
import org.jphototagger.program.module.miscmetadata.DeleteMiscMetadataController;
import org.jphototagger.program.module.miscmetadata.MiscMetadataItemSelectedController;
import org.jphototagger.program.module.miscmetadata.MiscMetadataPopupMenu;
import org.jphototagger.program.module.miscmetadata.RemoveMetadataFromSelectedImagesController;
import org.jphototagger.program.module.miscmetadata.RenameMiscMetadataController;
import org.jphototagger.program.module.programs.OpenFilesWithOtherAppController;
import org.jphototagger.program.module.programs.OpenFilesWithStandardAppController;
import org.jphototagger.program.module.rating.SetRatingController;
import org.jphototagger.program.module.search.AdvancedSearchController;
import org.jphototagger.program.module.search.CreateSavedSearchController;
import org.jphototagger.program.module.search.DeleteSavedSearchController;
import org.jphototagger.program.module.search.EditSavedSearchController;
import org.jphototagger.program.module.search.RenameSavedSearchController;
import org.jphototagger.program.module.search.SavedSearchSelectedController;
import org.jphototagger.program.module.search.ShowAdvancedSearchDialogAction;
import org.jphototagger.program.module.thumbnails.CopyOrCutFilesToClipboardController;
import org.jphototagger.program.module.thumbnails.CopyPasteMetadataController;
import org.jphototagger.program.module.thumbnails.CreateMetadataOfDisplayedThumbnailsController;
import org.jphototagger.program.module.thumbnails.CreateMetadataOfSelectedThumbnailsController;
import org.jphototagger.program.module.thumbnails.DeleteThumbnailsFromRepositoryController;
import org.jphototagger.program.module.thumbnails.PasteFilesFromClipboardController;
import org.jphototagger.program.module.thumbnails.RefreshThumbnailsPanelController;
import org.jphototagger.program.module.thumbnails.RotateThumbnailsController;
import org.jphototagger.program.module.thumbnails.SelectOrDeselectAllThumbnailsController;
import org.jphototagger.program.module.thumbnails.ThumbnailsPanelPersistenceController;
import org.jphototagger.program.module.thumbnails.ThumbnailsRepositoryChangesController;
import org.jphototagger.program.module.timeline.TimelineItemSelectedController;
import org.jphototagger.program.plugins.FileProcessorPluginsController;
import org.jphototagger.program.resource.GUI;
import org.jphototagger.program.settings.ShowUserSettingsDialogAction;

public final class ControllerFactory {
    public static final ControllerFactory INSTANCE = new ControllerFactory();
    private final FilesystemRepositoryUpdater fileSystemDbUpdater = FilesystemRepositoryUpdater.INSTANCE;
    private final Support support = new Support();
    private volatile boolean init;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        ControllerFactory controllerFactory = this;
        synchronized (controllerFactory) {
            if (!Support.checkInitOnlyOneTimes(this.getClass(), this.init)) {
                return;
            }
            this.init = true;
        }
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                String message = Bundle.getString(ControllerFactory.class, "ControllerFactory.Init.Start", new Object[0]);
                Support.setStatusbarInfo(message);
                ControllerFactory.this.addAppWindowMenuItemControllers();
                ControllerFactory.this.addAppWindowSelectionControllers();
                ControllerFactory.this.addImageCollectionControllers();
                ControllerFactory.this.addSavedSearchControllers();
                ControllerFactory.this.addSearchControllers();
                ControllerFactory.this.addThumbnailsPanelControllers();
                ControllerFactory.this.addFavoritesControllers();
                ControllerFactory.this.addDirectoryTreeControllers();
                ControllerFactory.this.addMetadataTemplatesControllers();
                ControllerFactory.this.addMiscMetadataControllers();
                ControllerFactory.this.addKeywordsControllers();
                ControllerFactory.this.addMiscControllers();
                message = Bundle.getString(ControllerFactory.class, "ControllerFactory.Init.Finished", new Object[0]);
                Support.setStatusbarInfo(message);
            }
        });
    }

    private void addAppWindowMenuItemControllers() {
        this.support.add(new MenuItemEnablerController());
        this.support.add(new ErrorLogHandler());
        this.support.add(new GoToController());
        this.support.add(new ShowAboutJPhotoTaggerAction());
        this.support.add(new ShowUserSettingsDialogAction());
        this.support.add(new ShowAdvancedSearchDialogAction());
        this.support.add(new EditKeywordSynonymsController());
    }

    private void addAppWindowSelectionControllers() {
        this.support.add(new MaximumOneTreeOrListItemSelectedController());
        this.support.add(new KeywordListItemSelectedController());
        this.support.add(new SavedSearchSelectedController());
        this.support.add(new ImageCollectionSelectedController());
        this.support.add(new CreateMetadataOfSelectedThumbnailsController());
        this.support.add(new KeywordsTreeItemSelectedController());
        this.support.add(new MiscMetadataItemSelectedController());
        this.support.add(new TimelineItemSelectedController());
        this.support.add(new FavoriteSelectedController());
        this.support.add(new DirectorySelectedController());
        this.support.add(new SelectOrDeselectAllThumbnailsController());
    }

    private void addImageCollectionControllers() {
        this.support.add(new AddImageCollectionController());
        this.support.add(new DeleteImageCollectionController());
        this.support.add(new DeleteFromImageCollectionController());
        this.support.add(new AddToImageCollectionController());
        this.support.add(new RenameImageCollectionController());
    }

    private void addSavedSearchControllers() {
        this.support.add(new CreateSavedSearchController());
        this.support.add(new DeleteSavedSearchController());
        this.support.add(new EditSavedSearchController());
        this.support.add(new RenameSavedSearchController());
    }

    private void addSearchControllers() {
        this.support.add(new AdvancedSearchController());
    }

    private void addThumbnailsPanelControllers() {
        this.support.add(new ThumbnailsPanelPersistenceController());
        this.support.add(new RotateThumbnailsController());
        this.support.add(new OpenFilesWithStandardAppController());
        this.support.add(new OpenFilesWithOtherAppController());
        this.support.add(new DeleteThumbnailsFromRepositoryController());
        this.support.add(new CreateMetadataOfDisplayedThumbnailsController());
        this.support.add(new CopyFilesToDirectoryController());
        this.support.add(new DeleteFilesController());
        this.support.add(new RenameFilesController());
        this.support.add(new MoveFilesController());
        this.support.add(new ThumbnailsRepositoryChangesController());
        this.support.add(new CopyOrCutFilesToClipboardController());
        this.support.add(new PasteFilesFromClipboardController());
        this.support.add(new RefreshThumbnailsPanelController());
        this.support.add(new PickRejectController());
        this.support.add(new SetRatingController());
        this.support.add(new CopyPasteMetadataController());
        this.support.add(new ActionsMenuUpdater());
    }

    private void addMiscMetadataControllers() {
        MiscMetadataPopupMenu popupAppWindow = new MiscMetadataPopupMenu(GUI.getAppPanel().getTreeMiscMetadata());
        this.support.add(new DeleteMiscMetadataController(popupAppWindow));
        this.support.add(new RenameMiscMetadataController(popupAppWindow));
        this.support.add(new AddMetadataToSelectedImagesController(popupAppWindow));
        this.support.add(new RemoveMetadataFromSelectedImagesController(popupAppWindow));
        MiscMetadataPopupMenu popupInputHelper = new MiscMetadataPopupMenu(InputHelperDialog.INSTANCE.getPanelMiscXmpMetadata().getTree());
        this.support.add(new DeleteMiscMetadataController(popupInputHelper));
        this.support.add(new RenameMiscMetadataController(popupInputHelper));
        this.support.add(new AddMetadataToSelectedImagesController(popupInputHelper));
        this.support.add(new RemoveMetadataFromSelectedImagesController(popupInputHelper));
    }

    private void addFavoritesControllers() {
        this.support.add(new InsertFavoriteController());
        this.support.add(new DeleteFavoriteController());
        this.support.add(new UpdateFavoriteController());
        this.support.add(new OpenFavoriteInDesktopController());
        this.support.add(new OpenFavoriteInDirectoriesTreeController());
        this.support.add(new MoveFavoriteController());
        this.support.add(new RefreshFavoritesController());
        this.support.add(new AddFilesystemFolderToFavoritesController());
        this.support.add(new RenameFilesystemFolderInFavoritesController());
        this.support.add(new DeleteFilesystemFolderFromFavoritesController());
    }

    private void addDirectoryTreeControllers() {
        this.support.add(new PasteFilesIntoDirectoryController());
        this.support.add(new CreateDirectoryController());
        this.support.add(new RenameDirectoryController());
        this.support.add(new DeleteDirectoryController());
        this.support.add(new RefreshDirectoryTreeController());
        this.support.add(new OpenDirectoryInDesktopController());
    }

    private void addKeywordsControllers() {
        KeywordsPanel[] keywordPanels;
        for (KeywordsPanel keywordsPanel : keywordPanels = new KeywordsPanel[]{GUI.getAppPanel().getPanelEditKeywords(), InputHelperDialog.INSTANCE.getPanelKeywords()}) {
            this.support.add(new ToggleRealKeywordController(keywordsPanel));
            this.support.add(new RenameKeywordController(keywordsPanel));
            this.support.add(new AddKeywordToTreeController(keywordsPanel));
            this.support.add(new DeleteKeywordsFromTreeController(keywordsPanel));
            this.support.add(new AddKeywordsToEditPanelController(keywordsPanel));
            this.support.add(new DeleteKeywordFromEditPanelController(keywordsPanel));
            this.support.add(new CopyCutPasteKeywordController(keywordsPanel));
            this.support.add(new KeywordsDisplayImagesController());
        }
        this.support.add(new HighlightKeywordsTreeController());
        this.support.add(new KeywordsRepositoryUpdatesController());
        this.support.add(new RenameKeywordsController());
        this.support.add(new DeleteKeywordsController());
        this.support.add(new ToggleButtonExpandKeywordsTreeController());
        this.support.add(new DisplayKeywordController());
        this.support.add(new InsertKeywordsController());
        this.support.add(new org.jphototagger.program.module.keywords.list.AddKeywordsToEditPanelController());
        this.support.add(new DeleteKeywordsFromEditPanelController());
    }

    private void addMetadataTemplatesControllers() {
        this.support.add(new SetMetadataTemplateToSelectedImagesController());
        this.support.add(new AddMetadataTemplateController());
        this.support.add(new EditMetadataTemplateController());
        this.support.add(new DeleteMetadataTemplateController());
        this.support.add(new RenameMetadataTemplateController());
    }

    private void addMiscControllers() {
        this.support.add(new FileProcessorPluginsController());
    }

    public <T> List<T> getControllers(Class<T> controllerClass) {
        if (controllerClass == null) {
            throw new NullPointerException("controllerClass == null");
        }
        return this.support.getAll(controllerClass);
    }

    public <T> T getController(Class<T> controllerClass) {
        if (controllerClass == null) {
            throw new NullPointerException("controllerClass == null");
        }
        return this.support.getFirst(controllerClass);
    }
}

