/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.factory;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import javax.swing.JMenuItem;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.program.factory.ControllerFactory;
import org.jphototagger.program.factory.Support;
import org.jphototagger.program.misc.InputHelperDialog;
import org.jphototagger.program.module.keywords.tree.AddKeywordToTreeController;
import org.jphototagger.program.module.keywords.tree.AddKeywordsToEditPanelController;
import org.jphototagger.program.module.keywords.tree.CopyCutPasteKeywordController;
import org.jphototagger.program.module.keywords.tree.DeleteKeywordFromEditPanelController;
import org.jphototagger.program.module.keywords.tree.DeleteKeywordsFromTreeController;
import org.jphototagger.program.module.keywords.tree.KeywordsDisplayImagesController;
import org.jphototagger.program.module.keywords.tree.KeywordsTreePopupMenu;
import org.jphototagger.program.module.keywords.tree.RenameKeywordController;
import org.jphototagger.program.module.keywords.tree.ToggleRealKeywordController;
import org.jphototagger.program.resource.GUI;

public final class ActionKeyListenerFactory {
    static final ActionKeyListenerFactory INSTANCE = new ActionKeyListenerFactory();
    private boolean init;

    synchronized void init() {
        Support.checkInitOnlyOneTimes(ActionKeyListenerFactory.class, this.init);
        if (!this.init) {
            this.init = true;
            EventQueueUtil.invokeInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    ActionKeyListenerFactory.this.addActionListeners();
                    ActionKeyListenerFactory.this.addKeyListeners();
                }
            });
        }
    }

    private void addActionListeners() {
        this.listenToPopupMenuKeywordsTrees();
    }

    private void addKeyListeners() {
        this.addKeyListener(CopyCutPasteKeywordController.class, GUI.getAppPanel().getTreeEditKeywords());
        this.addKeyListener(CopyCutPasteKeywordController.class, InputHelperDialog.INSTANCE.getPanelKeywords().getTree());
    }

    private void listenToPopupMenuKeywordsTrees() {
        KeywordsTreePopupMenu popup = KeywordsTreePopupMenu.INSTANCE;
        this.addActionListener(AddKeywordToTreeController.class, popup.getItemAdd());
        this.addActionListener(RenameKeywordController.class, popup.getItemRename());
        this.addActionListener(DeleteKeywordsFromTreeController.class, popup.getItemRemove());
        this.addActionListener(AddKeywordsToEditPanelController.class, popup.getItemAddToEditPanel());
        this.addActionListener(DeleteKeywordFromEditPanelController.class, popup.getItemRemoveFromEditPanel());
        this.addActionListener(ToggleRealKeywordController.class, popup.getItemToggleReal());
        this.addActionListener(CopyCutPasteKeywordController.class, popup.getItemCopy());
        this.addActionListener(CopyCutPasteKeywordController.class, popup.getItemCut());
        this.addActionListener(CopyCutPasteKeywordController.class, popup.getItemPaste());
        this.addActionListener(KeywordsDisplayImagesController.class, popup.getItemDisplayImages());
        this.addActionListener(KeywordsDisplayImagesController.class, popup.getItemDisplayImagesKw());
    }

    private void addActionListener(Class<? extends ActionListener> listenerClass, JMenuItem item) {
        ActionListener listener = ControllerFactory.INSTANCE.getController(listenerClass);
        item.addActionListener(listener);
    }

    private void addActionListeners(Class<? extends ActionListener> listenerClass, JMenuItem item) {
        for (ActionListener actionListener : ControllerFactory.INSTANCE.getControllers(listenerClass)) {
            item.addActionListener(actionListener);
        }
    }

    private void addKeyListener(Class<? extends KeyListener> listenerClass, Component c) {
        KeyListener listener = ControllerFactory.INSTANCE.getController(listenerClass);
        c.addKeyListener(listener);
    }
}

