/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.event.listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jphototagger.lib.swing.MouseEventUtil;
import org.jphototagger.lib.swing.util.TreeUtil;

public class TreeMouseListener
extends MouseAdapter
implements ActionListener {
    private JTree tree;
    private TreePath path;
    private int x;
    private int y;
    private JMenuItem itemExpandAllSubItems;
    private JMenuItem itemCollapseExpandAllSubItems;

    public void listenExpandAllSubItems(JMenuItem item, boolean listen) {
        if (item == null) {
            throw new NullPointerException("item == null");
        }
        JMenuItem jMenuItem = this.itemExpandAllSubItems = listen ? item : null;
        if (listen) {
            item.addActionListener(this);
        } else {
            item.removeActionListener(this);
        }
    }

    public void listenCollapseAllSubItems(JMenuItem item, boolean listen) {
        if (item == null) {
            throw new NullPointerException("item == null");
        }
        JMenuItem jMenuItem = this.itemCollapseExpandAllSubItems = listen ? item : null;
        if (listen) {
            item.addActionListener(this);
        } else {
            item.removeActionListener(this);
        }
    }

    protected void popupTrigger(JTree tree, TreePath path, int x, int y) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        Object source;
        if (!MouseEventUtil.isPopupTrigger(evt)) {
            return;
        }
        this.reset(TreeUtil.getTreePath(evt));
        if (this.path != null && (source = evt.getSource()) instanceof JTree) {
            this.tree = (JTree)source;
            this.popupTrigger(this.tree, this.path, evt.getX(), evt.getY());
        }
    }

    private void reset(TreePath p) {
        this.path = p;
        this.tree = null;
        this.x = -1;
        this.y = -1;
    }

    public JTree getTree() {
        return this.tree;
    }

    public TreePath getPath() {
        return this.path;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.itemExpandAllSubItems && this.tree != null) {
            TreeUtil.expandAll(this.tree, this.path, true);
        } else if (source == this.itemCollapseExpandAllSubItems && this.tree != null) {
            TreeUtil.expandAll(this.tree, this.path, false);
        }
    }
}

