/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import org.jphototagger.lib.datatransfer.TransferableObject;

public final class ReorderListItemsTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private static final DataFlavor INDICES_FLAVOR = new DataFlavor(LIST.class, null);
    private final JList<?> list;

    public ReorderListItemsTransferHandler(JList<?> list) {
        if (list == null) {
            throw new NullPointerException("list == null");
        }
        boolean modelOk = list.getModel() instanceof DefaultListModel;
        if (!modelOk) {
            throw new IllegalArgumentException("Not a DefaultListModel: " + list.getModel());
        }
        this.list = list;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        JList<?> sourceList = this.getSourceList(support);
        return support.isDrop() && this.list == sourceList && support.isDataFlavorSupported(INDICES_FLAVOR);
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JList sourceList = (JList)c;
        int[] selIndices = sourceList.getSelectedIndices();
        if (selIndices.length < 1) {
            return null;
        }
        return new TransferableObject(new IndexInfo(sourceList, selIndices), INDICES_FLAVOR);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        JList.DropLocation dl;
        int dropIndex;
        IndexInfo indexInfo = null;
        try {
            Object td = support.getTransferable().getTransferData(INDICES_FLAVOR);
            if (td instanceof IndexInfo) {
                indexInfo = (IndexInfo)td;
            }
        }
        catch (Throwable t) {
            Logger.getLogger(ReorderListItemsTransferHandler.class.getName()).log(Level.SEVERE, null, t);
        }
        if (indexInfo != null && (dropIndex = this.list.locationToIndex((dl = (JList.DropLocation)support.getDropLocation()).getDropPoint())) >= 0) {
            this.reorder(dropIndex, indexInfo.selIndices);
            return true;
        }
        return false;
    }

    private void reorder(int dropIndex, int[] selIndices) {
        if (selIndices.length < 1) {
            return;
        }
        Arrays.sort(selIndices);
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        ArrayList selValues = new ArrayList(selIndices.length);
        for (int index : selIndices) {
            try {
                selValues.add(model.get(index));
            }
            catch (Throwable t) {
                Logger.getLogger(ReorderListItemsTransferHandler.class.getName()).log(Level.SEVERE, null, t);
            }
        }
        for (Object selValue : selValues) {
            model.removeElement(selValue);
        }
        int insertIndex = dropIndex >= this.list.getModel().getSize() ? this.list.getModel().getSize() : dropIndex;
        for (Object selValue : selValues) {
            model.insertElementAt(selValue, insertIndex);
            ++insertIndex;
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return c == this.list ? 2 : 0;
    }

    private JList<?> getSourceList(TransferHandler.TransferSupport support) {
        try {
            Object td = support.getTransferable().getTransferData(INDICES_FLAVOR);
            if (td instanceof IndexInfo) {
                return ((IndexInfo)td).source;
            }
        }
        catch (Throwable t) {
            Logger.getLogger(ReorderListItemsTransferHandler.class.getName()).log(Level.SEVERE, null, t);
        }
        return null;
    }

    private final class IndexInfo {
        private final JList<?> source;
        private final int[] selIndices;

        IndexInfo(JList<?> source, int[] selIndices) {
            this.source = source;
            this.selIndices = selIndices;
        }
    }

    private final class LIST {
        private LIST() {
        }
    }
}

