/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.datatransfer;

import java.awt.Component;
import java.awt.Container;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.TransferHandler;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.templates.MetadataTemplate;
import org.jphototagger.domain.text.TextEntry;
import org.jphototagger.program.datatransfer.Flavor;
import org.jphototagger.program.module.editmetadata.EditRepeatableTextEntryPanel;

final class MetadataTemplateSupport {
    public static void setTemplate(TransferHandler.TransferSupport support) {
        try {
            Object[] selTemplates = (Object[])support.getTransferable().getTransferData(Flavor.METADATA_TEMPLATES);
            TextEntry textEntry = MetadataTemplateSupport.findParentTextEntry(support.getComponent());
            if (selTemplates != null && textEntry != null) {
                MetadataTemplate template = (MetadataTemplate)selTemplates[0];
                MetaDataValue mdValue = textEntry.getMetaDataValue();
                Object value = template.getMetaDataValue(mdValue);
                if (value instanceof String) {
                    textEntry.setText((String)value);
                    textEntry.setDirty(true);
                } else if (value instanceof Collection) {
                    EditRepeatableTextEntryPanel panel = MetadataTemplateSupport.findRepeatableTextEntryPanel(support.getComponent());
                    if (panel == null) {
                        return;
                    }
                    panel.setTexts((Collection)value);
                    panel.setDirty(true);
                }
            }
        }
        catch (Throwable t) {
            Logger.getLogger(MetadataTemplateSupport.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    private static EditRepeatableTextEntryPanel findRepeatableTextEntryPanel(Component c) {
        for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof EditRepeatableTextEntryPanel)) continue;
            return (EditRepeatableTextEntryPanel)parent;
        }
        return null;
    }

    private static TextEntry findParentTextEntry(Component c) {
        for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof TextEntry)) continue;
            return (TextEntry)((Object)parent);
        }
        return null;
    }

    private MetadataTemplateSupport() {
    }
}

