/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.TransferHandler;
import org.jphototagger.lib.datatransfer.TransferUtil;

public final class Flavor {
    public static final DataFlavor FILE_LIST_FLAVOR = DataFlavor.javaFileListFlavor;
    public static final DataFlavor URI_LIST = TransferUtil.getUriListFlavor();
    public static final DataFlavor THUMBNAILS_PANEL = new DataFlavor(THUMBNAILS_PANEL.class, null);
    public static final DataFlavor METADATA_TEMPLATES = new DataFlavor(METADATA_TEMPLATES.class, null);
    private static final List<DataFlavor> METADATA_FLAVORS = new ArrayList<DataFlavor>();
    public static final DataFlavor KEYWORDS_TREE = new DataFlavor(KEYWORDS_TREE.class, null);
    public static final DataFlavor KEYWORDS_LIST = new DataFlavor(KEYWORDS_LIST.class, null);
    public static final DataFlavor IMAGE_COLLECTION = new DataFlavor(IMAGE_COLLECTION.class, null);
    static final DataFlavor[] FILE_FLAVORS = new DataFlavor[]{FILE_LIST_FLAVOR, URI_LIST};
    public static final DataFlavor META_DATA_VALUE = new DataFlavor(META_DATA_VALUE.class, null);

    private Flavor() {
    }

    public static boolean isMetadataTransferred(Transferable t) {
        if (t == null) {
            throw new NullPointerException("t == null");
        }
        for (DataFlavor flavor : t.getTransferDataFlavors()) {
            if (!METADATA_FLAVORS.contains(flavor)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFiles(Transferable transferable) {
        if (transferable == null) {
            throw new NullPointerException("transferable == null");
        }
        return TransferUtil.isADataFlavorSupported(transferable, FILE_FLAVORS);
    }

    public static boolean hasKeywordsFromList(TransferHandler.TransferSupport support) {
        if (support == null) {
            throw new NullPointerException("support == null");
        }
        return support.isDataFlavorSupported(KEYWORDS_LIST);
    }

    public static boolean hasMetadataTemplate(TransferHandler.TransferSupport support) {
        if (support == null) {
            throw new NullPointerException("support == null");
        }
        return support.isDataFlavorSupported(METADATA_TEMPLATES);
    }

    public static boolean hasMetaDataValue(TransferHandler.TransferSupport support) {
        if (support == null) {
            throw new NullPointerException("support == null");
        }
        return support.isDataFlavorSupported(META_DATA_VALUE);
    }

    public static boolean hasKeywordsFromTree(TransferHandler.TransferSupport support) {
        if (support == null) {
            throw new NullPointerException("support == null");
        }
        return support.isDataFlavorSupported(KEYWORDS_TREE);
    }

    static {
        METADATA_FLAVORS.add(KEYWORDS_TREE);
        METADATA_FLAVORS.add(KEYWORDS_LIST);
        METADATA_FLAVORS.add(METADATA_TEMPLATES);
        METADATA_FLAVORS.add(META_DATA_VALUE);
    }

    private final class THUMBNAILS_PANEL {
        private THUMBNAILS_PANEL() {
        }
    }

    private final class METADATA_TEMPLATES {
        private METADATA_TEMPLATES() {
        }
    }

    private final class KEYWORDS_TREE {
        private KEYWORDS_TREE() {
        }
    }

    private final class KEYWORDS_LIST {
        private KEYWORDS_LIST() {
        }
    }

    private final class IMAGE_COLLECTION {
        private IMAGE_COLLECTION() {
        }
    }

    private final class META_DATA_VALUE {
        private META_DATA_VALUE() {
        }
    }
}

