/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.datatransfer;

import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jdesktop.swingx.JXList;
import org.jphototagger.domain.metadata.MetaDataValueData;
import org.jphototagger.program.datatransfer.DataTransferSupport;
import org.jphototagger.program.datatransfer.Flavor;
import org.jphototagger.program.datatransfer.MetadataTemplateSupport;
import org.jphototagger.program.module.keywords.KeywordsUtil;

public final class DropListTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        return Flavor.isMetadataTransferred(support.getTransferable());
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!support.isDrop()) {
            return false;
        }
        JXList list = (JXList)support.getComponent();
        DefaultListModel listModel = (DefaultListModel)list.getModel();
        Transferable transferable = support.getTransferable();
        if (Flavor.hasKeywordsFromList(support)) {
            return this.importKeywords(transferable, (DefaultListModel<Object>)listModel);
        }
        if (Flavor.hasKeywordsFromTree(support)) {
            return this.importKeywords(listModel, transferable);
        }
        if (Flavor.hasMetaDataValue(support)) {
            return this.importMetaDataValue(listModel, transferable);
        }
        if (Flavor.hasMetadataTemplate(support)) {
            MetadataTemplateSupport.setTemplate(support);
            return true;
        }
        return false;
    }

    private boolean importMetaDataValue(DefaultListModel<Object> listModel, Transferable transferable) {
        Collection<? extends MetaDataValueData> metaDataValues = DataTransferSupport.getMetaDataValueData(transferable);
        if (metaDataValues != null) {
            for (MetaDataValueData metaDataValueData : metaDataValues) {
                listModel.addElement(metaDataValueData.getData());
            }
        }
        return false;
    }

    private boolean importKeywords(Transferable transferable, DefaultListModel<Object> listModel) {
        Object[] keywords = DataTransferSupport.getKeywords(transferable);
        if (keywords == null) {
            return false;
        }
        return this.importStringArray(listModel, keywords);
    }

    private boolean importStringArray(DefaultListModel<Object> listModel, Object[] array) {
        for (Object o : array) {
            listModel.addElement(o);
        }
        return true;
    }

    private boolean importKeywords(DefaultListModel<Object> listModel, Transferable transferable) {
        List<DefaultMutableTreeNode> nodes = DataTransferSupport.getKeywordNodes(transferable);
        for (DefaultMutableTreeNode node : nodes) {
            this.importKeywords(node, listModel);
        }
        return true;
    }

    private void importKeywords(DefaultMutableTreeNode node, DefaultListModel<Object> listModel) {
        for (String keyword : KeywordsUtil.getKeywordStrings(node, true)) {
            if (listModel.contains(keyword)) continue;
            listModel.addElement(keyword);
        }
    }
}

