/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jphototagger.domain.filefilter.FileFilterUtil;
import org.jphototagger.domain.metadata.MetaDataValueData;
import org.jphototagger.lib.datatransfer.TransferUtil;
import org.jphototagger.program.datatransfer.Flavor;

public final class DataTransferSupport {
    private DataTransferSupport() {
    }

    public static Object[] getKeywords(Transferable transferable) {
        if (transferable == null) {
            throw new NullPointerException("transferable == null");
        }
        try {
            return (Object[])transferable.getTransferData(Flavor.KEYWORDS_LIST);
        }
        catch (Throwable t) {
            Logger.getLogger(DataTransferSupport.class.getName()).log(Level.SEVERE, null, t);
            return null;
        }
    }

    public static Collection<? extends MetaDataValueData> getMetaDataValueData(Transferable transferable) {
        if (transferable == null) {
            throw new NullPointerException("transferable == null");
        }
        try {
            return (Collection)transferable.getTransferData(Flavor.META_DATA_VALUE);
        }
        catch (Throwable t) {
            Logger.getLogger(DataTransferSupport.class.getName()).log(Level.SEVERE, null, t);
            return null;
        }
    }

    public static List<DefaultMutableTreeNode> getKeywordNodes(Transferable transferable) {
        if (transferable == null) {
            throw new NullPointerException("transferable == null");
        }
        try {
            return (List)transferable.getTransferData(Flavor.KEYWORDS_TREE);
        }
        catch (Throwable t) {
            Logger.getLogger(DataTransferSupport.class.getName()).log(Level.SEVERE, null, t);
            return null;
        }
    }

    public static String getStringFromMetaDataValueData(Collection<? extends MetaDataValueData> mdValueData) {
        if (mdValueData != null) {
            StringBuilder sb = new StringBuilder();
            int index = 0;
            for (MetaDataValueData metaDataValueData : mdValueData) {
                sb.append(index == 0 ? "" : ";");
                sb.append(metaDataValueData.getData().toString());
                ++index;
            }
            return sb.toString();
        }
        return "";
    }

    public static String getString(Transferable transferable) {
        if (transferable == null) {
            throw new NullPointerException("transferable == null");
        }
        try {
            return (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Throwable t) {
            Logger.getLogger(DataTransferSupport.class.getName()).log(Level.SEVERE, null, t);
            return null;
        }
    }

    public static List<File> getImageFiles(TransferHandler.TransferSupport support) {
        List<File> files = TransferUtil.getFiles(support.getTransferable(), TransferUtil.FilenameDelimiter.NEWLINE);
        return FileFilterUtil.getImageFiles(files);
    }
}

