/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.app.update;

import java.awt.EventQueue;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.concurrent.CancelRequest;
import org.jphototagger.api.concurrent.Cancelable;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressHandle;
import org.jphototagger.api.progress.ProgressHandleFactory;
import org.jphototagger.api.storage.PreferencesDirectoryProvider;
import org.jphototagger.domain.repository.ApplicationPropertiesRepository;
import org.jphototagger.lib.net.HttpUtil;
import org.jphototagger.lib.net.NetVersion;
import org.jphototagger.lib.swing.DirectoryChooser;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.SystemUtil;
import org.jphototagger.lib.util.Version;
import org.jphototagger.program.app.AppInfo;
import org.jphototagger.program.app.AppLifeCycle;
import org.jphototagger.program.misc.FinalExecutable;
import org.openide.util.Lookup;

public final class UpdateDownload
extends Thread
implements CancelRequest,
Cancelable {
    private static final String FILENAME_WINDOWS = "JPhotoTagger-Setup.exe";
    private static final String FILENAME_ZIP = "JPhotoTagger.zip";
    private static final String URL_VERSION_CHECK_FILE = "http://www.jphototagger.org/jphototagger-version.txt";
    private static final String URL_WIN_INSTALLER = "http://www.jphototagger.org/dist/JPhotoTagger-setup.exe";
    private static final String URL_ZIP = "http://www.jphototagger.org/dist/JPhotoTagger.zip";
    private static final String VERSION_DELIMITER = ".";
    private static final String KEY_PREV_DOWNLOAD_DIR = "UpdateDownload.PrevDownloadDir";
    private static final Preferences PREFS = Lookup.getDefault().lookup(Preferences.class);
    private final Version currentVersion;
    private Version netVersion;
    private volatile boolean cancel;
    private static boolean checkPending;
    private final Object source;
    private static final Logger LOGGER;
    private ProgressHandle progressHandle;
    private static final String KEY_ASK_ONCE_CHECK_FOR_NEWER_VERSION = "UpdateDownload.CheckForNewerVersion";

    public UpdateDownload() {
        super("JPhotoTagger: Checking for and downloading newer version");
        this.netVersion = this.currentVersion = Version.parseVersion(AppInfo.APP_VERSION, VERSION_DELIMITER);
        this.source = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCheckPending() {
        Class<UpdateDownload> clazz = UpdateDownload.class;
        synchronized (UpdateDownload.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return checkPending;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkForNewerVersion() {
        Class<UpdateDownload> clazz = UpdateDownload.class;
        synchronized (UpdateDownload.class) {
            if (checkPending) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            checkPending = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            new UpdateDownload().start();
            return;
        }
    }

    public static void askOnceCheckForNewerVersion() {
        final ApplicationPropertiesRepository appPropertiesRepo = Lookup.getDefault().lookup(ApplicationPropertiesRepository.class);
        if (!appPropertiesRepo.getBoolean(KEY_ASK_ONCE_CHECK_FOR_NEWER_VERSION)) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        String message = Bundle.getString(UpdateDownload.class, "UpdateDownload.Confirm.CheckForNewerVersion", new Object[0]);
                        boolean isAutoDownload = MessageDisplayer.confirmYesNo(null, message);
                        UpdateDownload.setCheckForUpdates(isAutoDownload);
                        appPropertiesRepo.setBoolean(UpdateDownload.KEY_ASK_ONCE_CHECK_FOR_NEWER_VERSION, true);
                    }
                });
            }
            catch (Throwable t) {
                Logger.getLogger(UpdateDownload.class.getName()).log(Level.SEVERE, null, t);
            }
        }
    }

    private static void setCheckForUpdates(boolean auto) {
        PREFS.setBoolean("UserSettings.AutoDownloadNewerVersions", auto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.startProgressHandle();
            this.netVersion = NetVersion.getOverHttp(URL_VERSION_CHECK_FILE, VERSION_DELIMITER);
            String message = Bundle.getString(UpdateDownload.class, "UpdateDownload.Confirm.Download", this.currentVersion.toString3(), this.netVersion.toString3());
            if (this.hasNewerVersion() && MessageDisplayer.confirmYesNo(null, message)) {
                this.progressBarDownloadInfo();
                File downloadFile = this.chooseDownloadFile();
                if (downloadFile == null) {
                    return;
                }
                this.download(downloadFile);
                if (this.cancel && downloadFile.exists() && !downloadFile.delete()) {
                    LOGGER.log(Level.WARNING, "Uncomplete downloaded file ''{0}'' couldn''t be deleted!", downloadFile);
                }
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "The most recent version of JPhotoTagger couldn''t be retrieved: {0}", t.getLocalizedMessage());
        }
        finally {
            Class<UpdateDownload> clazz = UpdateDownload.class;
            synchronized (UpdateDownload.class) {
                this.progressHandle.progressEnded();
                checkPending = false;
                // ** MonitorExit[var3_5] (shouldn't be in output)
            }
        }
    }

    private void download(File targetFile) {
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(targetFile));
            HttpUtil.write(new URL(this.getDownloadUrl()), os, this);
            if (this.cancel) {
                return;
            }
            if (SystemUtil.isWindows()) {
                this.setFinalExecutable(targetFile);
            } else {
                String message = Bundle.getString(UpdateDownload.class, "UpdateDownload.Info.Success", targetFile);
                MessageDisplayer.information(null, message);
            }
        }
        catch (Throwable t) {
            Logger.getLogger(UpdateDownload.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    private void setFinalExecutable(File downloadFile) {
        String message = Bundle.getString(UpdateDownload.class, "UpdateDownload.Confirm.SetFinalExecutable", downloadFile);
        if (MessageDisplayer.confirmYesNo(null, message)) {
            FinalExecutable exec = new FinalExecutable(downloadFile.getAbsolutePath());
            AppLifeCycle.INSTANCE.addFinalTask(exec);
        }
    }

    private String getDownloadUrl() {
        return SystemUtil.isWindows() ? URL_WIN_INSTALLER : URL_ZIP;
    }

    private File chooseDownloadFile() {
        String dirname = this.chooseDownloadDirectory();
        if (dirname == null) {
            return null;
        }
        String filename = SystemUtil.isWindows() ? FILENAME_WINDOWS : FILENAME_ZIP;
        return new File(dirname + File.separator + filename);
    }

    private String chooseDownloadDirectory() {
        String downloadDirectory = this.suggestDownloadDirectory();
        DirectoryChooser dirChooser = new DirectoryChooser(ComponentUtil.findFrameWithIcon(), new File(downloadDirectory), DirectoryChooser.Option.NO_OPTION);
        dirChooser.setTitle(Bundle.getString(UpdateDownload.class, "UpdateDownload.ChooseDownloadDirectory.Title", new Object[0]));
        dirChooser.setVisible(true);
        if (dirChooser.isAccepted()) {
            downloadDirectory = dirChooser.getSelectedDirectories().get(0).getAbsolutePath();
            PREFS.setString(KEY_PREV_DOWNLOAD_DIR, downloadDirectory);
            return downloadDirectory;
        }
        return null;
    }

    private String suggestDownloadDirectory() {
        String dir = null;
        if (PREFS.containsKey(KEY_PREV_DOWNLOAD_DIR)) {
            dir = PREFS.getString(KEY_PREV_DOWNLOAD_DIR);
        }
        if (dir == null || !new File(dir).isDirectory()) {
            PreferencesDirectoryProvider provider = Lookup.getDefault().lookup(PreferencesDirectoryProvider.class);
            dir = provider.getUserPreferencesDirectory().getAbsolutePath();
        }
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProgressHandle() {
        ProgressEvent evt = new ProgressEvent.Builder().source(this.source).indeterminate(true).stringPainted(true).stringToPaint(Bundle.getString(UpdateDownload.class, "UpdateDownload.Info.ProgressBar", new Object[0])).build();
        Class<UpdateDownload> clazz = UpdateDownload.class;
        synchronized (UpdateDownload.class) {
            this.progressHandle = Lookup.getDefault().lookup(ProgressHandleFactory.class).createProgressHandle(this);
            this.progressHandle.progressStarted(evt);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void progressBarDownloadInfo() {
        ProgressEvent evt = new ProgressEvent.Builder().source(this.source).indeterminate(true).stringPainted(true).stringToPaint(Bundle.getString(UpdateDownload.class, "UpdateDownload.Info.ProgressBarDownload", new Object[0])).build();
        Class<UpdateDownload> clazz = UpdateDownload.class;
        synchronized (UpdateDownload.class) {
            this.progressHandle.progressPerformed(evt);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private boolean hasNewerVersion() throws Exception {
        return this.currentVersion.compareTo(this.netVersion) < 0;
    }

    @Override
    public boolean isCancel() {
        return this.cancel;
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    static {
        LOGGER = Logger.getLogger(UpdateDownload.class.getName());
    }
}

