/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.app.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.program.app.AppInfo;

public final class SplashScreen {
    private static final int MESSAGE_X = 10;
    private static final Color MESSAGE_COLOR = Color.BLACK;
    private static final int MESSAGE_FONT_SIZE = 12;
    private static final Font MESSAGE_FONT = new Font("Arial", 0, 12);
    private static final Font MESSAGE_HEADER_FONT = new Font(MESSAGE_FONT.getName(), 1, 18);
    private static final Color SLOGAN_COLOR = Color.BLUE;
    private static final int SLOGAN_PADDING_TO_MESSAGE = 15;
    private static final int PROGRESSBAR_HEIGHT = 15;
    private static final int PROGRESSBAR_PADDING_TO_TEXT = 10;
    private static final int PROGRESSBAR_PADDING_TO_BOTTOM = 20;
    private static final Color PROGRESSBAR_BORDER_COLOR = new Color(225, 225, 225);
    private static final Color PROGRESSBAR_COLOR = new Color(234, 233, 254);
    private static final Color BACKGROUND_COLOR = new Color(250, 250, 250);
    private final java.awt.SplashScreen splash = java.awt.SplashScreen.getSplashScreen();
    private Rectangle splashBounds;
    private Graphics2D graphics;
    private String message = "";
    private int progressValue;
    private volatile boolean init;
    public static final SplashScreen INSTANCE = new SplashScreen();
    private static final Logger LOGGER = Logger.getLogger(SplashScreen.class.getName());

    public synchronized void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        if (this.splash == null) {
            return;
        }
        this.splashBounds = this.splash.getBounds();
        this.graphics = this.splash.createGraphics();
        if (this.graphics == null) {
            return;
        }
        this.graphics.setColor(Color.LIGHT_GRAY);
        this.graphics.drawRect(0, 0, this.splashBounds.width - 1, this.splashBounds.height - 1);
    }

    public void close() {
        if (this.splash != null) {
            this.splash.close();
        }
    }

    public void setProgress(int value) {
        assert (this.init);
        assert (value >= 0 && value <= 100) : value;
        if (value >= 0 && value <= 100) {
            this.progressValue = value;
        }
        if (this.canDisplay()) {
            this.updateDisplay();
        }
    }

    public void removeMessage() {
        this.setMessage("");
    }

    public void setMessage(String message) {
        assert (this.init);
        this.message = message;
        LOGGER.log(Level.INFO, message);
        if (this.canDisplay()) {
            this.updateDisplay();
        }
    }

    private boolean canDisplay() {
        return this.splash != null && this.graphics != null;
    }

    private void updateDisplay() {
        this.updateMessage();
        this.updateProgressBar();
        this.updateAppInfo();
        this.splash.update();
    }

    private void updateProgressBar() {
        int barWidth = this.splashBounds.width - 20;
        int progressWidth = barWidth * this.progressValue / 100 - 1;
        int x = 10;
        int y = this.splashBounds.height - 20 - 15;
        this.graphics.setComposite(AlphaComposite.Clear);
        this.graphics.setPaintMode();
        this.graphics.setColor(PROGRESSBAR_BORDER_COLOR);
        this.graphics.drawRect(10, y, barWidth, 15);
        this.graphics.setColor(PROGRESSBAR_COLOR);
        this.graphics.fillRect(11, y + 1, progressWidth, 14);
    }

    private void updateMessage() {
        this.graphics.setFont(MESSAGE_FONT);
        this.graphics.setComposite(AlphaComposite.Clear);
        this.graphics.setPaintMode();
        this.clearMessage();
        this.drawMessage();
    }

    private void clearMessage() {
        int messageHeight = this.getMessageHeight();
        this.graphics.setColor(BACKGROUND_COLOR);
        this.graphics.fillRect(10, this.getMessageY() - messageHeight, this.splashBounds.width - 10 - 1, messageHeight + 5);
    }

    private int getMessageY() {
        return this.splashBounds.height - 20 - 15 - 10;
    }

    private int getMessageHeight() {
        FontMetrics fm = this.graphics.getFontMetrics(MESSAGE_FONT);
        return fm.getHeight();
    }

    private void drawMessage() {
        this.graphics.setColor(MESSAGE_COLOR);
        this.graphics.setFont(MESSAGE_FONT);
        this.graphics.drawString(this.message, 10, this.getMessageY());
    }

    private void updateAppInfo() {
        int messageHeight = this.getMessageHeight();
        int boldFontHeight = this.graphics.getFontMetrics(MESSAGE_HEADER_FONT).getHeight();
        int y = this.getMessageY() - messageHeight - 15 - boldFontHeight;
        this.graphics.setFont(MESSAGE_HEADER_FONT);
        this.graphics.setColor(MESSAGE_COLOR);
        this.graphics.drawString("JPhotoTagger " + AppInfo.APP_VERSION, 10, y);
        this.graphics.setFont(MESSAGE_FONT);
        this.graphics.setColor(SLOGAN_COLOR);
        this.graphics.drawString(AppInfo.APP_DESCRIPTION, 10, y + boldFontHeight);
    }

    private SplashScreen() {
    }
}

