/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.app.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jphototagger.api.concurrent.Cancelable;
import org.jphototagger.api.progress.ProgressHandle;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.program.app.ui.AppLookAndFeel;
import org.jphototagger.program.app.ui.ProgressBarPanel;
import org.jphototagger.program.app.ui.ProgressBarPanelListener;

public class ProgressBarPanelArray
extends JPanel
implements ProgressBarPanelListener {
    private static final long serialVersionUID = 1L;
    private final List<ProgressBarPanel> inactiveProgressBarPanels = new ArrayList<ProgressBarPanel>();
    private final List<ProgressBarPanel> activeProgressBarPanels = new ArrayList<ProgressBarPanel>();
    private static final Icon DOWN_ARROW_ICON = IconUtil.getImageIcon(ProgressBarPanelArray.class, "arrow_down.png");
    private static final Icon UP_ARROW_ICON = IconUtil.getImageIcon(ProgressBarPanelArray.class, "arrow_up.png");
    private final ToggleVisibilityOfHiddenProgressBars toggleVisibilityOfHiddenProgressBars = new ToggleVisibilityOfHiddenProgressBars();
    private ProgressBarPanel visibleProgressBarPanel;
    private JButton buttonToggleVisibilityOfHiddenProgressBars;
    private JDialog dialogHiddenProgressBars;
    private ProgressBarPanel initProgressBarPanel;
    private JPanel panelHiddenProgressBars;
    private JScrollPane scrollPaneHiddenProgressBars;

    public ProgressBarPanelArray() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.visibleProgressBarPanel = this.initProgressBarPanel;
        this.buttonToggleVisibilityOfHiddenProgressBars.addActionListener(this.toggleVisibilityOfHiddenProgressBars);
    }

    public synchronized ProgressHandle createHandle() {
        return this.addProgressBarPanel(new ProgressBarPanel());
    }

    public synchronized ProgressHandle createHandle(Cancelable cancelable) {
        return this.addProgressBarPanel(new ProgressBarPanel(cancelable));
    }

    private synchronized ProgressBarPanel addProgressBarPanel(ProgressBarPanel progressBarPanel) {
        progressBarPanel.addProgressBarPanelListener(this);
        progressBarPanel.addMouseListener(this.toggleVisibilityOfHiddenProgressBars);
        this.inactiveProgressBarPanels.add(progressBarPanel);
        return progressBarPanel;
    }

    private synchronized void showActiveProgressBarPanel(ProgressBarPanel progressBarPanel) {
        if (this.activeProgressBarPanels.isEmpty()) {
            this.remove(this.visibleProgressBarPanel);
            this.add((Component)progressBarPanel, this.getProgressBarPanelGbc());
            this.visibleProgressBarPanel = progressBarPanel;
            this.repaintThis();
        } else {
            this.panelHiddenProgressBars.add((Component)progressBarPanel, this.getHiddenProgressBarPanelGbc());
            this.repaintHiddenProgressBars();
        }
        this.inactiveProgressBarPanels.remove(progressBarPanel);
        this.activeProgressBarPanels.add(progressBarPanel);
        this.setEnabledButtonToggleEnabled();
    }

    private synchronized void setEnabledButtonToggleEnabled() {
        this.buttonToggleVisibilityOfHiddenProgressBars.setEnabled(this.isMultipleTasks());
    }

    private GridBagConstraints getProgressBarPanelGbc() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        return gbc;
    }

    private GridBagConstraints getHiddenProgressBarPanelGbc() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        return gbc;
    }

    private synchronized void removeProgressBarPanel(ProgressBarPanel progressBarPanel) {
        if (this.isAncestorOf(progressBarPanel)) {
            this.setProgressBarPanelFromHidden();
        } else {
            this.panelHiddenProgressBars.remove(progressBarPanel);
            this.repaintHiddenProgressBars();
        }
        this.activeProgressBarPanels.remove(progressBarPanel);
        if (!this.isMultipleTasks() && this.dialogHiddenProgressBars.isVisible()) {
            this.toggleVisibilityOfHiddenProgressBars();
        }
        this.setEnabledButtonToggleEnabled();
    }

    private void repaintThis() {
        ComponentUtil.forceRepaint(this);
        ComponentUtil.forceRepaint(this.getParent());
    }

    private synchronized void setProgressBarPanelFromHidden() {
        List<ProgressBarPanel> pbPanels = ComponentUtil.getAllOf(this.panelHiddenProgressBars, ProgressBarPanel.class);
        if (!pbPanels.isEmpty()) {
            this.remove(this.visibleProgressBarPanel);
            ProgressBarPanel pbPanel = pbPanels.get(0);
            this.panelHiddenProgressBars.remove(pbPanel);
            this.visibleProgressBarPanel = pbPanel;
            this.add((Component)pbPanel, this.getProgressBarPanelGbc());
            ComponentUtil.forceRepaint(pbPanel);
            this.repaintHiddenProgressBars();
            this.repaintThis();
        }
    }

    private void repaintHiddenProgressBars() {
        ComponentUtil.forceRepaint(this.panelHiddenProgressBars);
        Dimension size = this.panelHiddenProgressBars.getPreferredSize();
        this.scrollPaneHiddenProgressBars.setPreferredSize(new Dimension(size.width + 2, size.height + 2));
        ComponentUtil.forceRepaint(this.dialogHiddenProgressBars);
        this.setProgressBarDialogLocation();
    }

    private synchronized void toggleVisibilityOfHiddenProgressBars() {
        boolean multipleTasks = this.isMultipleTasks();
        boolean hide = !multipleTasks || this.dialogHiddenProgressBars.isVisible();
        this.buttonToggleVisibilityOfHiddenProgressBars.setIcon(hide ? UP_ARROW_ICON : DOWN_ARROW_ICON);
        if (hide) {
            this.dialogHiddenProgressBars.setVisible(false);
            return;
        }
        this.setProgressBarDialogLocation();
        this.dialogHiddenProgressBars.setVisible(true);
    }

    private void setProgressBarDialogLocation() {
        this.dialogHiddenProgressBars.pack();
        Point locationOnScreen = this.getLocationOnScreen();
        int xRight = locationOnScreen.x + this.getWidth();
        int yTop = locationOnScreen.y;
        int dialogWidth = this.dialogHiddenProgressBars.getWidth();
        int dialogHeight = this.dialogHiddenProgressBars.getHeight();
        this.dialogHiddenProgressBars.setLocation(xRight - dialogWidth, yTop - dialogHeight);
    }

    public synchronized boolean hasActiveTasks() {
        return !this.activeProgressBarPanels.isEmpty();
    }

    public synchronized boolean hasInactiveTasks() {
        return !this.inactiveProgressBarPanels.isEmpty();
    }

    private synchronized boolean isMultipleTasks() {
        return this.activeProgressBarPanels.size() > 1;
    }

    @Override
    public void progressStarted(ProgressBarPanel source) {
        this.showActiveProgressBarPanel(source);
    }

    @Override
    public void progressEnded(ProgressBarPanel source) {
        this.removeProgressBarPanel(source);
    }

    private void initComponents() {
        this.dialogHiddenProgressBars = new JDialog();
        this.scrollPaneHiddenProgressBars = new JScrollPane();
        this.panelHiddenProgressBars = new JPanel();
        this.initProgressBarPanel = new ProgressBarPanel();
        this.buttonToggleVisibilityOfHiddenProgressBars = new JButton();
        this.dialogHiddenProgressBars.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/app/ui/Bundle");
        this.dialogHiddenProgressBars.setTitle(bundle.getString("ProgressBarPanelArray.dialogHiddenProgressBars.title"));
        this.dialogHiddenProgressBars.setAlwaysOnTop(true);
        this.dialogHiddenProgressBars.setIconImages(AppLookAndFeel.getAppIcons());
        this.dialogHiddenProgressBars.setUndecorated(true);
        this.dialogHiddenProgressBars.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProgressBarPanelArray.this.dialogHiddenProgressBarsWindowClosing(evt);
            }
        });
        this.dialogHiddenProgressBars.getContentPane().setLayout(new GridBagLayout());
        this.scrollPaneHiddenProgressBars.setBorder(BorderFactory.createLineBorder(new Color(195, 195, 195)));
        this.scrollPaneHiddenProgressBars.setHorizontalScrollBarPolicy(31);
        this.panelHiddenProgressBars.setLayout(new GridBagLayout());
        this.scrollPaneHiddenProgressBars.setViewportView(this.panelHiddenProgressBars);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.dialogHiddenProgressBars.getContentPane().add((Component)this.scrollPaneHiddenProgressBars, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.initProgressBarPanel, gridBagConstraints);
        this.buttonToggleVisibilityOfHiddenProgressBars.setIcon(UP_ARROW_ICON);
        this.buttonToggleVisibilityOfHiddenProgressBars.setToolTipText(bundle.getString("ProgressBarPanelArray.buttonToggleVisibilityOfHiddenProgressBars.toolTipText"));
        this.buttonToggleVisibilityOfHiddenProgressBars.setBorder(null);
        this.buttonToggleVisibilityOfHiddenProgressBars.setEnabled(false);
        this.buttonToggleVisibilityOfHiddenProgressBars.setMargin(new Insets(0, 0, 0, 0));
        this.buttonToggleVisibilityOfHiddenProgressBars.setPreferredSize(new Dimension(18, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.buttonToggleVisibilityOfHiddenProgressBars, gridBagConstraints);
    }

    private void dialogHiddenProgressBarsWindowClosing(WindowEvent evt) {
        this.toggleVisibilityOfHiddenProgressBars();
    }

    private class ToggleVisibilityOfHiddenProgressBars
    extends MouseAdapter
    implements ActionListener {
        private static final long serialVersionUID = 1L;

        private ToggleVisibilityOfHiddenProgressBars() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProgressBarPanelArray.this.toggleVisibilityOfHiddenProgressBars();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ProgressBarPanelArray.this.toggleVisibilityOfHiddenProgressBars();
        }
    }
}

