/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.app.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jphototagger.api.concurrent.Cancelable;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressHandle;
import org.jphototagger.domain.event.listener.ListenerSupport;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.program.app.ui.ProgressBarPanelListener;

public class ProgressBarPanel
extends JPanel
implements ProgressHandle {
    private static final long serialVersionUID = 1L;
    private final ListenerSupport<ProgressBarPanelListener> ls = new ListenerSupport();
    private final Cancelable cancelable;
    private JButton buttonCancelProgress;
    private JProgressBar progressBar;

    public ProgressBarPanel() {
        this((Cancelable)null);
    }

    public ProgressBarPanel(Cancelable cancelable) {
        this.cancelable = cancelable;
        this.initComponents();
    }

    @Override
    public void progressStarted(final ProgressEvent evt) {
        this.setName("Progress bar for " + evt.getSource());
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                ProgressBarPanel.this.notifyProgressStarted();
                ProgressBarPanel.this.setEventToProgressBar(evt);
            }
        });
    }

    @Override
    public void progressPerformed(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                ProgressBarPanel.this.setEventToProgressBar(evt);
            }
        });
    }

    @Override
    public void progressEnded() {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                ProgressBarPanel.this.progressBar.setValue(0);
                ProgressBarPanel.this.progressBar.setString("");
                ProgressBarPanel.this.progressBar.setStringPainted(false);
                ProgressBarPanel.this.progressBar.setIndeterminate(false);
                ProgressBarPanel.this.buttonCancelProgress.setEnabled(false);
                ProgressBarPanel.this.notifyProgressEnded();
            }
        });
    }

    private void setEventToProgressBar(ProgressEvent evt) {
        if (evt.isIndeterminate()) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setMinimum(evt.getMinimum());
            this.progressBar.setMaximum(evt.getMaximum());
            this.progressBar.setValue(evt.getValue());
        }
        this.progressBar.setStringPainted(evt.isStringPainted());
        this.progressBar.setString(evt.getStringToPaint());
    }

    private void cancel() {
        if (this.cancelable != null) {
            this.cancelable.cancel();
            this.buttonCancelProgress.setEnabled(false);
        }
    }

    void addProgressBarPanelListener(ProgressBarPanelListener listener) {
        this.ls.add(listener);
    }

    void removeProgressBarPanelListener(ProgressBarPanelListener listener) {
        this.ls.remove(listener);
    }

    private void notifyProgressStarted() {
        Set<ProgressBarPanelListener> listeners = this.ls.get();
        for (ProgressBarPanelListener listener : listeners) {
            listener.progressStarted(this);
        }
    }

    private void notifyProgressEnded() {
        Set<ProgressBarPanelListener> listeners = this.ls.get();
        for (ProgressBarPanelListener listener : listeners) {
            listener.progressEnded(this);
        }
    }

    @Override
    public void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.progressBar.addMouseListener(l);
    }

    private void initComponents() {
        this.progressBar = new JProgressBar();
        this.buttonCancelProgress = new JButton();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.progressBar.setMaximumSize(new Dimension(300, 14));
        this.progressBar.setName("progressBar");
        this.progressBar.setPreferredSize(new Dimension(250, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.progressBar, gridBagConstraints);
        this.buttonCancelProgress.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/app/ui/cancel.png")));
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/app/ui/Bundle");
        this.buttonCancelProgress.setToolTipText(bundle.getString("ProgressBarPanel.buttonCancelProgress.toolTipText"));
        this.buttonCancelProgress.setBorder(null);
        this.buttonCancelProgress.setContentAreaFilled(false);
        this.buttonCancelProgress.setEnabled(this.cancelable != null);
        this.buttonCancelProgress.setName("buttonCancelProgress");
        this.buttonCancelProgress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgressBarPanel.this.buttonCancelProgressActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.buttonCancelProgress, gridBagConstraints);
    }

    private void buttonCancelProgressActionPerformed(ActionEvent evt) {
        this.cancel();
    }
}

