/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.app.ui;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JComponent;
import org.jphototagger.program.app.ui.AppLookAndFeel;

public class MetadataLabelFormatter {
    public static final Color SELECTION_FOREGROUND = AppLookAndFeel.getTableSelectionForeground();
    public static final Color TABLE_BACKGROUND = AppLookAndFeel.getTableBackground();
    public static final Color TABLE_FOREGROUND = AppLookAndFeel.getTableForeground();
    public static final Color TABLE_SELECTION_BACKGROUND = AppLookAndFeel.getTableSelectionBackground();
    private Font headerFont = null;
    private Font contentFont = null;

    protected static void setDefaultCellColors(JComponent cellLabel, boolean isSelected) {
        cellLabel.setForeground(isSelected ? SELECTION_FOREGROUND : TABLE_FOREGROUND);
        cellLabel.setBackground(isSelected ? TABLE_SELECTION_BACKGROUND : TABLE_BACKGROUND);
        cellLabel.setOpaque(true);
    }

    protected void setHeaderFont(JComponent cellLabel) {
        this.initFonts(cellLabel);
        cellLabel.setFont(this.headerFont);
    }

    protected void setContentFont(JComponent cellLabel) {
        this.initFonts(cellLabel);
        cellLabel.setFont(this.contentFont);
    }

    private void initFonts(JComponent cellLabel) {
        if (this.headerFont == null) {
            Font cellFont = cellLabel.getFont();
            String cellFontName = cellFont.getName();
            int cellFontSize = cellFont.getSize();
            this.headerFont = new Font(cellFontName, 1, cellFontSize);
            this.contentFont = new Font(cellFontName, 0, cellFontSize);
        }
    }
}

