/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.app.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JList;
import javax.swing.JTree;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.applifecycle.AppWillExitEvent;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesHints;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.program.app.ui.AppFrame;
import org.jphototagger.program.app.ui.AppPanel;
import org.jphototagger.program.module.keywords.KeywordsPanel;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class AppWindowPersistence
implements ComponentListener {
    private static final String KEY_DIVIDER_LOCATION_MAIN = "AppPanel.DividerLocationMain";
    private static final String KEY_DIVIDER_LOCATION_THUMBNAILS = "AppPanel.DividerLocationThumbnails";
    private static final String KEY_KEYWORDS_VIEW = "AppPanel.KeywordsView";
    private static final String APP_PANEL_TREE_DIRECTORIES = "org.jphototagger.program.app.ui.AppPanel.treeDirectories";
    private static final String APP_PANEL_TREE_FAVORITES = "org.jphototagger.program.app.ui.AppPanel.treeFavorites";
    private static final String APP_PANEL_TREE_SEL_KEYWORDS = "org.jphototagger.program.app.ui.AppPanel.treeSelKeywords";
    private static final String APP_PANEL_TREE_EDIT_KEYWORDS = "AppPanel.Keywords.Tree";
    private static final String APP_PANEL_TREE_MISC_METADATA = "org.jphototagger.program.app.ui.AppPanel.treeMiscMetadata";
    private static final String APP_PANEL_TREE_TIMELINE = "org.jphototagger.program.app.ui.AppPanel.treeTimeline";
    private static final String APP_PANEL_LIST_IMAGE_COLLECTIONS = "org.jphototagger.program.app.ui.AppPanel.listImageCollections";
    private static final String APP_PANEL_LIST_NO_METADATA = "org.jphototagger.program.app.ui.AppPanel.listNoMetadata";
    private static final String APP_PANEL_LIST_SAVED_SEARCHES = "org.jphototagger.program.app.ui.AppPanel.listSavedSearches";
    private static final String APP_PANEL_LIST_SEL_KEYWORDS = "org.jphototagger.program.app.ui.AppPanel.listSelKeywords";
    private final Component cardSelKeywordsList = GUI.getAppPanel().getCardSelKeywordsList();
    private final Component cardSelKeywordsTree = GUI.getAppPanel().getCardSelKeywordsTree();
    private final Map<Component, String> NAME_OF_CARD = new HashMap<Component, String>(2);
    private final Map<String, Component> CARD_OF_NAME = new HashMap<String, Component>(2);

    public AppWindowPersistence() {
        this.init();
        this.listen();
    }

    private void init() {
        this.NAME_OF_CARD.put(this.cardSelKeywordsList, "flatKeywords");
        this.NAME_OF_CARD.put(this.cardSelKeywordsTree, "keywordsTree");
        for (Component c : this.NAME_OF_CARD.keySet()) {
            this.CARD_OF_NAME.put(this.NAME_OF_CARD.get(c), c);
        }
    }

    private void listen() {
        AnnotationProcessor.process(this);
        this.cardSelKeywordsList.addComponentListener(this);
        this.cardSelKeywordsTree.addComponentListener(this);
    }

    @Override
    public void componentShown(ComponentEvent evt) {
        Component c = evt.getComponent();
        boolean isSelKeywordsCard = this.isSelKeywordsCard(c);
        boolean knownCardName = this.NAME_OF_CARD.containsKey(c);
        if (isSelKeywordsCard && knownCardName) {
            Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
            prefs.setString(KEY_KEYWORDS_VIEW, this.NAME_OF_CARD.get(c));
        }
    }

    private boolean isSelKeywordsCard(Component c) {
        return c == this.cardSelKeywordsList || c == this.cardSelKeywordsTree;
    }

    public void readAppFrameFromProperties() {
        final AppFrame appFrame = GUI.getAppFrame();
        final Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        final String key = appFrame.getClass().getName();
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (prefs.containsLocationKey(key) && prefs.containsSizeKey(key)) {
                    prefs.applySize(key, appFrame);
                    prefs.applyLocation(key, appFrame);
                } else {
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    double width = (double)screenSize.width * 0.8;
                    double height = (double)screenSize.height * 0.8;
                    appFrame.setSize((int)width, (int)height);
                    appFrame.setLocationRelativeTo(null);
                    GUI.getAppPanel().getSplitPaneMain().setDividerLocation((int)(width * 0.2));
                    GUI.getAppPanel().getSplitPaneThumbnailsMetadata().setDividerLocation((int)(width * 0.6));
                }
            }
        });
    }

    public void readAppPanelFromProperties() {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                AppPanel appPanel = GUI.getAppPanel();
                Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
                prefs.applyComponentSettings(appPanel, AppWindowPersistence.getAppPanelSettingsHints());
                AppWindowPersistence.this.setInitKeywordsView(appPanel);
            }
        });
    }

    private static PreferencesHints getAppPanelSettingsHints() {
        PreferencesHints hints = new PreferencesHints();
        hints.addKeyToExclude(APP_PANEL_LIST_IMAGE_COLLECTIONS);
        hints.addKeyToExclude(APP_PANEL_LIST_NO_METADATA);
        hints.addKeyToExclude(APP_PANEL_LIST_SAVED_SEARCHES);
        hints.addKeyToExclude(APP_PANEL_LIST_SEL_KEYWORDS);
        hints.addKeyToExclude(APP_PANEL_TREE_DIRECTORIES);
        hints.addKeyToExclude(APP_PANEL_TREE_EDIT_KEYWORDS);
        hints.addKeyToExclude(APP_PANEL_TREE_FAVORITES);
        hints.addKeyToExclude(APP_PANEL_TREE_MISC_METADATA);
        hints.addKeyToExclude(APP_PANEL_TREE_SEL_KEYWORDS);
        hints.addKeyToExclude(APP_PANEL_TREE_TIMELINE);
        return hints;
    }

    private void setInitKeywordsView(AppPanel appPanel) {
        Component c;
        String s;
        KeywordsPanel panelEditKeywords = appPanel.getPanelEditKeywords();
        panelEditKeywords.setKeyCard("AppPanel.Keywords.Card");
        panelEditKeywords.setKeyTree(APP_PANEL_TREE_EDIT_KEYWORDS);
        panelEditKeywords.readProperties();
        String name = "keywordsTree";
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        if (prefs.containsKey(KEY_KEYWORDS_VIEW) && ((s = prefs.getString(KEY_KEYWORDS_VIEW)).equals("flatKeywords") || s.equals("keywordsTree"))) {
            name = s;
        }
        if ((c = this.CARD_OF_NAME.get(name)) == this.cardSelKeywordsList) {
            appPanel.displaySelKeywordsList(AppPanel.SelectAlso.NOTHING_ELSE);
        } else if (c == this.cardSelKeywordsTree) {
            appPanel.displaySelKeywordsTree(AppPanel.SelectAlso.NOTHING_ELSE);
        } else assert (false);
    }

    @EventSubscriber(eventClass=AppWillExitEvent.class)
    public void appWillExit(AppWillExitEvent evt) {
        this.writeAppProperties();
    }

    private void writeAppProperties() {
        AppPanel appPanel = GUI.getAppPanel();
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setComponent(appPanel, AppWindowPersistence.getAppPanelSettingsHints());
        prefs.setInt(KEY_DIVIDER_LOCATION_MAIN, appPanel.getSplitPaneMain().getDividerLocation());
        prefs.setInt(KEY_DIVIDER_LOCATION_THUMBNAILS, appPanel.getSplitPaneThumbnailsMetadata().getDividerLocation());
        appPanel.getPanelEditKeywords().writeProperties();
        this.writeTreeProperties(appPanel);
        this.writeListProperties(appPanel);
    }

    public static void readTreeSelKeywords() {
        AppWindowPersistence.read(GUI.getSelKeywordsTree(), APP_PANEL_TREE_SEL_KEYWORDS);
    }

    public static void readTreeEditKeywords() {
        AppWindowPersistence.read(GUI.getEditKeywordsTree(), APP_PANEL_TREE_EDIT_KEYWORDS);
    }

    public static void readTreeMiscMetadata() {
        AppWindowPersistence.read(GUI.getMiscMetadataTree(), APP_PANEL_TREE_MISC_METADATA);
    }

    public static void readTreeTimeline() {
        AppWindowPersistence.read(GUI.getTimelineTree(), APP_PANEL_TREE_TIMELINE);
    }

    public static void readTreeDirectories() {
        AppWindowPersistence.read(GUI.getDirectoriesTree(), APP_PANEL_TREE_DIRECTORIES);
    }

    public static void readListSavedSearches() {
        AppWindowPersistence.read(GUI.getSavedSearchesList(), APP_PANEL_LIST_SAVED_SEARCHES);
    }

    public static void readListImageCollections() {
        AppWindowPersistence.read(GUI.getImageCollectionsList(), APP_PANEL_LIST_IMAGE_COLLECTIONS);
    }

    public static void readListSelKeywords() {
        AppWindowPersistence.read(GUI.getSelKeywordsList(), APP_PANEL_LIST_SEL_KEYWORDS);
    }

    private static void read(JTree tree, String key) {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.applyTreeSettings(key, tree);
    }

    private static void read(JList<?> list, String key) {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.applySelectedIndices(key, list);
    }

    private void writeTreeProperties(AppPanel appPanel) {
        this.write(appPanel.getTreeSelKeywords(), APP_PANEL_TREE_SEL_KEYWORDS);
        this.write(appPanel.getTreeEditKeywords(), APP_PANEL_TREE_EDIT_KEYWORDS);
        this.write(appPanel.getTreeMiscMetadata(), APP_PANEL_TREE_MISC_METADATA);
        this.write(appPanel.getTreeTimeline(), APP_PANEL_TREE_TIMELINE);
        this.write(appPanel.getTreeDirectories(), APP_PANEL_TREE_DIRECTORIES);
        this.write(appPanel.getTreeFavorites(), APP_PANEL_TREE_FAVORITES);
    }

    private void writeListProperties(AppPanel appPanel) {
        this.write(appPanel.getListSavedSearches(), APP_PANEL_LIST_SAVED_SEARCHES);
        this.write(appPanel.getListImageCollections(), APP_PANEL_LIST_IMAGE_COLLECTIONS);
        this.write(appPanel.getListSelKeywords(), APP_PANEL_LIST_SEL_KEYWORDS);
    }

    private void write(JTree tree, String key) {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setTree(key, tree);
    }

    private void write(JList<?> list, String key) {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setSelectedIndices(key, list);
    }

    @Override
    public void componentResized(ComponentEvent evt) {
    }

    @Override
    public void componentMoved(ComponentEvent evt) {
    }

    @Override
    public void componentHidden(ComponentEvent evt) {
    }
}

