/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.app.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DropMode;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.bushe.swing.event.EventBus;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.JXTree;
import org.jphototagger.api.messages.MessageType;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.windows.MainWindowComponent;
import org.jphototagger.api.windows.MainWindowComponentProvider;
import org.jphototagger.api.windows.StatusLineElementProvider;
import org.jphototagger.api.windows.TabInEditWindowDisplayedEvent;
import org.jphototagger.api.windows.TabInSelectionWindowDisplayedEvent;
import org.jphototagger.domain.metadata.search.SearchComponent;
import org.jphototagger.domain.thumbnails.MainWindowThumbnailsComponent;
import org.jphototagger.lib.api.LayerUtil;
import org.jphototagger.lib.api.PositionProviderAscendingComparator;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.AllSystemDirectoriesTreeCellRenderer;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.lib.swing.MessageLabel;
import org.jphototagger.lib.swing.TreeExpandCollapseAllAction;
import org.jphototagger.lib.swing.WaitListModel;
import org.jphototagger.lib.swing.WaitTreeModel;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.swingx.ListTextFilter;
import org.jphototagger.lib.swingx.SearchInJxListAction;
import org.jphototagger.lib.swingx.SearchInJxTreeAction;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.app.ui.AppLookAndFeel;
import org.jphototagger.program.module.directories.DirectoryTreeTransferHandler;
import org.jphototagger.program.module.favorites.FavoritesTreeCellRenderer;
import org.jphototagger.program.module.imagecollections.ImageCollectionsListCellRenderer;
import org.jphototagger.program.module.imagecollections.ImageCollectionsListTransferHandler;
import org.jphototagger.program.module.keywords.KeywordsPanel;
import org.jphototagger.program.module.keywords.list.KeywordsListCellRenderer;
import org.jphototagger.program.module.keywords.list.KeywordsListTransferHandler;
import org.jphototagger.program.module.keywords.tree.KeywordsTreeCellRenderer;
import org.jphototagger.program.module.keywords.tree.KeywordsTreeTransferHandler;
import org.jphototagger.program.module.miscmetadata.MiscMetadataTreeCellRenderer;
import org.jphototagger.program.module.miscmetadata.MiscMetadataTreeTransferHandler;
import org.jphototagger.program.module.search.SavedSearchesListCellRenderer;
import org.jphototagger.program.module.timeline.TimelineTreeCellRenderer;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class AppPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String KEY_DIVIDER_LOCATION_MAIN = "AppPanel.DividerLocationMain";
    private static final String KEY_DIVIDER_LOCATION_THUMBNAILS = "AppPanel.DividerLocationThumbnails";
    private static final int DEFAULT_DIVIDER_LOCATION_MAIN = 100;
    private static final int DEFAULT_DIVIDER_LOCATION_THUMBNAILS = 200;
    private transient MessageLabel messageLabel;
    private final List<JTree> selectionTrees = new ArrayList<JTree>();
    private final List<JXList> selectionLists = new ArrayList<JXList>();
    private ListTextFilter listSelKeywordsTextFilter;
    private ListTextFilter listImageCollectionsTextFilter;
    private ListTextFilter listSavedSearchesTextFilter;
    private static final Logger LOGGER = Logger.getLogger(AppPanel.class.getName());
    private final ChangeListener tabbedPaneEditChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            Component selectedComponent = AppPanel.this.tabbedPaneMetadata.getSelectedComponent();
            EventBus.publish(new TabInEditWindowDisplayedEvent(AppPanel.this.tabbedPaneMetadata, selectedComponent));
        }
    };
    private final ChangeListener tabbedPaneSelectionChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            Component selectedComponent = AppPanel.this.tabbedPaneSelection.getSelectedComponent();
            EventBus.publish(new TabInSelectionWindowDisplayedEvent(AppPanel.this.tabbedPaneSelection, selectedComponent));
        }
    };
    private JButton buttonDisplaySelKeywordsList;
    private JButton buttonDisplaySelKeywordsTree;
    private ButtonGroup buttonGroupKeywordsMultipleSel;
    private JButton buttonSearchInDirectories;
    private JButton buttonSearchInImageCollections;
    private JButton buttonSearchInListSelKeywords;
    private JButton buttonSearchInSavedSearches;
    private JButton buttonSearchInTreeFavorites;
    private JButton buttonSearchInTreeMiscMetadata;
    private JButton buttonSearchInTreeSelKeywords;
    private JButton buttonSearchInTreeTimeline;
    private JCheckBox checkBoxDirectoriesRecursive;
    private JCheckBox checkBoxFavoritesRecursive;
    private JLabel labelListImageCollectionsFilter;
    private JLabel labelListSavedSearchesFilter;
    private JLabel labelListSelKeywordsFilter;
    private JLabel labelStatusbarText;
    private JXList listImageCollections;
    private JXList listSavedSearches;
    private JXList listSelKeywords;
    private JPanel panelDirectories;
    private KeywordsPanel panelEditKeywords;
    private JPanel panelFavorites;
    private JPanel panelImageCollections;
    private JPanel panelListImageCollectionsFilter;
    private JPanel panelListSavedSearchesFilter;
    private JPanel panelListSelKeywordsFilter;
    private JPanel panelMetadata;
    private JPanel panelMiscMetadata;
    private JPanel panelSavedSearches;
    private JPanel panelSearch;
    private JPanel panelSelKeywords;
    private JPanel panelSelKeywordsList;
    private JPanel panelSelKeywordsListMultipleSelection;
    private JPanel panelSelKeywordsTree;
    private JPanel panelSelection;
    private JPanel panelStatusbar;
    private JPanel panelThumbnailsMetadata;
    private JPanel panelTimeline;
    private JRadioButton radioButtonSelKeywordsMultipleSelAll;
    private JRadioButton radioButtonSelKeywordsMultipleSelOne;
    private JScrollPane scrollPaneDirectories;
    private JScrollPane scrollPaneFavorites;
    private JScrollPane scrollPaneImageCollections;
    private JScrollPane scrollPaneMiscMetadata;
    private JScrollPane scrollPaneSavedSearches;
    private JScrollPane scrollPaneSelKeywordsList;
    private JScrollPane scrollPaneSelKeywordsTree;
    private JScrollPane scrollPaneTimeline;
    private JSplitPane splitPaneMain;
    private JSplitPane splitPaneThumbnailsMetadata;
    private JPanel statusLineElementsPanel;
    private JTabbedPane tabbedPaneMetadata;
    private JTabbedPane tabbedPaneSelection;
    private JTextField textFieldListImageCollectionsFilter;
    private JTextField textFieldListSavedSearchesFilter;
    private JTextField textFieldListSelKeywordsFilter;
    private JPanel thumbnailPanelComponent;
    private JToggleButton toggleButtonExpandAllNodesSelKeywords;
    private JToggleButton toggleButtonExpandCollapseTreeMiscMetadata;
    private JToggleButton toggleButtonExpandCollapseTreeTimeline;
    private JTree treeDirectories;
    private JTree treeFavorites;
    private JTree treeMiscMetadata;
    private JTree treeSelKeywords;
    private JTree treeTimeline;

    public AppPanel() {
        this.init();
    }

    private void init() {
        this.initComponents();
        this.messageLabel = new MessageLabel(this.labelStatusbarText);
        this.setTreesSingleSelection();
        this.initCollections();
        this.initListTextFilters();
        this.setMnemonics();
        GUI.setAppPanel(this);
        this.lookupWindows();
        this.lookupStatusLineElements();
        this.tabbedPaneMetadata.addChangeListener(this.tabbedPaneEditChangeListener);
        this.tabbedPaneSelection.addChangeListener(this.tabbedPaneSelectionChangeListener);
    }

    private void setMnemonics() {
        MnemonicUtil.setMnemonics(this.panelSearch);
    }

    private void initListTextFilters() {
        this.listSelKeywordsTextFilter = new ListTextFilter(this.listSelKeywords);
        this.listImageCollectionsTextFilter = new ListTextFilter(this.listImageCollections);
        this.listSavedSearchesTextFilter = new ListTextFilter(this.listSavedSearches);
        this.listSelKeywordsTextFilter.filterOnDocumentChanges(this.textFieldListSelKeywordsFilter.getDocument());
        this.listSavedSearchesTextFilter.filterOnDocumentChanges(this.textFieldListSavedSearchesFilter.getDocument());
        this.listImageCollectionsTextFilter.filterOnDocumentChanges(this.textFieldListImageCollectionsFilter.getDocument());
    }

    private void initCollections() {
        this.initSelectionTreesCollection();
        this.initSelectionListsCollection();
    }

    private void initSelectionTreesCollection() {
        this.selectionTrees.add(this.treeDirectories);
        this.selectionTrees.add(this.treeFavorites);
        this.selectionTrees.add(this.treeMiscMetadata);
        this.selectionTrees.add(this.treeTimeline);
        this.selectionTrees.add(this.treeSelKeywords);
    }

    private void initSelectionListsCollection() {
        this.selectionLists.add(this.listImageCollections);
        this.selectionLists.add(this.listSelKeywords);
        this.selectionLists.add(this.listSavedSearches);
    }

    private int getDividerLocationMain() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        int location = prefs.getInt(KEY_DIVIDER_LOCATION_MAIN);
        return location >= 0 ? location : 100;
    }

    private void setTreesSingleSelection() {
        this.setSingleSelection(this.treeDirectories);
        this.setSingleSelection(this.treeFavorites);
        this.setSingleSelection(this.treeMiscMetadata);
        this.setSingleSelection(this.treeTimeline);
        this.setSingleSelection(this.treeSelKeywords);
    }

    private void setSingleSelection(JTree tree) {
        tree.getSelectionModel().setSelectionMode(1);
    }

    public void displaySelKeywordsTree(SelectAlso select) {
        if (select == null) {
            throw new NullPointerException("select == null");
        }
        if (select.equals((Object)SelectAlso.SEL_KEYWORDS_TAB)) {
            this.tabbedPaneSelection.setSelectedComponent(this.panelSelKeywords);
        }
        this.displaySelKeywordsCard("keywordsTree");
    }

    public void displaySelKeywordsList(SelectAlso select) {
        if (select == null) {
            throw new NullPointerException("select == null");
        }
        if (select.equals((Object)SelectAlso.SEL_KEYWORDS_TAB)) {
            this.tabbedPaneSelection.setSelectedComponent(this.panelSelKeywords);
        }
        this.displaySelKeywordsCard("flatKeywords");
    }

    private void displaySelKeywordsCard(String name) {
        CardLayout cl = (CardLayout)this.panelSelKeywords.getLayout();
        cl.show(this.panelSelKeywords, name);
    }

    private int getDividerLocationThumbnails() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        int location = prefs.getInt(KEY_DIVIDER_LOCATION_THUMBNAILS);
        return location >= 0 ? location : 200;
    }

    void setStatusbarText(String text, MessageType type, long milliseconds) {
        if (milliseconds > 0L) {
            this.messageLabel.showMessage(text, type, milliseconds);
        } else {
            this.labelStatusbarText.setText(text);
        }
        LOGGER.log(Level.FINE, text);
    }

    public JTabbedPane getTabbedPaneMetadata() {
        return this.tabbedPaneMetadata;
    }

    public boolean isSelectionComponentSelected(Component component) {
        Component selectedComponent = this.tabbedPaneSelection.getSelectedComponent();
        return component == selectedComponent;
    }

    public boolean isEditComponentSelected(Component component) {
        Component selectedComponent = this.tabbedPaneMetadata.getSelectedComponent();
        return component == selectedComponent;
    }

    public JTabbedPane getTabbedPaneSelection() {
        return this.tabbedPaneSelection;
    }

    public Component getTabEditKeywords() {
        return this.panelEditKeywords;
    }

    public Component getTabSelectionKeywords() {
        return this.panelSelKeywords;
    }

    public Component getCardSelKeywordsList() {
        return this.panelSelKeywordsList;
    }

    public Component getCardSelKeywordsTree() {
        return this.panelSelKeywordsTree;
    }

    public Component getTabSelectionDirectories() {
        return this.panelDirectories;
    }

    public Component getTabSelectionFavoriteDirectories() {
        return this.panelFavorites;
    }

    public Component getTabSelectionImageCollections() {
        return this.panelImageCollections;
    }

    public Component getTabSelectionTimeline() {
        return this.panelTimeline;
    }

    public Component getTabSelectionMiscMetadata() {
        return this.panelMiscMetadata;
    }

    public JPanel getTabSelectionSavedSearches() {
        return this.panelSavedSearches;
    }

    public JTree getTreeTimeline() {
        return this.treeTimeline;
    }

    public JTree getTreeMiscMetadata() {
        return this.treeMiscMetadata;
    }

    public JTree getTreeEditKeywords() {
        return this.panelEditKeywords.getTree();
    }

    public JTree getTreeSelKeywords() {
        return this.treeSelKeywords;
    }

    public List<JTree> getSelectionTrees() {
        return Collections.unmodifiableList(this.selectionTrees);
    }

    public List<JXList> getSelectionLists() {
        return Collections.unmodifiableList(this.selectionLists);
    }

    public KeywordsPanel getPanelEditKeywords() {
        return this.panelEditKeywords;
    }

    public JXList getListImageCollections() {
        return this.listImageCollections;
    }

    public JXList getListSavedSearches() {
        return this.listSavedSearches;
    }

    public JTree getTreeDirectories() {
        return this.treeDirectories;
    }

    public JTree getTreeFavorites() {
        return this.treeFavorites;
    }

    public JXList getListSelKeywords() {
        return this.listSelKeywords;
    }

    public JXList getListEditKeywords() {
        return this.panelEditKeywords.getList();
    }

    public JToggleButton getToggleButtonSelKeywords() {
        return this.toggleButtonExpandAllNodesSelKeywords;
    }

    public JRadioButton getRadioButtonSelKeywordsMultipleSelAll() {
        return this.radioButtonSelKeywordsMultipleSelAll;
    }

    public JRadioButton getRadioButtonSelKeywordsMultipleSelOne() {
        return this.radioButtonSelKeywordsMultipleSelOne;
    }

    public JSplitPane getSplitPaneMain() {
        return this.splitPaneMain;
    }

    public JSplitPane getSplitPaneThumbnailsMetadata() {
        return this.splitPaneThumbnailsMetadata;
    }

    public JCheckBox getCheckBoxDirectoriesRecursive() {
        return this.checkBoxDirectoriesRecursive;
    }

    public JCheckBox getCheckBoxFavoritesRecursive() {
        return this.checkBoxFavoritesRecursive;
    }

    private void lookupWindows() {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                AppPanel.this.lookupSearchComponent();
                AppPanel.this.lookupMainWindowThumbnailsComponent();
                Collection<MainWindowComponentProvider> providers = Lookup.getDefault().lookupAll(MainWindowComponentProvider.class);
                ArrayList<? extends MainWindowComponent> selectionsComponents = new ArrayList<MainWindowComponent>();
                ArrayList<? extends MainWindowComponent> editComponents = new ArrayList<MainWindowComponent>();
                for (MainWindowComponentProvider provider : providers) {
                    editComponents.addAll(provider.getMainWindowEditComponents());
                    selectionsComponents.addAll(provider.getMainWindowSelectionComponents());
                }
                AppPanel.this.instertIntoEditTabbedPane(editComponents);
                AppPanel.this.insertIntoSelectionTabbedPane(selectionsComponents);
            }
        });
    }

    private void lookupSearchComponent() {
        SearchComponent searchComponent = Lookup.getDefault().lookup(SearchComponent.class);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.panelSearch.add(searchComponent.getSearchComponent(), gbc);
        GUI.getAppFrame().addGotoMenuItem(searchComponent.getSelectSearchComponentAction(), 0, false);
    }

    private void lookupMainWindowThumbnailsComponent() {
        MainWindowThumbnailsComponent tComponent = Lookup.getDefault().lookup(MainWindowThumbnailsComponent.class);
        Component component = tComponent.getThumbnailsComponent();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.thumbnailPanelComponent.add(component, gbc);
        SelectThumbnailsPanelAction selectThumbnailsPanelAction = new SelectThumbnailsPanelAction(tComponent.getThumbnailsDisplayingComponent());
        GUI.getAppFrame().addGotoMenuItem(selectThumbnailsPanelAction, 2, false);
    }

    private void instertIntoEditTabbedPane(List<MainWindowComponent> mainWindowComponents) {
        Collections.sort(mainWindowComponents, PositionProviderAscendingComparator.INSTANCE);
        LayerUtil.logWarningIfNotUniquePositions(mainWindowComponents);
        for (MainWindowComponent component : mainWindowComponents) {
            this.dockIntoTabbedPane(component, this.tabbedPaneMetadata);
            SelectTabAction selectTabAction = this.createSelectTabAction(component, this.tabbedPaneMetadata);
            GUI.getAppFrame().addGotoMenuItemForEditWindow(selectTabAction);
        }
    }

    private void insertIntoSelectionTabbedPane(List<MainWindowComponent> mainWindowComponents) {
        Collections.sort(mainWindowComponents, PositionProviderAscendingComparator.INSTANCE);
        LayerUtil.logWarningIfNotUniquePositions(mainWindowComponents);
        for (MainWindowComponent component : mainWindowComponents) {
            this.dockIntoTabbedPane(component, this.tabbedPaneSelection);
            SelectTabAction selectTabAction = this.createSelectTabAction(component, this.tabbedPaneSelection);
            GUI.getAppFrame().addGotoMenuItemForSelectionWindow(selectTabAction);
        }
    }

    private SelectTabAction createSelectTabAction(MainWindowComponent mainWindowComponent, JTabbedPane tabbedPane) {
        SelectTabAction action = new SelectTabAction(tabbedPane, mainWindowComponent.getComponent());
        action.putValue("Name", mainWindowComponent.getTitle());
        action.putValue("SmallIcon", mainWindowComponent.getSmallIcon());
        KeyStroke keyStroke = mainWindowComponent.getOptionalSelectionAccelaratorKey();
        if (keyStroke != null) {
            action.putValue("AcceleratorKey", keyStroke);
        }
        return action;
    }

    private void dockIntoTabbedPane(final MainWindowComponent appWindow, final JTabbedPane tabbedPane) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                int tabCount = tabbedPane.getTabCount();
                int appWindowPosition = appWindow.getPosition();
                int tabIndex = appWindowPosition < 0 || appWindowPosition > tabCount ? tabCount : appWindowPosition;
                Component component = appWindow.getComponent();
                Icon icon = appWindow.getSmallIcon();
                String tip = appWindow.getTooltipText();
                String title = appWindow.getTitle();
                tabbedPane.insertTab(title, icon, component, tip, tabIndex);
            }
        });
    }

    private void lookupStatusLineElements() {
        ArrayList<StatusLineElementProvider> providers = new ArrayList<StatusLineElementProvider>(Lookup.getDefault().lookupAll(StatusLineElementProvider.class));
        Collections.sort(providers, PositionProviderAscendingComparator.INSTANCE);
        boolean isFirst = true;
        for (StatusLineElementProvider provider : providers) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(0, isFirst ? 0 : 10, 0, 0);
            isFirst = false;
            this.statusLineElementsPanel.add(provider.getStatusLineElement(), gbc);
        }
    }

    private void initComponents() {
        this.buttonGroupKeywordsMultipleSel = new ButtonGroup();
        this.splitPaneMain = new JSplitPane();
        this.splitPaneMain.setDividerLocation(this.getDividerLocationMain());
        this.panelSelection = new JPanel();
        this.panelSearch = new JPanel();
        this.tabbedPaneSelection = new JTabbedPane();
        this.panelDirectories = new JPanel();
        this.scrollPaneDirectories = new JScrollPane();
        this.treeDirectories = new JXTree();
        this.treeDirectories.setShowsRootHandles(true);
        this.buttonSearchInDirectories = new JButton();
        this.checkBoxDirectoriesRecursive = new JCheckBox();
        this.panelSavedSearches = new JPanel();
        this.panelListSavedSearchesFilter = new JPanel();
        this.labelListSavedSearchesFilter = new JLabel();
        this.textFieldListSavedSearchesFilter = new JTextField();
        this.scrollPaneSavedSearches = new JScrollPane();
        this.listSavedSearches = new JXList();
        this.buttonSearchInSavedSearches = new JButton();
        this.panelImageCollections = new JPanel();
        this.panelListImageCollectionsFilter = new JPanel();
        this.labelListImageCollectionsFilter = new JLabel();
        this.textFieldListImageCollectionsFilter = new JTextField();
        this.scrollPaneImageCollections = new JScrollPane();
        this.listImageCollections = new JXList();
        this.buttonSearchInImageCollections = new JButton();
        this.panelFavorites = new JPanel();
        this.scrollPaneFavorites = new JScrollPane();
        this.treeFavorites = new JXTree();
        this.treeFavorites.setTransferHandler(new DirectoryTreeTransferHandler());
        this.treeFavorites.setShowsRootHandles(true);
        this.buttonSearchInTreeFavorites = new JButton();
        this.checkBoxFavoritesRecursive = new JCheckBox();
        this.panelSelKeywords = new JPanel();
        this.panelSelKeywordsTree = new JPanel();
        this.scrollPaneSelKeywordsTree = new JScrollPane();
        this.treeSelKeywords = new JXTree();
        this.treeSelKeywords.setTransferHandler(new KeywordsTreeTransferHandler());
        this.treeSelKeywords.setShowsRootHandles(true);
        this.buttonDisplaySelKeywordsList = new JButton();
        this.toggleButtonExpandAllNodesSelKeywords = new JToggleButton();
        this.buttonSearchInTreeSelKeywords = new JButton();
        this.panelSelKeywordsList = new JPanel();
        this.panelListSelKeywordsFilter = new JPanel();
        this.labelListSelKeywordsFilter = new JLabel();
        this.textFieldListSelKeywordsFilter = new JTextField();
        this.scrollPaneSelKeywordsList = new JScrollPane();
        this.listSelKeywords = new JXList();
        this.listSelKeywords.setTransferHandler(new KeywordsListTransferHandler());
        this.panelSelKeywordsListMultipleSelection = new JPanel();
        this.radioButtonSelKeywordsMultipleSelAll = new JRadioButton();
        this.radioButtonSelKeywordsMultipleSelOne = new JRadioButton();
        this.buttonDisplaySelKeywordsTree = new JButton();
        this.buttonSearchInListSelKeywords = new JButton();
        this.panelTimeline = new JPanel();
        this.scrollPaneTimeline = new JScrollPane();
        this.treeTimeline = new JXTree();
        this.treeTimeline.setShowsRootHandles(true);
        this.toggleButtonExpandCollapseTreeTimeline = new JToggleButton();
        this.buttonSearchInTreeTimeline = new JButton();
        this.panelMiscMetadata = new JPanel();
        this.scrollPaneMiscMetadata = new JScrollPane();
        this.treeMiscMetadata = new JXTree();
        this.treeMiscMetadata.setTransferHandler(new MiscMetadataTreeTransferHandler());
        this.treeMiscMetadata.setShowsRootHandles(true);
        this.toggleButtonExpandCollapseTreeMiscMetadata = new JToggleButton();
        this.buttonSearchInTreeMiscMetadata = new JButton();
        this.panelThumbnailsMetadata = new JPanel();
        this.splitPaneThumbnailsMetadata = new JSplitPane();
        this.splitPaneThumbnailsMetadata.setDividerLocation(this.getDividerLocationThumbnails());
        this.thumbnailPanelComponent = new JPanel();
        this.panelMetadata = new JPanel();
        this.tabbedPaneMetadata = new JTabbedPane();
        this.panelEditKeywords = new KeywordsPanel();
        this.panelStatusbar = new JPanel();
        this.labelStatusbarText = new JLabel();
        this.statusLineElementsPanel = new JPanel();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.splitPaneMain.setDividerSize(6);
        this.splitPaneMain.setName("splitPaneMain");
        this.splitPaneMain.setOneTouchExpandable(true);
        this.panelSelection.setName("panelSelection");
        this.panelSelection.setLayout(new GridBagLayout());
        this.panelSearch.setName("panelSearch");
        this.panelSearch.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelSelection.add((Component)this.panelSearch, gridBagConstraints);
        this.tabbedPaneSelection.setName("tabbedPaneSelection");
        this.panelDirectories.setName("panelDirectories");
        this.panelDirectories.setLayout(new GridBagLayout());
        this.scrollPaneDirectories.setName("scrollPaneDirectories");
        this.treeDirectories.setModel(WaitTreeModel.INSTANCE);
        this.treeDirectories.setCellRenderer(new AllSystemDirectoriesTreeCellRenderer());
        this.treeDirectories.setDragEnabled(true);
        this.treeDirectories.setDropMode(DropMode.ON);
        this.treeDirectories.setName("treeDirectories");
        this.treeDirectories.setRootVisible(false);
        this.scrollPaneDirectories.setViewportView(this.treeDirectories);
        this.treeDirectories.setTransferHandler(new DirectoryTreeTransferHandler());
        this.treeDirectories.setShowsRootHandles(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelDirectories.add((Component)this.scrollPaneDirectories, gridBagConstraints);
        this.buttonSearchInDirectories.setAction(new SearchInJxTreeAction((JXTree)this.treeDirectories));
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/app/ui/Bundle");
        this.buttonSearchInDirectories.setText(bundle.getString("AppPanel.buttonSearchInDirectories.text"));
        this.buttonSearchInDirectories.setMargin(new Insets(1, 1, 1, 1));
        this.buttonSearchInDirectories.setName("buttonSearchInDirectories");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 0);
        this.panelDirectories.add((Component)this.buttonSearchInDirectories, gridBagConstraints);
        this.checkBoxDirectoriesRecursive.setText(bundle.getString("AppPanel.checkBoxDirectoriesRecursive.text"));
        this.checkBoxDirectoriesRecursive.setName("checkBoxDirectoriesRecursive");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 0);
        this.panelDirectories.add((Component)this.checkBoxDirectoriesRecursive, gridBagConstraints);
        this.tabbedPaneSelection.addTab(bundle.getString("AppPanel.panelDirectories.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_folder.png")), this.panelDirectories);
        this.panelSavedSearches.setName("panelSavedSearches");
        this.panelSavedSearches.setLayout(new GridBagLayout());
        this.panelListSavedSearchesFilter.setName("panelListSavedSearchesFilter");
        this.panelListSavedSearchesFilter.setLayout(new GridBagLayout());
        this.labelListSavedSearchesFilter.setLabelFor(this.textFieldListSavedSearchesFilter);
        this.labelListSavedSearchesFilter.setText(bundle.getString("AppPanel.labelListSavedSearchesFilter.text"));
        this.labelListSavedSearchesFilter.setName("labelListSavedSearchesFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelListSavedSearchesFilter.add((Component)this.labelListSavedSearchesFilter, gridBagConstraints);
        this.textFieldListSavedSearchesFilter.setName("textFieldListSavedSearchesFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelListSavedSearchesFilter.add((Component)this.textFieldListSavedSearchesFilter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelSavedSearches.add((Component)this.panelListSavedSearchesFilter, gridBagConstraints);
        this.scrollPaneSavedSearches.setName("scrollPaneSavedSearches");
        this.listSavedSearches.setModel((ListModel)WaitListModel.INSTANCE);
        this.listSavedSearches.setSelectionMode(0);
        this.listSavedSearches.setCellRenderer((ListCellRenderer)new SavedSearchesListCellRenderer());
        this.listSavedSearches.setName("listSavedSearches");
        this.scrollPaneSavedSearches.setViewportView(this.listSavedSearches);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelSavedSearches.add((Component)this.scrollPaneSavedSearches, gridBagConstraints);
        this.buttonSearchInSavedSearches.setAction(new SearchInJxListAction(this.listSavedSearches));
        this.buttonSearchInSavedSearches.setText(bundle.getString("AppPanel.buttonSearchInSavedSearches.text"));
        this.buttonSearchInSavedSearches.setMargin(new Insets(1, 1, 1, 1));
        this.buttonSearchInSavedSearches.setName("buttonSearchInSavedSearches");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 0);
        this.panelSavedSearches.add((Component)this.buttonSearchInSavedSearches, gridBagConstraints);
        this.tabbedPaneSelection.addTab(bundle.getString("AppPanel.panelSavedSearches.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_search.png")), this.panelSavedSearches);
        this.panelImageCollections.setName("panelImageCollections");
        this.panelImageCollections.setLayout(new GridBagLayout());
        this.panelListImageCollectionsFilter.setName("panelListImageCollectionsFilter");
        this.panelListImageCollectionsFilter.setLayout(new GridBagLayout());
        this.labelListImageCollectionsFilter.setLabelFor(this.textFieldListImageCollectionsFilter);
        this.labelListImageCollectionsFilter.setText(bundle.getString("AppPanel.labelListImageCollectionsFilter.text"));
        this.labelListImageCollectionsFilter.setName("labelListImageCollectionsFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelListImageCollectionsFilter.add((Component)this.labelListImageCollectionsFilter, gridBagConstraints);
        this.textFieldListImageCollectionsFilter.setName("textFieldListImageCollectionsFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelListImageCollectionsFilter.add((Component)this.textFieldListImageCollectionsFilter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelImageCollections.add((Component)this.panelListImageCollectionsFilter, gridBagConstraints);
        this.scrollPaneImageCollections.setName("scrollPaneImageCollections");
        this.listImageCollections.setModel((ListModel)WaitListModel.INSTANCE);
        this.listImageCollections.setSelectionMode(0);
        this.listImageCollections.setCellRenderer((ListCellRenderer)new ImageCollectionsListCellRenderer());
        this.listImageCollections.setDragEnabled(true);
        this.listImageCollections.setName("listImageCollections");
        this.scrollPaneImageCollections.setViewportView(this.listImageCollections);
        this.listImageCollections.setTransferHandler(new ImageCollectionsListTransferHandler());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelImageCollections.add((Component)this.scrollPaneImageCollections, gridBagConstraints);
        this.buttonSearchInImageCollections.setAction(new SearchInJxListAction(this.listImageCollections));
        this.buttonSearchInImageCollections.setText(bundle.getString("AppPanel.buttonSearchInImageCollections.text"));
        this.buttonSearchInImageCollections.setMargin(new Insets(1, 1, 1, 1));
        this.buttonSearchInImageCollections.setName("buttonSearchInImageCollections");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 0);
        this.panelImageCollections.add((Component)this.buttonSearchInImageCollections, gridBagConstraints);
        this.tabbedPaneSelection.addTab(bundle.getString("AppPanel.panelImageCollections.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_imagecollection.png")), this.panelImageCollections);
        this.panelFavorites.setName("panelFavorites");
        this.panelFavorites.setLayout(new GridBagLayout());
        this.scrollPaneFavorites.setName("scrollPaneFavorites");
        this.treeFavorites.setModel(WaitTreeModel.INSTANCE);
        this.treeFavorites.setCellRenderer(new FavoritesTreeCellRenderer());
        this.treeFavorites.setDragEnabled(true);
        this.treeFavorites.setDropMode(DropMode.ON);
        this.treeFavorites.setName("treeFavorites");
        this.treeFavorites.setRootVisible(false);
        this.scrollPaneFavorites.setViewportView(this.treeFavorites);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelFavorites.add((Component)this.scrollPaneFavorites, gridBagConstraints);
        this.buttonSearchInTreeFavorites.setAction(new SearchInJxTreeAction((JXTree)this.treeFavorites));
        this.buttonSearchInTreeFavorites.setText(bundle.getString("AppPanel.buttonSearchInTreeFavorites.text"));
        this.buttonSearchInTreeFavorites.setMargin(new Insets(1, 1, 1, 1));
        this.buttonSearchInTreeFavorites.setName("buttonSearchInTreeFavorites");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 0);
        this.panelFavorites.add((Component)this.buttonSearchInTreeFavorites, gridBagConstraints);
        this.checkBoxFavoritesRecursive.setText(bundle.getString("AppPanel.checkBoxFavoritesRecursive.text"));
        this.checkBoxFavoritesRecursive.setName("checkBoxFavoritesRecursive");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 0);
        this.panelFavorites.add((Component)this.checkBoxFavoritesRecursive, gridBagConstraints);
        this.tabbedPaneSelection.addTab(bundle.getString("AppPanel.panelFavorites.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_favorite.png")), this.panelFavorites);
        this.panelSelKeywords.setName("panelSelKeywords");
        this.panelSelKeywords.setLayout(new CardLayout());
        this.panelSelKeywordsTree.setName("panelSelKeywordsTree");
        this.panelSelKeywordsTree.setLayout(new GridBagLayout());
        this.scrollPaneSelKeywordsTree.setName("scrollPaneSelKeywordsTree");
        this.treeSelKeywords.setModel(WaitTreeModel.INSTANCE);
        this.treeSelKeywords.setCellRenderer(new KeywordsTreeCellRenderer());
        this.treeSelKeywords.setName("treeSelKeywords");
        this.treeSelKeywords.setRootVisible(false);
        this.scrollPaneSelKeywordsTree.setViewportView(this.treeSelKeywords);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelSelKeywordsTree.add((Component)this.scrollPaneSelKeywordsTree, gridBagConstraints);
        this.buttonDisplaySelKeywordsList.setText(bundle.getString("AppPanel.buttonDisplaySelKeywordsList.text"));
        this.buttonDisplaySelKeywordsList.setMargin(new Insets(1, 1, 1, 1));
        this.buttonDisplaySelKeywordsList.setName("buttonDisplaySelKeywordsList");
        this.buttonDisplaySelKeywordsList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppPanel.this.buttonDisplaySelKeywordsListActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 1, 0);
        this.panelSelKeywordsTree.add((Component)this.buttonDisplaySelKeywordsList, gridBagConstraints);
        this.toggleButtonExpandAllNodesSelKeywords.setText(bundle.getString("AppPanel.toggleButtonExpandAllNodesSelKeywords.text"));
        this.toggleButtonExpandAllNodesSelKeywords.setMargin(new Insets(1, 1, 1, 1));
        this.toggleButtonExpandAllNodesSelKeywords.setName("toggleButtonExpandAllNodesSelKeywords");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 1, 0);
        this.panelSelKeywordsTree.add((Component)this.toggleButtonExpandAllNodesSelKeywords, gridBagConstraints);
        this.buttonSearchInTreeSelKeywords.setAction(new SearchInJxTreeAction((JXTree)this.treeSelKeywords));
        this.buttonSearchInTreeSelKeywords.setText(bundle.getString("AppPanel.buttonSearchInTreeSelKeywords.text"));
        this.buttonSearchInTreeSelKeywords.setMargin(new Insets(1, 1, 1, 1));
        this.buttonSearchInTreeSelKeywords.setName("buttonSearchInTreeSelKeywords");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 1, 0);
        this.panelSelKeywordsTree.add((Component)this.buttonSearchInTreeSelKeywords, gridBagConstraints);
        this.panelSelKeywords.add((Component)this.panelSelKeywordsTree, "keywordsTree");
        this.panelSelKeywordsList.setName("panelSelKeywordsList");
        this.panelSelKeywordsList.setLayout(new GridBagLayout());
        this.panelListSelKeywordsFilter.setName("panelListSelKeywordsFilter");
        this.panelListSelKeywordsFilter.setLayout(new GridBagLayout());
        this.labelListSelKeywordsFilter.setLabelFor(this.textFieldListSelKeywordsFilter);
        this.labelListSelKeywordsFilter.setText(bundle.getString("AppPanel.labelListSelKeywordsFilter.text"));
        this.labelListSelKeywordsFilter.setName("labelListSelKeywordsFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelListSelKeywordsFilter.add((Component)this.labelListSelKeywordsFilter, gridBagConstraints);
        this.textFieldListSelKeywordsFilter.setName("textFieldListSelKeywordsFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelListSelKeywordsFilter.add((Component)this.textFieldListSelKeywordsFilter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelSelKeywordsList.add((Component)this.panelListSelKeywordsFilter, gridBagConstraints);
        this.scrollPaneSelKeywordsList.setName("scrollPaneSelKeywordsList");
        this.listSelKeywords.setModel((ListModel)WaitListModel.INSTANCE);
        this.listSelKeywords.setCellRenderer((ListCellRenderer)new KeywordsListCellRenderer());
        this.listSelKeywords.setDragEnabled(true);
        this.listSelKeywords.setName("listSelKeywords");
        this.scrollPaneSelKeywordsList.setViewportView(this.listSelKeywords);
        this.listSelKeywords.setTransferHandler(new KeywordsListTransferHandler());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelSelKeywordsList.add((Component)this.scrollPaneSelKeywordsList, gridBagConstraints);
        this.panelSelKeywordsListMultipleSelection.setBorder(BorderFactory.createTitledBorder(bundle.getString("AppPanel.panelSelKeywordsListMultipleSelection.border.title")));
        this.panelSelKeywordsListMultipleSelection.setName("panelSelKeywordsListMultipleSelection");
        this.panelSelKeywordsListMultipleSelection.setLayout(new GridBagLayout());
        this.buttonGroupKeywordsMultipleSel.add(this.radioButtonSelKeywordsMultipleSelAll);
        this.radioButtonSelKeywordsMultipleSelAll.setText(bundle.getString("AppPanel.radioButtonSelKeywordsMultipleSelAll.text"));
        this.radioButtonSelKeywordsMultipleSelAll.setName("radioButtonSelKeywordsMultipleSelAll");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.panelSelKeywordsListMultipleSelection.add((Component)this.radioButtonSelKeywordsMultipleSelAll, gridBagConstraints);
        this.buttonGroupKeywordsMultipleSel.add(this.radioButtonSelKeywordsMultipleSelOne);
        this.radioButtonSelKeywordsMultipleSelOne.setText(bundle.getString("AppPanel.radioButtonSelKeywordsMultipleSelOne.text"));
        this.radioButtonSelKeywordsMultipleSelOne.setName("radioButtonSelKeywordsMultipleSelOne");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 2, 0);
        this.panelSelKeywordsListMultipleSelection.add((Component)this.radioButtonSelKeywordsMultipleSelOne, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.panelSelKeywordsList.add((Component)this.panelSelKeywordsListMultipleSelection, gridBagConstraints);
        this.buttonDisplaySelKeywordsTree.setText(bundle.getString("AppPanel.buttonDisplaySelKeywordsTree.text"));
        this.buttonDisplaySelKeywordsTree.setMargin(new Insets(1, 1, 1, 1));
        this.buttonDisplaySelKeywordsTree.setName("buttonDisplaySelKeywordsTree");
        this.buttonDisplaySelKeywordsTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppPanel.this.buttonDisplaySelKeywordsTreeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.panelSelKeywordsList.add((Component)this.buttonDisplaySelKeywordsTree, gridBagConstraints);
        this.buttonSearchInListSelKeywords.setAction(new SearchInJxListAction(this.listSelKeywords));
        this.buttonSearchInListSelKeywords.setText(bundle.getString("AppPanel.buttonSearchInListSelKeywords.text"));
        this.buttonSearchInListSelKeywords.setMargin(new Insets(1, 1, 1, 1));
        this.buttonSearchInListSelKeywords.setName("buttonSearchInListSelKeywords");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.panelSelKeywordsList.add((Component)this.buttonSearchInListSelKeywords, gridBagConstraints);
        this.panelSelKeywords.add((Component)this.panelSelKeywordsList, "flatKeywords");
        this.tabbedPaneSelection.addTab(bundle.getString("AppPanel.panelSelKeywords.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_keyword.png")), this.panelSelKeywords);
        this.panelTimeline.setName("panelTimeline");
        this.panelTimeline.setLayout(new GridBagLayout());
        this.scrollPaneTimeline.setName("scrollPaneTimeline");
        this.treeTimeline.setModel(WaitTreeModel.INSTANCE);
        this.treeTimeline.setCellRenderer(new TimelineTreeCellRenderer());
        this.treeTimeline.setName("treeTimeline");
        this.treeTimeline.setRootVisible(false);
        this.scrollPaneTimeline.setViewportView(this.treeTimeline);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelTimeline.add((Component)this.scrollPaneTimeline, gridBagConstraints);
        this.toggleButtonExpandCollapseTreeTimeline.setAction(new TreeExpandCollapseAllAction(this.toggleButtonExpandCollapseTreeTimeline, this.treeTimeline));
        this.toggleButtonExpandCollapseTreeTimeline.setText(TreeExpandCollapseAllAction.NOT_SELECTED_TEXT);
        this.toggleButtonExpandCollapseTreeTimeline.setMargin(new Insets(1, 1, 1, 1));
        this.toggleButtonExpandCollapseTreeTimeline.setName("toggleButtonExpandCollapseTreeTimeline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 1, 1, 0);
        this.panelTimeline.add((Component)this.toggleButtonExpandCollapseTreeTimeline, gridBagConstraints);
        this.buttonSearchInTreeTimeline.setAction(new SearchInJxTreeAction((JXTree)this.treeTimeline));
        this.buttonSearchInTreeTimeline.setText(bundle.getString("AppPanel.buttonSearchInTreeTimeline.text"));
        this.buttonSearchInTreeTimeline.setMargin(new Insets(1, 1, 1, 1));
        this.buttonSearchInTreeTimeline.setName("buttonSearchInTreeTimeline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 2, 1, 0);
        this.panelTimeline.add((Component)this.buttonSearchInTreeTimeline, gridBagConstraints);
        this.tabbedPaneSelection.addTab(bundle.getString("AppPanel.panelTimeline.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_timeline.png")), this.panelTimeline);
        this.panelMiscMetadata.setName("panelMiscMetadata");
        this.panelMiscMetadata.setLayout(new GridBagLayout());
        this.scrollPaneMiscMetadata.setName("scrollPaneMiscMetadata");
        this.treeMiscMetadata.setModel(WaitTreeModel.INSTANCE);
        this.treeMiscMetadata.setCellRenderer(new MiscMetadataTreeCellRenderer());
        this.treeMiscMetadata.setDragEnabled(true);
        this.treeMiscMetadata.setName("treeMiscMetadata");
        this.treeMiscMetadata.setRootVisible(false);
        this.scrollPaneMiscMetadata.setViewportView(this.treeMiscMetadata);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelMiscMetadata.add((Component)this.scrollPaneMiscMetadata, gridBagConstraints);
        this.toggleButtonExpandCollapseTreeMiscMetadata.setAction(new TreeExpandCollapseAllAction(this.toggleButtonExpandCollapseTreeMiscMetadata, this.treeMiscMetadata));
        this.toggleButtonExpandCollapseTreeMiscMetadata.setText(TreeExpandCollapseAllAction.NOT_SELECTED_TEXT);
        this.toggleButtonExpandCollapseTreeMiscMetadata.setMargin(new Insets(1, 1, 1, 1));
        this.toggleButtonExpandCollapseTreeMiscMetadata.setName("toggleButtonExpandCollapseTreeMiscMetadata");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 1, 1, 0);
        this.panelMiscMetadata.add((Component)this.toggleButtonExpandCollapseTreeMiscMetadata, gridBagConstraints);
        this.buttonSearchInTreeMiscMetadata.setAction(new SearchInJxTreeAction((JXTree)this.treeMiscMetadata));
        this.buttonSearchInTreeMiscMetadata.setText(bundle.getString("AppPanel.buttonSearchInTreeMiscMetadata.text"));
        this.buttonSearchInTreeMiscMetadata.setMargin(new Insets(1, 1, 1, 1));
        this.buttonSearchInTreeMiscMetadata.setName("buttonSearchInTreeMiscMetadata");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 2, 1, 0);
        this.panelMiscMetadata.add((Component)this.buttonSearchInTreeMiscMetadata, gridBagConstraints);
        this.tabbedPaneSelection.addTab(bundle.getString("AppPanel.panelMiscMetadata.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_misc_metadata.png")), this.panelMiscMetadata);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.9;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.panelSelection.add((Component)this.tabbedPaneSelection, gridBagConstraints);
        this.splitPaneMain.setLeftComponent(this.panelSelection);
        this.panelThumbnailsMetadata.setName("panelThumbnailsMetadata");
        this.splitPaneThumbnailsMetadata.setDividerSize(6);
        this.splitPaneThumbnailsMetadata.setResizeWeight(1.0);
        this.splitPaneThumbnailsMetadata.setName("splitPaneThumbnailsMetadata");
        this.splitPaneThumbnailsMetadata.setOneTouchExpandable(true);
        this.thumbnailPanelComponent.setMinimumSize(new Dimension(300, 300));
        this.thumbnailPanelComponent.setName("thumbnailPanelComponent");
        this.thumbnailPanelComponent.setPreferredSize(new Dimension(100, 0));
        this.thumbnailPanelComponent.setLayout(new GridBagLayout());
        this.splitPaneThumbnailsMetadata.setLeftComponent(this.thumbnailPanelComponent);
        this.panelMetadata.setName("panelMetadata");
        this.panelMetadata.setLayout(new GridBagLayout());
        this.tabbedPaneMetadata.setName("tabbedPaneMetadata");
        this.tabbedPaneMetadata.setOpaque(true);
        this.panelEditKeywords.setName("panelEditKeywords");
        this.tabbedPaneMetadata.addTab(bundle.getString("AppPanel.panelEditKeywords.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_keyword.png")), this.panelEditKeywords);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelMetadata.add((Component)this.tabbedPaneMetadata, gridBagConstraints);
        this.splitPaneThumbnailsMetadata.setRightComponent(this.panelMetadata);
        GroupLayout panelThumbnailsMetadataLayout = new GroupLayout(this.panelThumbnailsMetadata);
        this.panelThumbnailsMetadata.setLayout(panelThumbnailsMetadataLayout);
        panelThumbnailsMetadataLayout.setHorizontalGroup(panelThumbnailsMetadataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 564, Short.MAX_VALUE).addGroup(panelThumbnailsMetadataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splitPaneThumbnailsMetadata, GroupLayout.Alignment.TRAILING, -1, 564, Short.MAX_VALUE)));
        panelThumbnailsMetadataLayout.setVerticalGroup(panelThumbnailsMetadataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 367, Short.MAX_VALUE).addGroup(panelThumbnailsMetadataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splitPaneThumbnailsMetadata, -1, 367, Short.MAX_VALUE)));
        this.splitPaneMain.setRightComponent(this.panelThumbnailsMetadata);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.splitPaneMain, gridBagConstraints);
        this.panelStatusbar.setName("panelStatusbar");
        this.panelStatusbar.setLayout(new GridBagLayout());
        this.labelStatusbarText.setName("labelStatusbarText");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panelStatusbar.add((Component)this.labelStatusbarText, gridBagConstraints);
        this.statusLineElementsPanel.setName("statusLineElementsPanel");
        this.statusLineElementsPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panelStatusbar.add((Component)this.statusLineElementsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 3, 5);
        this.add((Component)this.panelStatusbar, gridBagConstraints);
    }

    private void buttonDisplaySelKeywordsListActionPerformed(ActionEvent evt) {
        this.displaySelKeywordsCard("flatKeywords");
    }

    private void buttonDisplaySelKeywordsTreeActionPerformed(ActionEvent evt) {
        this.displaySelKeywordsCard("keywordsTree");
    }

    private static class SelectTabAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final JTabbedPane tabbedPane;
        private final Component component;

        private SelectTabAction(JTabbedPane tabbedPane, Component component) {
            this.tabbedPane = tabbedPane;
            this.component = component;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component selectedComponent = this.tabbedPane.getSelectedComponent();
            if (this.component != selectedComponent) {
                this.tabbedPane.setSelectedComponent(this.component);
            } else {
                EventBus.publish(new TabInEditWindowDisplayedEvent(this, this.component));
            }
        }
    }

    private static class SelectThumbnailsPanelAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final Component thumbnailsPanel;

        private SelectThumbnailsPanelAction(Component thumbnailsPanel) {
            super(Bundle.getString(AppPanel.class, "SelectThumbnailsPanelAction.Name", new Object[0]));
            this.thumbnailsPanel = thumbnailsPanel;
            this.putValue("AcceleratorKey", KeyEventUtil.getKeyStrokeMenuShortcut(48));
            this.putValue("SmallIcon", AppLookAndFeel.getIcon("icon_thumbnails.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.thumbnailsPanel.requestFocusInWindow();
        }
    }

    public static enum SelectAlso {
        NOTHING_ELSE,
        SEL_KEYWORDS_TAB;

    }
}

