/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.app.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.bushe.swing.event.EventBus;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.windows.LookAndFeelProvider;
import org.jphototagger.api.windows.OptionPageProvider;
import org.jphototagger.lib.api.LookAndFeelChangedEvent;
import org.jphototagger.lib.api.PositionProviderAscendingComparator;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.StringUtil;
import org.openide.util.Lookup;

public class AppLookAndFeelSettingsPanel
extends JPanel
implements OptionPageProvider {
    private static final long serialVersionUID = 1L;
    private boolean listen = true;
    private final ComboBoxModel<LookAndFeelProvider> lafComboBoxModel = new DefaultComboBoxModel<LookAndFeelProvider>(){
        private static final long serialVersionUID = 1L;
        {
            ArrayList<LookAndFeelProvider> providers = new ArrayList<LookAndFeelProvider>(Lookup.getDefault().lookupAll(LookAndFeelProvider.class));
            Collections.sort(providers, PositionProviderAscendingComparator.INSTANCE);
            for (LookAndFeelProvider provider : providers) {
                if (!provider.canInstall()) continue;
                this.addElement(provider);
            }
        }
    };
    private final ListCellRenderer<LookAndFeelProvider> lafListCellRenderer = new ListCellRenderer<LookAndFeelProvider>(){
        private final DefaultListCellRenderer delegate = new DefaultListCellRenderer();

        @Override
        public Component getListCellRendererComponent(JList<? extends LookAndFeelProvider> list, LookAndFeelProvider value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)this.delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            label.setText(value.getDisplayname());
            return label;
        }
    };
    private JComboBox<LookAndFeelProvider> comboBoxLaf;
    private JEditorPane editorPaneDescription;
    private JLabel labelInfo;
    private JLabel labelNoPreferences;
    private JPanel panelContent;
    private JPanel panelNoPreferences;
    private JPanel panelPreferences;
    private JScrollPane scrollPaneDescription;
    private JScrollPane scrollPanePreferences;

    public AppLookAndFeelSettingsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.restoreLaf();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public String getTitle() {
        return Bundle.getString(AppLookAndFeelSettingsPanel.class, "AppLookAndFeelSettingsPanel.Title", new Object[0]);
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public boolean isMiscOptionPage() {
        return true;
    }

    @Override
    public int getPosition() {
        return 50000;
    }

    private void setProvider(LookAndFeelProvider provider) {
        this.editorPaneDescription.setText(provider.getDescription());
        Component c = provider.getPreferencesComponent();
        this.scrollPanePreferences.setViewportView(c == null ? this.panelNoPreferences : c);
    }

    private void changeLookAndFeel() {
        LookAndFeelProvider provider = (LookAndFeelProvider)this.lafComboBoxModel.getSelectedItem();
        this.setProvider(provider);
        provider.setLookAndFeel();
        EventBus.publish(new LookAndFeelChangedEvent(this, provider));
        this.persistLaf(provider);
    }

    private void persistLaf(LookAndFeelProvider provider) {
        String key = provider.getPreferencesKey();
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setString("AppLookAndFeel", key);
    }

    private void restoreLaf() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        String laf = prefs.getString("AppLookAndFeel");
        if (!StringUtil.hasContent(laf)) {
            laf = "DefaultLookAndFeelProvider";
        }
        for (LookAndFeelProvider provider : Lookup.getDefault().lookupAll(LookAndFeelProvider.class)) {
            if (!laf.equals(provider.getPreferencesKey())) continue;
            this.listen = false;
            this.comboBoxLaf.setSelectedItem(provider);
            this.setProvider(provider);
            this.listen = true;
            break;
        }
    }

    private void initComponents() {
        this.panelNoPreferences = new JPanel();
        this.labelNoPreferences = new JLabel();
        this.panelContent = new JPanel();
        this.labelInfo = new JLabel();
        this.comboBoxLaf = new JComboBox();
        this.scrollPaneDescription = new JScrollPane();
        this.editorPaneDescription = new JEditorPane();
        this.panelPreferences = new JPanel();
        this.scrollPanePreferences = new JScrollPane();
        this.panelNoPreferences.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/app/ui/Bundle");
        this.labelNoPreferences.setText(bundle.getString("AppLookAndFeelSettingsPanel.labelNoPreferences.text"));
        this.panelNoPreferences.add((Component)this.labelNoPreferences, new GridBagConstraints());
        this.setLayout(new GridBagLayout());
        this.panelContent.setLayout(new GridBagLayout());
        this.labelInfo.setText(bundle.getString("AppLookAndFeelSettingsPanel.labelInfo.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelContent.add((Component)this.labelInfo, gridBagConstraints);
        this.comboBoxLaf.setModel(this.lafComboBoxModel);
        this.comboBoxLaf.setRenderer(this.lafListCellRenderer);
        this.comboBoxLaf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppLookAndFeelSettingsPanel.this.comboBoxLafActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelContent.add(this.comboBoxLaf, gridBagConstraints);
        this.scrollPaneDescription.setBorder(BorderFactory.createTitledBorder(bundle.getString("AppLookAndFeelSettingsPanel.scrollPaneDescription.border.title")));
        this.scrollPaneDescription.setPreferredSize(new Dimension(250, 100));
        this.editorPaneDescription.setEditable(false);
        this.editorPaneDescription.setContentType("text/html");
        this.scrollPaneDescription.setViewportView(this.editorPaneDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelContent.add((Component)this.scrollPaneDescription, gridBagConstraints);
        this.panelPreferences.setBorder(BorderFactory.createTitledBorder(bundle.getString("AppLookAndFeelSettingsPanel.panelPreferences.border.title")));
        this.panelPreferences.setPreferredSize(new Dimension(250, 200));
        this.panelPreferences.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelPreferences.add((Component)this.scrollPanePreferences, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.8;
        this.panelContent.add((Component)this.panelPreferences, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.panelContent, gridBagConstraints);
    }

    private void comboBoxLafActionPerformed(ActionEvent evt) {
        if (this.listen) {
            this.changeLookAndFeel();
        }
    }
}

