/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.app.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.windows.LookAndFeelProvider;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.util.LookAndFeelUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.SystemUtil;
import org.openide.util.Lookup;

public final class AppLookAndFeel {
    private static final String ICONS_PATH = "/org/jphototagger/program/resource/icons";
    public static final String TABLE_CELL_CSS = "margin-left:3px;margin-right:3px;";
    public static final int TABLE_MAX_CHARS_CELL = 45;
    public static final int TABLE_MAX_CHARS_ROW_HEADER = 40;
    public static final String TABLE_ROW_HEADER_CSS = "margin-left:3px;margin-right:3px;";
    private static Color tableSelectionForeground = Color.BLACK;
    private static Color tableSelectionBackground = new Color(226, 226, 255);
    private static Color tableForeground = Color.BLACK;
    private static Color tableBackground = Color.WHITE;
    public static final Color TREE_SEL_IMG_HAS_KEYWORD_FOREGROUND = Color.BLACK;
    public static final Color TREE_SEL_IMG_HAS_KEYWORD_BACKGROUND = new Color(255, 223, 181);
    public static final Color LIST_SEL_IMG_HAS_KEYWORD_FOREGROUND = TREE_SEL_IMG_HAS_KEYWORD_FOREGROUND;
    public static final Color LIST_SEL_IMG_HAS_KEYWORD_BACKGROUND = TREE_SEL_IMG_HAS_KEYWORD_BACKGROUND;
    public static final String SMALL_APP_ICON_PATH = "/org/jphototagger/program/resource/icons/icon_app_small.png";
    public static final String MEDIUM_APP_ICON_PATH = "/org/jphototagger/program/resource/icons/icon_app_medium.png";
    public static final Icon ICON_RENAME = AppLookAndFeel.getIcon("icon_rename.png");
    public static final Icon ICON_REFRESH = AppLookAndFeel.getIcon("icon_refresh.png");
    public static final Icon ICON_PASTE = AppLookAndFeel.getIcon("icon_paste.png");
    public static final Icon ICON_NEW = AppLookAndFeel.getIcon("icon_new.png");
    public static final Icon ICON_EDIT = AppLookAndFeel.getIcon("icon_edit.png");
    public static final Icon ICON_DELETE = AppLookAndFeel.getIcon("icon_delete.png");
    public static final Icon ICON_CUT = AppLookAndFeel.getIcon("icon_cut.png");
    public static final Icon ICON_COPY = AppLookAndFeel.getIcon("icon_copy.png");
    public static final Icon ICON_FILTER = AppLookAndFeel.getIcon("icon_filter.png");
    public static final Icon ICON_START = AppLookAndFeel.getIcon("icon_start.png");
    public static final Icon ICON_CANCEL = AppLookAndFeel.getIcon("icon_cancel.png");
    public static final Image ERROR_THUMBNAIL = IconUtil.getIconImage(Bundle.getString(AppLookAndFeel.class, "ErrorThumbnailPath", new Object[0]));
    private static final List<Image> APP_ICONS = new ArrayList<Image>();
    private static final List<String> APP_ICON_PATHS = new ArrayList<String>();
    private static Color listBackground;
    private static Color listForeground;
    private static Color listSelectionBackground;
    private static Color listSelectionForeground;
    private static Color treeSelectionBackground;
    private static Color treeSelectionForeground;
    private static Color treeTextBackground;
    private static Color treeTextForeground;
    static final String PREF_KEY_LOOK_AND_FEEL = "AppLookAndFeel";

    public static List<Image> getAppIcons() {
        return Collections.unmodifiableList(APP_ICONS);
    }

    public static List<String> getAppIconPaths() {
        return Collections.unmodifiableList(APP_ICON_PATHS);
    }

    public static String toLocalizedPath(String path) {
        if (path == null) {
            throw new NullPointerException("path == null");
        }
        if (path.trim().isEmpty()) {
            throw new IllegalArgumentException("path is empty!");
        }
        String lang = Locale.getDefault().getLanguage();
        int lastPathDelim = path.lastIndexOf(47);
        return lastPathDelim >= 0 ? path.substring(0, lastPathDelim + 1) + lang + "/" + path.substring(lastPathDelim + 1) : lang + "/" + path;
    }

    public static Image getLocalizedImage(String path) {
        if (path == null) {
            throw new NullPointerException("path == null");
        }
        URL imgURL = IconUtil.class.getResource(AppLookAndFeel.toLocalizedPath(path));
        if (imgURL != null) {
            return new ImageIcon(imgURL).getImage();
        }
        return IconUtil.getIconImage(path);
    }

    public static ImageIcon getIcon(String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        return IconUtil.getImageIcon("/org/jphototagger/program/resource/icons/" + name);
    }

    public static void set() {
        try {
            AppLookAndFeel.lookupLookAndFeel();
        }
        catch (Throwable t) {
            Logger.getLogger(AppLookAndFeel.class.getName()).log(Level.SEVERE, null, t);
            LookAndFeelUtil.setSystemLookAndFeel();
        }
        AppLookAndFeel.setJPhotoTaggerDefaults();
    }

    private static void setJPhotoTaggerDefaults() {
        if (SystemUtil.isWindows()) {
            UIManager.put("FileChooser.useSystemExtensionHiding", true);
        }
        AppLookAndFeel.changeFontWeights();
        AppLookAndFeel.takeFromUiColors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lookupLookAndFeel() {
        boolean set = false;
        try {
            Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
            if (!prefs.containsKey(PREF_KEY_LOOK_AND_FEEL)) {
                return;
            }
            for (LookAndFeelProvider provider : Lookup.getDefault().lookupAll(LookAndFeelProvider.class)) {
                if (!prefs.getString(PREF_KEY_LOOK_AND_FEEL).equals(provider.getPreferencesKey())) continue;
                provider.setLookAndFeel();
                set = true;
                return;
            }
        }
        catch (Throwable t) {
            Logger.getLogger(AppLookAndFeel.class.getName()).log(Level.SEVERE, null, t);
        }
        finally {
            if (!set) {
                LookAndFeelUtil.setSystemLookAndFeel();
            }
        }
    }

    private static void takeFromUiColors() {
        treeSelectionForeground = LookAndFeelUtil.getUiColor("Tree.selectionForeground");
        treeSelectionBackground = LookAndFeelUtil.getUiColor("Tree.selectionBackground");
        treeTextBackground = LookAndFeelUtil.getUiColor("Tree.textBackground");
        treeTextForeground = LookAndFeelUtil.getUiColor("Tree.textForeground");
        listSelectionForeground = LookAndFeelUtil.getUiColor("List.selectionForeground");
        listSelectionBackground = LookAndFeelUtil.getUiColor("List.selectionBackground");
        listBackground = LookAndFeelUtil.getUiColor("List.background");
        listForeground = LookAndFeelUtil.getUiColor("List.foreground");
        tableForeground = LookAndFeelUtil.getUiColor("Table.foreground");
        tableBackground = LookAndFeelUtil.getUiColor("Table.background ");
        tableSelectionForeground = LookAndFeelUtil.getUiColor("Table.selectionForeground");
        tableSelectionBackground = LookAndFeelUtil.getUiColor("Table.selectionBackground ");
    }

    public static Color getListBackground() {
        return listBackground;
    }

    public static Color getListForeground() {
        return listForeground;
    }

    public static Color getListSelectionBackground() {
        return listSelectionBackground;
    }

    public static Color getListSelectionForeground() {
        return listSelectionForeground;
    }

    public static Color getTreeSelectionBackground() {
        return treeSelectionBackground;
    }

    public static Color getTreeSelectionForeground() {
        return treeSelectionForeground;
    }

    public static Color getTreeBackground() {
        return treeTextBackground;
    }

    public static Color getTreeForeground() {
        return treeTextForeground;
    }

    public static Color getTableSelectionForeground() {
        return tableSelectionForeground;
    }

    public static Color getTableSelectionBackground() {
        return tableSelectionBackground;
    }

    public static Color getTableForeground() {
        return tableForeground;
    }

    public static Color getTableBackground() {
        return tableBackground;
    }

    private static void changeFontWeights() {
        AppLookAndFeel.setBoldFont("Button.font", false);
        AppLookAndFeel.setBoldFont("CheckBox.font", false);
        AppLookAndFeel.setBoldFont("CheckBoxMenuItem.font", false);
        AppLookAndFeel.setBoldFont("ColorChooser.font", false);
        AppLookAndFeel.setBoldFont("ComboBox.font", false);
        AppLookAndFeel.setBoldFont("EditorPane.font", false);
        AppLookAndFeel.setBoldFont("FormattedTextField.font", false);
        AppLookAndFeel.setBoldFont("Label.font", false);
        AppLookAndFeel.setBoldFont("List.font", false);
        AppLookAndFeel.setBoldFont("MenuBar.font", false);
        AppLookAndFeel.setBoldFont("Menu.font", false);
        AppLookAndFeel.setBoldFont("MenuItem.font", false);
        AppLookAndFeel.setBoldFont("OptionPane.font", false);
        AppLookAndFeel.setBoldFont("Panel.font", false);
        AppLookAndFeel.setBoldFont("PopupMenu.font", false);
        AppLookAndFeel.setBoldFont("RadioButton.font", false);
        AppLookAndFeel.setBoldFont("RadioButtonMenuItem.font", false);
        AppLookAndFeel.setBoldFont("ScrollPane.font", false);
        AppLookAndFeel.setBoldFont("Slider.font", false);
        AppLookAndFeel.setBoldFont("Spinner.font", false);
        AppLookAndFeel.setBoldFont("TabbedPane.font", false);
        AppLookAndFeel.setBoldFont("Table.font", false);
        AppLookAndFeel.setBoldFont("TextArea.font", false);
        AppLookAndFeel.setBoldFont("TextField.font", false);
        AppLookAndFeel.setBoldFont("Text.font", false);
        AppLookAndFeel.setBoldFont("TextPane.font", false);
        AppLookAndFeel.setBoldFont("TextPane.font", false);
        AppLookAndFeel.setBoldFont("ToggleButton.font", false);
        AppLookAndFeel.setBoldFont("ToolBar.font", false);
        AppLookAndFeel.setBoldFont("ToolTip.font", false);
        AppLookAndFeel.setBoldFont("Tree.font", false);
        AppLookAndFeel.setBoldFont("Viewport.font", false);
        AppLookAndFeel.setBoldFont("PasswordField.font", true);
        AppLookAndFeel.setBoldFont("ProgressBar.font", true);
        AppLookAndFeel.setBoldFont("TableHeader.font", true);
        AppLookAndFeel.setBoldFont("TitledBorder.font.font", true);
    }

    private static void setBoldFont(String key, boolean bold) {
        Font defaultFont = UIManager.getFont(key);
        if (defaultFont != null) {
            int weight = bold ? 1 : 0;
            int style = defaultFont.isItalic() ? weight | 2 : weight;
            Font derivedFont = defaultFont.deriveFont(style);
            UIManager.put(key, new FontUIResource(derivedFont));
        }
    }

    private AppLookAndFeel() {
    }

    static {
        APP_ICON_PATHS.add(SMALL_APP_ICON_PATH);
        APP_ICON_PATHS.add(MEDIUM_APP_ICON_PATH);
        APP_ICONS.add(IconUtil.getIconImage(SMALL_APP_ICON_PATH));
        APP_ICONS.add(IconUtil.getIconImage(MEDIUM_APP_ICON_PATH));
    }
}

