/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.app.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.windows.MainWindowMenuProvider;
import org.jphototagger.api.windows.MenuItemProvider;
import org.jphototagger.lib.api.LayerUtil;
import org.jphototagger.lib.api.LookAndFeelChangedEvent;
import org.jphototagger.lib.api.PositionProviderAscendingComparator;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.lib.swing.util.MenuUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.program.app.AppLifeCycle;
import org.jphototagger.program.app.ui.AppLookAndFeel;
import org.jphototagger.program.app.ui.AppPanel;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class AppFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final Map<GoTo, JMenuItem> menuItemOfGoto = new EnumMap<GoTo, JMenuItem>(GoTo.class);
    private final Map<JMenuItem, GoTo> gotoOfMenuItem = new HashMap<JMenuItem, GoTo>();
    private AppPanel appPanel;
    private int lastGotoSelectionItemIndex = 8;
    private int lastGotoEditItemIndex = 13;
    private int lastSelectionGotoItemAcceleratorKeyCode = 55;
    private int lastEditGotoItemAcceleratorKeyCode = 48;
    private ButtonGroup buttonGroupSort;
    private JMenuBar menuBar;
    private JMenu menuEdit;
    private JMenu menuFile;
    private JMenu menuGoto;
    private JMenu menuHelp;
    private JMenuItem menuItemGotoCollections;
    private JMenuItem menuItemGotoDirectories;
    private JMenuItem menuItemGotoFavorites;
    private JMenuItem menuItemGotoKeywordsEdit;
    private JMenuItem menuItemGotoKeywordsSel;
    private JMenuItem menuItemGotoMiscMetadata;
    private JMenuItem menuItemGotoSavedSearches;
    private JMenuItem menuItemGotoTimeline;
    private JMenu menuTools;
    private JMenu menuView;
    private JMenu menuWindow;
    private JPopupMenu.Separator sep17;
    private JPopupMenu.Separator sep18;

    private void initGotoMenuItemsMap() {
        this.menuItemOfGoto.put(GoTo.DIRECTORIES, this.menuItemGotoDirectories);
        this.menuItemOfGoto.put(GoTo.FAVORITES, this.menuItemGotoFavorites);
        this.menuItemOfGoto.put(GoTo.KEYWORDS_EDIT, this.menuItemGotoKeywordsEdit);
        this.menuItemOfGoto.put(GoTo.IMAGE_COLLECTIONS, this.menuItemGotoCollections);
        this.menuItemOfGoto.put(GoTo.KEYWORDS_SEL, this.menuItemGotoKeywordsSel);
        this.menuItemOfGoto.put(GoTo.MISC_METADATA, this.menuItemGotoMiscMetadata);
        this.menuItemOfGoto.put(GoTo.SAVED_SEARCHES, this.menuItemGotoSavedSearches);
        this.menuItemOfGoto.put(GoTo.TIMELINE, this.menuItemGotoTimeline);
        for (GoTo gt : this.menuItemOfGoto.keySet()) {
            this.gotoOfMenuItem.put(this.menuItemOfGoto.get((Object)gt), gt);
        }
    }

    public AppFrame() {
        this.init();
    }

    private void init() {
        this.initComponents();
        GUI.setAppFrame(this);
        this.addAppPanel();
        this.lookupMenuItems();
        MenuUtil.setMnemonics(this.menuBar);
        this.initGotoMenuItemsMap();
        this.setIconImages(AppLookAndFeel.getAppIcons());
        AnnotationProcessor.process(this);
        AppLifeCycle.INSTANCE.started(this);
    }

    public AppPanel getAppPanel() {
        return this.appPanel;
    }

    private void addAppPanel() {
        this.appPanel = new AppPanel();
        this.getContentPane().add(this.appPanel);
    }

    public GoTo getGotoOfMenuItem(JMenuItem item) {
        return this.gotoOfMenuItem.get(item);
    }

    public JMenuItem getMenuItemOfGoto(GoTo gt) {
        return this.menuItemOfGoto.get((Object)gt);
    }

    @Override
    public void setTitle(String title) {
        if (title.equals("JPhotoTagger")) {
            super.setTitle("JPhotoTagger");
        } else {
            super.setTitle(title + " - " + "JPhotoTagger");
        }
    }

    private void lookupMenuItems() {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                Collection<MainWindowMenuProvider> providers = Lookup.getDefault().lookupAll(MainWindowMenuProvider.class);
                ArrayList<? extends MenuItemProvider> editMenuItems = new ArrayList<MenuItemProvider>();
                ArrayList<? extends MenuItemProvider> fileMenuItems = new ArrayList<MenuItemProvider>();
                ArrayList<? extends MenuItemProvider> gotoMenuItems = new ArrayList<MenuItemProvider>();
                ArrayList<? extends MenuItemProvider> toolsMenuItems = new ArrayList<MenuItemProvider>();
                ArrayList<? extends MenuItemProvider> viewMenuItems = new ArrayList<MenuItemProvider>();
                ArrayList<? extends MenuItemProvider> helpMenuItems = new ArrayList<MenuItemProvider>();
                ArrayList<? extends MenuItemProvider> windowMenuItems = new ArrayList<MenuItemProvider>();
                for (MainWindowMenuProvider provider : providers) {
                    editMenuItems.addAll(provider.getEditMenuItems());
                    fileMenuItems.addAll(provider.getFileMenuItems());
                    gotoMenuItems.addAll(provider.getGotoMenuItems());
                    helpMenuItems.addAll(provider.getHelpMenuItems());
                    toolsMenuItems.addAll(provider.getToolsMenuItems());
                    viewMenuItems.addAll(provider.getViewMenuItems());
                    windowMenuItems.addAll(provider.getWindowMenuItems());
                }
                AppFrame.this.addMenuItems(fileMenuItems, AppFrame.this.menuFile);
                AppFrame.this.addMenuItems(editMenuItems, AppFrame.this.menuEdit);
                AppFrame.this.addMenuItems(gotoMenuItems, AppFrame.this.menuGoto);
                AppFrame.this.addMenuItems(viewMenuItems, AppFrame.this.menuView);
                AppFrame.this.addMenuItems(toolsMenuItems, AppFrame.this.menuTools);
                AppFrame.this.addMenuItems(windowMenuItems, AppFrame.this.menuWindow);
                AppFrame.this.addMenuItems(helpMenuItems, AppFrame.this.menuHelp);
            }
        });
    }

    private void addMenuItems(List<? extends MenuItemProvider> menuItemProviders, JMenu menu) {
        Collections.sort(menuItemProviders, PositionProviderAscendingComparator.INSTANCE);
        LayerUtil.logWarningIfNotUniquePositions(menuItemProviders);
        for (MenuItemProvider menuItemProvider : menuItemProviders) {
            this.addMenuItem(menuItemProvider, menu);
        }
    }

    private void addMenuItem(MenuItemProvider menuItemProvider, JMenu menu) {
        int index;
        int position = menuItemProvider.getPosition();
        JMenuItem menuItem = menuItemProvider.getMenuItem();
        int itemCount = menu.getItemCount();
        int n = index = position < 0 || position > itemCount ? itemCount : position;
        if (menuItemProvider.isSeparatorBefore()) {
            menu.add((Component)new JPopupMenu.Separator(), index);
            ++index;
        }
        menu.add((Component)menuItem, index);
    }

    void addGotoMenuItemForSelectionWindow(Action action) {
        JMenuItem item = new JMenuItem(action);
        if (!this.hasAccelerator(action) && this.lastSelectionGotoItemAcceleratorKeyCode > 48 && this.lastSelectionGotoItemAcceleratorKeyCode <= 57) {
            KeyStroke keyStroke = KeyEventUtil.getKeyStrokeMenuShortcut(this.lastSelectionGotoItemAcceleratorKeyCode + 1);
            item.setAccelerator(keyStroke);
            ++this.lastSelectionGotoItemAcceleratorKeyCode;
        }
        this.menuGoto.insert(item, this.lastGotoSelectionItemIndex + 1);
        ++this.lastGotoSelectionItemIndex;
    }

    void addGotoMenuItem(Action action, int index, boolean separatorBefore) {
        if (separatorBefore) {
            this.menuGoto.add((Component)new JPopupMenu.Separator(), index);
        }
        JMenuItem item = new JMenuItem(action);
        MnemonicUtil.setMnemonics(item);
        this.menuGoto.insert(item, separatorBefore ? index + 1 : index);
    }

    private boolean hasAccelerator(Action action) {
        if (action instanceof AbstractAction) {
            AbstractAction abstractAction = (AbstractAction)action;
            Object value = abstractAction.getValue("AcceleratorKey");
            return value != null;
        }
        return false;
    }

    void addGotoMenuItemForEditWindow(Action action) {
        JMenuItem item = new JMenuItem(action);
        if (!this.hasAccelerator(action) && this.lastEditGotoItemAcceleratorKeyCode >= 48 && this.lastEditGotoItemAcceleratorKeyCode <= 57) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(this.lastEditGotoItemAcceleratorKeyCode + 1, 8);
            item.setAccelerator(keyStroke);
            ++this.lastEditGotoItemAcceleratorKeyCode;
        }
        this.menuGoto.insert(item, this.lastGotoEditItemIndex + 1);
        ++this.lastGotoEditItemIndex;
    }

    @EventSubscriber(eventClass=LookAndFeelChangedEvent.class)
    public void lookAndFeelChanged(LookAndFeelChangedEvent evt) {
        SwingUtilities.updateComponentTreeUI(this);
    }

    private void initComponents() {
        this.buttonGroupSort = new ButtonGroup();
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu();
        this.menuEdit = new JMenu();
        this.menuView = new JMenu();
        this.menuGoto = new JMenu();
        this.sep17 = new JPopupMenu.Separator();
        this.menuItemGotoDirectories = new JMenuItem();
        this.menuItemGotoSavedSearches = new JMenuItem();
        this.menuItemGotoCollections = new JMenuItem();
        this.menuItemGotoFavorites = new JMenuItem();
        this.menuItemGotoKeywordsSel = new JMenuItem();
        this.menuItemGotoTimeline = new JMenuItem();
        this.menuItemGotoMiscMetadata = new JMenuItem();
        this.sep18 = new JPopupMenu.Separator();
        this.menuItemGotoKeywordsEdit = new JMenuItem();
        this.menuTools = new JMenu();
        this.menuWindow = new JMenu();
        this.menuHelp = new JMenu();
        this.setDefaultCloseOperation(0);
        this.setTitle("JPhotoTagger");
        this.setName("Form");
        this.menuBar.setName("menuBar");
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/app/ui/Bundle");
        this.menuFile.setText(bundle.getString("AppFrame.menuFile.text"));
        this.menuFile.setName("menuFile");
        this.menuBar.add(this.menuFile);
        this.menuEdit.setText(bundle.getString("AppFrame.menuEdit.text"));
        this.menuEdit.setName("menuEdit");
        this.menuBar.add(this.menuEdit);
        this.menuView.setText(bundle.getString("AppFrame.menuView.text"));
        this.menuView.setName("menuView");
        this.menuBar.add(this.menuView);
        this.menuGoto.setText(bundle.getString("AppFrame.menuGoto.text"));
        this.menuGoto.setName("menuGoto");
        this.sep17.setName("sep17");
        this.menuGoto.add(this.sep17);
        this.menuItemGotoDirectories.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(49));
        this.menuItemGotoDirectories.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_folder.png")));
        this.menuItemGotoDirectories.setText(bundle.getString("AppFrame.menuItemGotoDirectories.text"));
        this.menuItemGotoDirectories.setName("menuItemGotoDirectories");
        this.menuGoto.add(this.menuItemGotoDirectories);
        this.menuItemGotoSavedSearches.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(50));
        this.menuItemGotoSavedSearches.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_search.png")));
        this.menuItemGotoSavedSearches.setText(bundle.getString("AppFrame.menuItemGotoSavedSearches.text"));
        this.menuItemGotoSavedSearches.setName("menuItemGotoSavedSearches");
        this.menuGoto.add(this.menuItemGotoSavedSearches);
        this.menuItemGotoCollections.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(51));
        this.menuItemGotoCollections.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_imagecollection.png")));
        this.menuItemGotoCollections.setText(bundle.getString("AppFrame.menuItemGotoCollections.text"));
        this.menuItemGotoCollections.setName("menuItemGotoCollections");
        this.menuGoto.add(this.menuItemGotoCollections);
        this.menuItemGotoFavorites.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(52));
        this.menuItemGotoFavorites.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_favorite.png")));
        this.menuItemGotoFavorites.setText(bundle.getString("AppFrame.menuItemGotoFavorites.text"));
        this.menuItemGotoFavorites.setName("menuItemGotoFavorites");
        this.menuGoto.add(this.menuItemGotoFavorites);
        this.menuItemGotoKeywordsSel.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(53));
        this.menuItemGotoKeywordsSel.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_keyword.png")));
        this.menuItemGotoKeywordsSel.setText(bundle.getString("AppFrame.menuItemGotoKeywordsSel.text"));
        this.menuItemGotoKeywordsSel.setName("menuItemGotoKeywordsSel");
        this.menuGoto.add(this.menuItemGotoKeywordsSel);
        this.menuItemGotoTimeline.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(54));
        this.menuItemGotoTimeline.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_timeline.png")));
        this.menuItemGotoTimeline.setText(bundle.getString("AppFrame.menuItemGotoTimeline.text"));
        this.menuItemGotoTimeline.setName("menuItemGotoTimeline");
        this.menuGoto.add(this.menuItemGotoTimeline);
        this.menuItemGotoMiscMetadata.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(55));
        this.menuItemGotoMiscMetadata.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_misc_metadata.png")));
        this.menuItemGotoMiscMetadata.setText(bundle.getString("AppFrame.menuItemGotoMiscMetadata.text"));
        this.menuItemGotoMiscMetadata.setName("menuItemGotoMiscMetadata");
        this.menuGoto.add(this.menuItemGotoMiscMetadata);
        this.sep18.setName("sep18");
        this.menuGoto.add(this.sep18);
        this.menuItemGotoKeywordsEdit.setAccelerator(KeyStroke.getKeyStroke(52, 8));
        this.menuItemGotoKeywordsEdit.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_keyword.png")));
        this.menuItemGotoKeywordsEdit.setText(bundle.getString("AppFrame.menuItemGotoKeywordsEdit.text"));
        this.menuItemGotoKeywordsEdit.setName("menuItemGotoKeywordsEdit");
        this.menuGoto.add(this.menuItemGotoKeywordsEdit);
        this.menuBar.add(this.menuGoto);
        this.menuTools.setText(bundle.getString("AppFrame.menuTools.text"));
        this.menuTools.setName("menuTools");
        this.menuBar.add(this.menuTools);
        this.menuWindow.setText(bundle.getString("AppFrame.menuWindow.text"));
        this.menuWindow.setName("menuWindow");
        this.menuBar.add(this.menuWindow);
        this.menuHelp.setText(bundle.getString("AppFrame.menuHelp.text"));
        this.menuHelp.setName("menuHelp");
        this.menuBar.add(this.menuHelp);
        this.setJMenuBar(this.menuBar);
    }

    public static enum GoTo {
        DIRECTORIES,
        FAVORITES,
        KEYWORDS_EDIT,
        IMAGE_COLLECTIONS,
        KEYWORDS_SEL,
        MISC_METADATA,
        SAVED_SEARCHES,
        TIMELINE;

    }
}

