/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.app.logging;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JLabel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.messages.MessageType;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.api.windows.MainWindowManager;
import org.jphototagger.api.windows.StatusLineElementProvider;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.MouseEventUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.app.logging.ShowErrorLogfileAction;
import org.openide.util.Lookup;

public final class ErrorLogHandler
extends Handler
implements MouseListener,
StatusLineElementProvider {
    static final String PREF_KEY_ERROR_TEXTS_NOT_IN_GUI = "AppLoggingSystemSettings.ErrorTextsNotInGui";
    private static final long MILLISECONDS_ERROR_DISPLAY = 4000L;
    private static final String LABEL_ERROR_TOOLTIP_TEXT = Bundle.getString(ErrorLogHandler.class, "ErrorLogHandler.ErrorLabel.TooltipText", new Object[0]);
    private static final String STATUSBAR_INFO_TEXT = Bundle.getString(ErrorLogHandler.class, "ErrorLogHandler.StatusbBar.InfoText", new Object[0]);
    private static final int MIN_LOG_LEVEL_VALUE = Level.WARNING.intValue();
    private final Collection<String> ignoreErrorMessages = new CopyOnWriteArrayList<String>();
    private final JLabel errorLabel = new JLabel();

    public ErrorLogHandler() {
        this.initIgnoreErrorMessages();
        this.listen();
    }

    private void initIgnoreErrorMessages() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        if (prefs != null) {
            this.ignoreErrorMessages.addAll(prefs.getStringCollection(PREF_KEY_ERROR_TEXTS_NOT_IN_GUI));
        }
    }

    private void listen() {
        this.errorLabel.addMouseListener(this);
        Logger.getLogger("").addHandler(this);
        Logger.getLogger("org.jphototagger").addHandler(this);
        AnnotationProcessor.process(this);
    }

    private boolean isIgnore(String message) {
        for (String userMessage : this.ignoreErrorMessages) {
            if (!message.contains(userMessage)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void publish(LogRecord record) {
        boolean isError;
        int recordLevelValue = record.getLevel().intValue();
        boolean bl = isError = recordLevelValue >= MIN_LOG_LEVEL_VALUE;
        if (isError && !this.isIgnore(this.resolveMessage(record))) {
            EventQueueUtil.invokeInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    ErrorLogHandler.this.showErrorLabel();
                }
            });
        }
    }

    private String resolveMessage(LogRecord record) {
        String message = record.getMessage();
        if (message == null) {
            String thrownMessage;
            Throwable thrown = record.getThrown();
            String string = thrownMessage = thrown == null ? "" : thrown.getMessage();
            return thrown == null ? "" : (thrownMessage == null ? "" : thrownMessage);
        }
        Object[] parameters = record.getParameters();
        if (parameters == null) {
            return message;
        }
        return MessageFormat.format(message, parameters);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (MouseEventUtil.isLeftClick(evt)) {
            ShowErrorLogfileAction.showErrorLogfile();
            this.errorLabel.setIcon(null);
            this.errorLabel.setToolTipText("");
        }
    }

    private void showErrorLabel() {
        MainWindowManager mainWindowManager = Lookup.getDefault().lookup(MainWindowManager.class);
        mainWindowManager.setMainWindowStatusbarText(STATUSBAR_INFO_TEXT, MessageType.ERROR, 4000L);
        this.errorLabel.setIcon(IconUtil.getImageIcon(ErrorLogHandler.class, "error.png"));
        this.errorLabel.setToolTipText(LABEL_ERROR_TOOLTIP_TEXT);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public Component getStatusLineElement() {
        return this.errorLabel;
    }

    @Override
    public int getPosition() {
        return 500;
    }

    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void preferencesChangedEvent(PreferencesChangedEvent e) {
        if (PREF_KEY_ERROR_TEXTS_NOT_IN_GUI.equals(e.getKey())) {
            this.ignoreErrorMessages.clear();
            this.ignoreErrorMessages.addAll((Collection)e.getNewValue());
        }
    }
}

