/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.app.logging;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.JXLabel;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.windows.OptionPageProvider;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.MouseEventUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.StringUtil;
import org.jphototagger.program.app.logging.AppLoggingSystem;
import org.jphototagger.program.app.logging.LogLevelComboBoxModel;
import org.openide.util.Lookup;

public class AppLoggingSystemSettingsPanel
extends JPanel
implements OptionPageProvider {
    private static final long serialVersionUID = 1L;
    private final Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
    private final DefaultListModel<String> errorTextsListModel = new DefaultListModel();
    private final DocumentListener addErrorTextListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            AppLoggingSystemSettingsPanel.this.setAddErrorTextButtonEnabled();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            AppLoggingSystemSettingsPanel.this.setAddErrorTextButtonEnabled();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            AppLoggingSystemSettingsPanel.this.setAddErrorTextButtonEnabled();
        }
    };
    private final ListSelectionListener errorTextSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                AppLoggingSystemSettingsPanel.this.setRemoveErrorTextButtonEnabled();
                AppLoggingSystemSettingsPanel.this.setEditErrorTextButtonEnabled();
            }
        }
    };
    private final MouseListener editErrorTextMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (MouseEventUtil.isDoubleClick(e)) {
                AppLoggingSystemSettingsPanel.this.editErrorText();
            }
        }
    };
    private final KeyListener addErrorTextKeyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                AppLoggingSystemSettingsPanel.this.addErrorText();
            }
        }
    };
    private JButton buttonAddErrorText;
    private JButton buttonEditErrorText;
    private JButton buttonRemoveErrorText;
    private JComboBox<Object> comboBoxLogLevel;
    private JTabbedPane jTabbedPane1;
    private JLabel labelErrorText;
    private JXLabel labelInfoErrorTexts;
    private JLabel labelLogLevel;
    private JList<String> listErrorTexts;
    private JPanel panelAddErrorText;
    private JPanel panelErrorTexts;
    private JPanel panelFillMisc;
    private JPanel panelIgnoreMessages;
    private JPanel panelIgnoreMessagesContent;
    private JPanel panelLogLevel;
    private JPanel panelMisc;
    private JPanel panelMiscContent;
    private JScrollPane scrollPaneErrorTexts;
    private JTextField textFieldErrorText;

    public AppLoggingSystemSettingsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.initErrorTextsListModel();
        this.comboBoxLogLevel.setSelectedItem(AppLoggingSystem.getLogLevel());
        this.textFieldErrorText.getDocument().addDocumentListener(this.addErrorTextListener);
        this.textFieldErrorText.addKeyListener(this.addErrorTextKeyListener);
        this.listErrorTexts.addListSelectionListener(this.errorTextSelectionListener);
        this.listErrorTexts.addMouseListener(this.editErrorTextMouseListener);
        this.setAddErrorTextButtonEnabled();
        this.setRemoveErrorTextButtonEnabled();
        this.setEditErrorTextButtonEnabled();
    }

    private void initErrorTextsListModel() {
        if (this.prefs != null) {
            for (String text : this.prefs.getStringCollection("AppLoggingSystemSettings.ErrorTextsNotInGui")) {
                this.errorTextsListModel.addElement(text);
            }
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public String getTitle() {
        return Bundle.getString(AppLoggingSystem.class, "AppLoggingSystemSettingsPanel.Title", new Object[0]);
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public boolean isMiscOptionPage() {
        return true;
    }

    @Override
    public int getPosition() {
        return 1000;
    }

    private void setRemoveErrorTextButtonEnabled() {
        boolean textSelected = this.listErrorTexts.getSelectedIndex() >= 0;
        this.buttonRemoveErrorText.setEnabled(textSelected);
    }

    private void setEditErrorTextButtonEnabled() {
        boolean textSelected = this.listErrorTexts.getSelectedIndex() >= 0;
        this.buttonEditErrorText.setEnabled(textSelected);
    }

    private void setAddErrorTextButtonEnabled() {
        String errorText = this.textFieldErrorText.getText().trim();
        boolean hasErrorText = !errorText.isEmpty();
        this.buttonAddErrorText.setEnabled(hasErrorText && !this.containsErrorText(errorText));
    }

    private boolean containsErrorText(String errorText) {
        Enumeration<String> e = this.errorTextsListModel.elements();
        while (e.hasMoreElements()) {
            if (!e.nextElement().contains(errorText)) continue;
            return true;
        }
        return false;
    }

    private void addErrorText() {
        String errorText = this.textFieldErrorText.getText().trim();
        if (StringUtil.hasContent(errorText) && !this.containsErrorText(errorText)) {
            this.errorTextsListModel.addElement(errorText);
            this.prefs.setStringCollection("AppLoggingSystemSettings.ErrorTextsNotInGui", this.getErrorTexts());
        }
    }

    private void removeErrorText() {
        List<String> selectedErrorTexts = this.listErrorTexts.getSelectedValuesList();
        for (String errorText : selectedErrorTexts) {
            this.errorTextsListModel.removeElement(errorText);
        }
        this.prefs.setStringCollection("AppLoggingSystemSettings.ErrorTextsNotInGui", this.getErrorTexts());
    }

    private List<String> getErrorTexts() {
        ArrayList<String> errorTexts = new ArrayList<String>(this.errorTextsListModel.getSize());
        Enumeration<String> e = this.errorTextsListModel.elements();
        while (e.hasMoreElements()) {
            errorTexts.add(e.nextElement());
        }
        return errorTexts;
    }

    private void editErrorText() {
        for (int selIndex : this.listErrorTexts.getSelectedIndices()) {
            String errorText = this.errorTextsListModel.get(selIndex);
            String input = MessageDisplayer.input(Bundle.getString(AppLoggingSystemSettingsPanel.class, "AppLoggingSystemSettingsPanel.InputErrorTextPrompt", new Object[0]), errorText);
            if (!StringUtil.hasContent(input)) continue;
            this.errorTextsListModel.set(selIndex, input);
            this.prefs.setStringCollection("AppLoggingSystemSettings.ErrorTextsNotInGui", this.getErrorTexts());
        }
    }

    private void persistLogLevel() {
        Level logLevel = (Level)this.comboBoxLogLevel.getSelectedItem();
        this.prefs.setString("UserSettings.Logging.Level", logLevel.getName());
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.panelMisc = new JPanel();
        this.panelMiscContent = new JPanel();
        this.panelLogLevel = new JPanel();
        this.labelLogLevel = new JLabel();
        this.comboBoxLogLevel = new JComboBox();
        this.panelFillMisc = new JPanel();
        this.panelIgnoreMessages = new JPanel();
        this.panelIgnoreMessagesContent = new JPanel();
        this.labelInfoErrorTexts = new JXLabel();
        this.panelErrorTexts = new JPanel();
        this.scrollPaneErrorTexts = new JScrollPane();
        this.listErrorTexts = new JList();
        this.buttonRemoveErrorText = new JButton();
        this.buttonEditErrorText = new JButton();
        this.panelAddErrorText = new JPanel();
        this.labelErrorText = new JLabel();
        this.textFieldErrorText = new JTextField();
        this.buttonAddErrorText = new JButton();
        this.setLayout(new GridBagLayout());
        this.panelMisc.setLayout(new GridBagLayout());
        this.panelMiscContent.setLayout(new GridBagLayout());
        this.panelLogLevel.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/app/logging/Bundle");
        this.labelLogLevel.setText(bundle.getString("AppLoggingSystemSettingsPanel.labelLogLevel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.panelLogLevel.add((Component)this.labelLogLevel, gridBagConstraints);
        this.comboBoxLogLevel.setModel(new LogLevelComboBoxModel());
        this.comboBoxLogLevel.setRenderer(LogLevelComboBoxModel.createRenderer());
        this.comboBoxLogLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppLoggingSystemSettingsPanel.this.comboBoxLogLevelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelLogLevel.add(this.comboBoxLogLevel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelMiscContent.add((Component)this.panelLogLevel, gridBagConstraints);
        GroupLayout panelFillMiscLayout = new GroupLayout(this.panelFillMisc);
        this.panelFillMisc.setLayout(panelFillMiscLayout);
        panelFillMiscLayout.setHorizontalGroup(panelFillMiscLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        panelFillMiscLayout.setVerticalGroup(panelFillMiscLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 229, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.panelMiscContent.add((Component)this.panelFillMisc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panelMisc.add((Component)this.panelMiscContent, gridBagConstraints);
        this.jTabbedPane1.addTab(bundle.getString("AppLoggingSystemSettingsPanel.panelMisc.TabConstraints.tabTitle"), this.panelMisc);
        this.panelIgnoreMessages.setLayout(new GridBagLayout());
        this.panelIgnoreMessagesContent.setLayout(new GridBagLayout());
        this.labelInfoErrorTexts.setText(bundle.getString("AppLoggingSystemSettingsPanel.labelInfoErrorTexts.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.panelIgnoreMessagesContent.add((Component)this.labelInfoErrorTexts, gridBagConstraints);
        this.panelErrorTexts.setLayout(new GridBagLayout());
        this.listErrorTexts.setModel(this.errorTextsListModel);
        this.scrollPaneErrorTexts.setViewportView(this.listErrorTexts);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelErrorTexts.add((Component)this.scrollPaneErrorTexts, gridBagConstraints);
        this.buttonRemoveErrorText.setText("-");
        this.buttonRemoveErrorText.setToolTipText(bundle.getString("AppLoggingSystemSettingsPanel.buttonRemoveErrorText.toolTipText"));
        this.buttonRemoveErrorText.setEnabled(false);
        this.buttonRemoveErrorText.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoveErrorText.setPreferredSize(new Dimension(22, 22));
        this.buttonRemoveErrorText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppLoggingSystemSettingsPanel.this.buttonRemoveErrorTextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelErrorTexts.add((Component)this.buttonRemoveErrorText, gridBagConstraints);
        this.buttonEditErrorText.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/app/logging/icon_edit.png")));
        this.buttonEditErrorText.setToolTipText(bundle.getString("AppLoggingSystemSettingsPanel.buttonEditErrorText.toolTipText"));
        this.buttonEditErrorText.setEnabled(false);
        this.buttonEditErrorText.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEditErrorText.setPreferredSize(new Dimension(22, 22));
        this.buttonEditErrorText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppLoggingSystemSettingsPanel.this.buttonEditErrorTextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelErrorTexts.add((Component)this.buttonEditErrorText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelIgnoreMessagesContent.add((Component)this.panelErrorTexts, gridBagConstraints);
        this.panelAddErrorText.setLayout(new GridBagLayout());
        this.labelErrorText.setText(bundle.getString("AppLoggingSystemSettingsPanel.labelErrorText.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelAddErrorText.add((Component)this.labelErrorText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelAddErrorText.add((Component)this.textFieldErrorText, gridBagConstraints);
        this.buttonAddErrorText.setText("+");
        this.buttonAddErrorText.setToolTipText(bundle.getString("AppLoggingSystemSettingsPanel.buttonAddErrorText.toolTipText"));
        this.buttonAddErrorText.setEnabled(false);
        this.buttonAddErrorText.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAddErrorText.setPreferredSize(new Dimension(22, 22));
        this.buttonAddErrorText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppLoggingSystemSettingsPanel.this.buttonAddErrorTextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelAddErrorText.add((Component)this.buttonAddErrorText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelIgnoreMessagesContent.add((Component)this.panelAddErrorText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panelIgnoreMessages.add((Component)this.panelIgnoreMessagesContent, gridBagConstraints);
        this.jTabbedPane1.addTab(bundle.getString("AppLoggingSystemSettingsPanel.panelIgnoreMessages.TabConstraints.tabTitle"), this.panelIgnoreMessages);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jTabbedPane1, gridBagConstraints);
    }

    private void buttonAddErrorTextActionPerformed(ActionEvent evt) {
        this.addErrorText();
    }

    private void buttonRemoveErrorTextActionPerformed(ActionEvent evt) {
        this.removeErrorText();
    }

    private void buttonEditErrorTextActionPerformed(ActionEvent evt) {
        this.editErrorText();
    }

    private void comboBoxLogLevelActionPerformed(ActionEvent evt) {
        this.persistLogLevel();
    }
}

