/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.app;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.api.applifecycle.AppExitTask;
import org.jphototagger.api.applifecycle.AppWillExitEvent;
import org.jphototagger.api.concurrent.ReplaceableTask;
import org.jphototagger.api.concurrent.SerialTaskExecutor;
import org.jphototagger.api.modules.Module;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.event.listener.ListenerSupport;
import org.jphototagger.domain.repository.Repository;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.app.AppStartupLock;
import org.jphototagger.program.app.ui.AppFrame;
import org.jphototagger.program.factory.MetaFactory;
import org.jphototagger.program.resource.GUI;
import org.jphototagger.program.tasks.ScheduledTasks;
import org.openide.util.Lookup;

public final class AppLifeCycle {
    public static final AppLifeCycle INSTANCE = new AppLifeCycle();
    private static final Logger LOGGER = Logger.getLogger(AppLifeCycle.class.getName());
    private final Set<Object> saveObjects = new HashSet<Object>();
    private final Set<FinalTask> finalTasks = new LinkedHashSet<FinalTask>();
    private AppFrame appFrame;
    private boolean started;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void started(AppFrame appFrame) {
        if (appFrame == null) {
            throw new NullPointerException("appFrame == null");
        }
        AppLifeCycle appLifeCycle = this;
        synchronized (appLifeCycle) {
            if (this.started) {
                return;
            }
            this.started = true;
        }
        this.appFrame = appFrame;
        Thread thread = new Thread((Runnable)MetaFactory.INSTANCE, "JPhotoTagger: Initializing meta factory");
        thread.start();
        this.listenForQuit();
    }

    private void listenForQuit() {
        this.appFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AppLifeCycle.this.quit();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFinalTask(FinalTask task) {
        if (task == null) {
            throw new NullPointerException("task == null");
        }
        Set<FinalTask> set = this.finalTasks;
        synchronized (set) {
            this.finalTasks.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFinalTask(FinalTask task) {
        if (task == null) {
            throw new NullPointerException("task == null");
        }
        Set<FinalTask> set = this.finalTasks;
        synchronized (set) {
            this.finalTasks.remove(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeFinalTasksAndQuit() {
        FinalTaskListener listenerForQuitVm = new FinalTaskListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finished() {
                Set set = AppLifeCycle.this.finalTasks;
                synchronized (set) {
                    if (AppLifeCycle.this.finalTasks.isEmpty()) {
                        AppLifeCycle.this.quitVm();
                    }
                }
            }
        };
        Set<FinalTask> set = this.finalTasks;
        synchronized (set) {
            HashSet<FinalTask> tasks = new HashSet<FinalTask>(this.finalTasks);
            GUI.getAppFrame().setEnabled(false);
            for (FinalTask task : tasks) {
                task.addListener(listenerForQuitVm);
                this.finalTasks.remove(task);
                task.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSaveObject(Object saveObject) {
        if (saveObject == null) {
            throw new NullPointerException("saveObject == null");
        }
        Set<Object> set = this.saveObjects;
        synchronized (set) {
            this.saveObjects.add(saveObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSaveObject(Object saveObject) {
        if (saveObject == null) {
            throw new NullPointerException("saveObject == null");
        }
        Set<Object> set = this.saveObjects;
        synchronized (set) {
            this.saveObjects.remove(saveObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        if (this.ensureSerialTasksFinished()) {
            EventBus.publish(new AppWillExitEvent(this));
            this.persistAppFrame();
            this.waitUntilAllSaveObjectsSaved();
            this.executeExitTasks();
            this.removeModules();
            Set<FinalTask> set = this.finalTasks;
            synchronized (set) {
                if (this.finalTasks.isEmpty()) {
                    this.quitVm();
                } else {
                    this.executeFinalTasksAndQuit();
                }
            }
        }
    }

    private void removeModules() {
        Collection<Module> modules = Lookup.getDefault().lookupAll(Module.class);
        for (Module module : modules) {
            module.remove();
        }
    }

    public static void quitBeforeGuiWasCreated() {
        LOGGER.info("Quitting before the GUI was created.");
        AppLifeCycle.shutdownRepository();
        AppStartupLock.unlock();
        System.exit(1);
    }

    private void quitVm() {
        CancelOtherTasks.cancel();
        AppLifeCycle.shutdownRepository();
        this.appFrame.dispose();
        AppStartupLock.unlock();
        System.exit(0);
    }

    private void executeExitTasks() {
        for (AppExitTask task : Lookup.getDefault().lookupAll(AppExitTask.class)) {
            task.execute();
        }
    }

    private boolean ensureSerialTasksFinished() {
        boolean finished;
        SerialTaskExecutor executor = Lookup.getDefault().lookup(SerialTaskExecutor.class);
        boolean bl = finished = executor.getTaskCount() <= 0;
        if (finished) {
            return true;
        }
        String message = Bundle.getString(AppLifeCycle.class, "AppLifeCycle.Confirm.QuitOnUserTasks", new Object[0]);
        return MessageDisplayer.confirmYesNo(this.appFrame, message);
    }

    private void waitUntilAllSaveObjectsSaved() {
        long elapsedMilliseconds = 0L;
        long terminationTimeoutMilliSeconds = 120000L;
        long checkIntervalMilliSeconds = 2000L;
        if (this.hasSaveObjects()) {
            LOGGER.log(Level.INFO, "Application waits until those objects have saved data: {0}", this.saveObjects);
            while (this.hasSaveObjects() && elapsedMilliseconds < terminationTimeoutMilliSeconds) {
                try {
                    elapsedMilliseconds += checkIntervalMilliSeconds;
                    Thread.sleep(checkIntervalMilliSeconds);
                }
                catch (Throwable t) {
                    Logger.getLogger(AppLifeCycle.class.getName()).log(Level.SEVERE, null, t);
                }
                if (elapsedMilliseconds < terminationTimeoutMilliSeconds) continue;
                String message = Bundle.getString(AppLifeCycle.class, "AppLifeCycle.Error.ExitDataNotSaved.MaxWaitTimeExceeded", terminationTimeoutMilliSeconds / 1000L);
                MessageDisplayer.error(null, message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasSaveObjects() {
        Set<Object> set = this.saveObjects;
        synchronized (set) {
            return this.saveObjects.size() > 0;
        }
    }

    private void persistAppFrame() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        String key = this.appFrame.getClass().getName();
        prefs.setSize(key, this.appFrame);
        prefs.setLocation(key, this.appFrame);
    }

    private static void shutdownRepository() {
        Repository repo = Lookup.getDefault().lookup(Repository.class);
        repo.shutdown();
    }

    private AppLifeCycle() {
        Runtime.getRuntime().addShutdownHook(new AppLifeCycleShutdownHook());
    }

    private final class AppLifeCycleShutdownHook
    extends Thread {
        private AppLifeCycleShutdownHook() {
            super("JPhotoTagger: App life cycle shoudown Hook");
        }

        @Override
        public void run() {
            try {
                Repository repo = Lookup.getDefault().lookup(Repository.class);
                if (repo != null && repo.isInit()) {
                    Logger.getLogger(AppLifeCycleShutdownHook.class.getName()).severe("Database has not been shutdown; now shutting it down");
                    repo.shutdown();
                }
            }
            catch (Throwable t) {
                Logger.getLogger(AppLifeCycleShutdownHook.class.getName()).log(Level.SEVERE, null, t);
            }
        }
    }

    private static class CancelOtherTasks {
        private static final long MILLISECONDS_SLEEP = 2000L;

        public static void cancel() {
            boolean sleep;
            SerialTaskExecutor serialTaskExecutor = Lookup.getDefault().lookup(SerialTaskExecutor.class);
            ReplaceableTask replaceableTask = Lookup.getDefault().lookup(ReplaceableTask.class);
            ScheduledTasks.INSTANCE.cancelCurrentTasks();
            replaceableTask.cancelRunningTask();
            serialTaskExecutor.cancelAllTasks();
            boolean serialTasksRunning = serialTaskExecutor.getTaskCount() > 0;
            boolean bl = sleep = ScheduledTasks.INSTANCE.getCount() > 0 || serialTasksRunning;
            if (sleep) {
                CancelOtherTasks.sleep();
            }
        }

        private static void sleep() {
            try {
                Thread.sleep(2000L);
            }
            catch (Throwable t) {
                Logger.getLogger(CancelOtherTasks.class.getName()).log(Level.SEVERE, null, t);
            }
        }

        private CancelOtherTasks() {
        }
    }

    public static abstract class FinalTask {
        private final ListenerSupport<FinalTaskListener> ls = new ListenerSupport();

        public void addListener(FinalTaskListener listener) {
            if (listener == null) {
                throw new NullPointerException("listener == null");
            }
            this.ls.add(listener);
        }

        public void removeListener(FinalTaskListener listener) {
            if (listener == null) {
                throw new NullPointerException("listener == null");
            }
            this.ls.remove(listener);
        }

        protected void notifyFinished() {
            for (FinalTaskListener listener : this.ls.get()) {
                listener.finished();
            }
        }

        public abstract void execute();
    }

    public static interface FinalTaskListener {
        public void finished();
    }
}

