/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.app;

import com.imagero.reader.AbstractImageReader;
import java.awt.Toolkit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.api.applifecycle.AppWillInitEvent;
import org.jphototagger.domain.repository.Repository;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.LongMessageDialog;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.CommandLineParser;
import org.jphototagger.lib.util.ExceptionUtil;
import org.jphototagger.program.app.AppCommandLineOptions;
import org.jphototagger.program.app.AppEventQueue;
import org.jphototagger.program.app.AppLifeCycle;
import org.jphototagger.program.app.AppStartupLock;
import org.jphototagger.program.app.logging.AppLogUtil;
import org.jphototagger.program.app.logging.AppLoggingSystem;
import org.jphototagger.program.app.ui.AppFrame;
import org.jphototagger.program.app.ui.AppLookAndFeel;
import org.jphototagger.program.app.ui.SplashScreen;
import org.jphototagger.program.module.thumbnails.cache.CacheUtil;
import org.jphototagger.program.resource.ImageProperties;
import org.openide.util.Lookup;

public final class AppInit {
    public static final AppInit INSTANCE = new AppInit();
    private AppCommandLineOptions commandLineOptions;
    private volatile boolean init;

    private AppInit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String[] args) {
        AppInit appInit = this;
        synchronized (appInit) {
            if (this.init) {
                throw new IllegalStateException("Already init!");
            }
            this.init = true;
        }
        this.commandLineOptions = new AppCommandLineOptions(new CommandLineParser(args, "-", "="));
        this.init();
    }

    private void init() {
        try {
            AppLoggingSystem.init();
            AppLookAndFeel.set();
            AppLogUtil.logSystemInfo();
            AppInit.lock();
            this.showSplashScreen();
            EventBus.publish(new AppWillInitEvent(this));
            CacheUtil.initCaches();
            SplashScreen.INSTANCE.setMessage(Bundle.getString(AppInit.class, "AppInit.Info.ConnectToRepository", new Object[0]));
            Lookup.getDefault().lookup(Repository.class).init();
            SplashScreen.INSTANCE.setProgress(75);
            AbstractImageReader.install(ImageProperties.class);
            this.hideSplashScreen();
            AppInit.showMainWindow();
            this.setJptEventQueue();
        }
        catch (Throwable t) {
            Logger.getLogger(AppInit.class.getName()).log(Level.SEVERE, null, t);
            this.showErrorMessage(t);
            AppLifeCycle.quitBeforeGuiWasCreated();
        }
    }

    private void hideSplashScreen() {
        if (!this.commandLineOptions.isShowSplashScreen()) {
            return;
        }
        SplashScreen.INSTANCE.setMessage(Bundle.getString(AppInit.class, "AppInit.Info.InitGui", new Object[0]));
        SplashScreen.INSTANCE.setProgress(100);
        SplashScreen.INSTANCE.close();
    }

    private void showSplashScreen() {
        if (!this.commandLineOptions.isShowSplashScreen()) {
            return;
        }
        SplashScreen.INSTANCE.init();
        SplashScreen.INSTANCE.setProgress(50);
    }

    public AppCommandLineOptions getCommandLineOptions() {
        return this.commandLineOptions;
    }

    private static void lock() {
        if (!AppStartupLock.lock() && !AppStartupLock.forceLock()) {
            throw new RuntimeException("Application can't be locked");
        }
    }

    private static void showMainWindow() {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                try {
                    AppFrame appFrame = new AppFrame();
                    appFrame.setVisible(true);
                }
                catch (Throwable t) {
                    Logger.getLogger(AppInit.class.getName()).log(Level.SEVERE, null, t);
                    MessageDisplayer.thrown(Bundle.getString(AppInit.class, "AppInit.Error.ShowMainWindow", new Object[0]), t);
                    AppLifeCycle.quitBeforeGuiWasCreated();
                }
            }
        });
    }

    private void setJptEventQueue() {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(new AppEventQueue());
    }

    private void showErrorMessage(Throwable t) {
        LongMessageDialog dlg = new LongMessageDialog(null, true);
        String message = t.getLocalizedMessage() + "\n" + ExceptionUtil.getStackTraceAsString(t);
        dlg.setTitle(Bundle.getString(AppInit.class, "AppInit.Error.Thrown", new Object[0]));
        dlg.setLongMessage(message);
        dlg.setVisible(true);
    }
}

