/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program;

import java.awt.EventQueue;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.jphototagger.program.app.AppInit;

public final class Main {
    private static final int MIN_JAVA_MAJOR_VERSION = 1;
    private static final int MIN_JAVA_MINOR_VERSION = 7;

    public static void main(String[] args) {
        if (Main.checkJavaVersion()) {
            AppInit.INSTANCE.init(args);
        }
    }

    private static boolean checkJavaVersion() {
        Logger logger = Logger.getLogger(Main.class.getName());
        logger.info("Checking Java version");
        String version = System.getProperty("java.version");
        String[] versionToken = version.split("\\.");
        if (versionToken.length < 2) {
            logger.log(Level.SEVERE, "Can''t get valid Java Version! Got: ''{0}''", version);
            return true;
        }
        try {
            boolean tooOld;
            int major = Integer.parseInt(versionToken[0]);
            int minor = Integer.parseInt(versionToken[1]);
            boolean bl = tooOld = major < 1 || major == 1 && minor < 7;
            if (tooOld) {
                Main.errorMessageJavaVersion(version);
                return false;
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, null, t);
        }
        return true;
    }

    private static void errorMessageJavaVersion(final String version) {
        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, "Java version ''{0}'' is too old! The required minimum Java version is ''{1}.{2}''.", new Object[]{version, 1, 7});
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/Bundle");
                String message = MessageFormat.format(bundle.getString("Main.Error.JavaVersion.Message"), version, 1, 7);
                String title = bundle.getString("Main.Error.JavaVersion.MessageTitle");
                JOptionPane.showMessageDialog(null, message, title, 0);
            }
        });
    }

    private Main() {
    }
}

