/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repositoryfilebrowser;

import java.awt.Image;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.Icon;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.domain.thumbnails.ThumbnailProvider;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.repositoryfilebrowser.FileNode;
import org.openide.util.Lookup;

public class RepositoryImageFileInfo {
    private File imageFile;
    private Icon imageFileIcon;
    private Image thumbnail;
    private String timeImageFileInRepository = "-";
    private String timeImageFileInFileSystem = "-";
    private String timeXmpFileInRepository = "-";
    private String timeXmpFileInFileSystem = "-";
    private boolean imageFileExists;
    private boolean xmpFileExists;
    private String timeImageFileWarning;
    private String timeXmpFileWarning;
    private String thumbnailSizeInfo;
    private final XmpSidecarFileResolver xmpSidecarFileResolver = (XmpSidecarFileResolver)Lookup.getDefault().lookup(XmpSidecarFileResolver.class);
    private final ImageFilesRepository imageFileRepository = (ImageFilesRepository)Lookup.getDefault().lookup(ImageFilesRepository.class);
    private static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(2, 2);
    private static final String TIME_WARNING_STRING = Bundle.getString(RepositoryImageFileInfo.class, (String)"RepositoryImageFileInfo.TimeWarningString", (Object[])new Object[0]);

    public RepositoryImageFileInfo(FileNode fileNode) {
        if (fileNode != null) {
            this.imageFile = fileNode.getFile();
            this.imageFileIcon = fileNode.getSmallIcon();
            this.setThumbnail();
            this.setThumbnailSizeInfo();
            this.setImageFileTimeStamps();
            this.setXmpFileTimeStamps();
            this.setFilesExists();
        }
    }

    private void setThumbnail() {
        ThumbnailProvider thumbnailProvider = (ThumbnailProvider)Lookup.getDefault().lookup(ThumbnailProvider.class);
        this.thumbnail = thumbnailProvider.getThumbnail(this.imageFile);
    }

    private void setThumbnailSizeInfo() {
        if (this.thumbnail == null) {
            return;
        }
        int width = this.thumbnail.getWidth(null);
        int height = this.thumbnail.getHeight(null);
        this.thumbnailSizeInfo = Bundle.getString(RepositoryImageFileInfo.class, (String)"RepositoryImageFileInfo.ThumbnailSizeInfo", (Object[])new Object[]{width, height});
    }

    private void setImageFileTimeStamps() {
        long repoTimestamp = this.imageFileRepository.findImageFilesLastModifiedTimestamp(this.imageFile);
        this.timeImageFileInRepository = this.createDateStringOfTimestamp(repoTimestamp);
        this.timeImageFileInFileSystem = this.createDateStringOfFile(this.imageFile);
        this.setTimeImageFileWarning(repoTimestamp);
    }

    private void setXmpFileTimeStamps() {
        long repoTimestamp = this.imageFileRepository.findXmpFilesLastModifiedTimestamp(this.imageFile);
        this.timeXmpFileInRepository = this.createDateStringOfTimestamp(repoTimestamp);
        File xmpFile = this.xmpSidecarFileResolver.suggestXmpSidecarFile(this.imageFile);
        this.timeXmpFileInFileSystem = this.createDateStringOfFile(xmpFile);
        this.setTimeXmpFileWarning(repoTimestamp, xmpFile);
    }

    private String createDateStringOfTimestamp(long timestamp) {
        return timestamp < 0L ? "-" : DATE_FORMAT.format(new Date(timestamp));
    }

    private String createDateStringOfFile(File file) {
        if (file.exists()) {
            long lastModified = file.lastModified();
            return this.createDateStringOfTimestamp(lastModified);
        }
        return "-";
    }

    private void setTimeXmpFileWarning(long repoTimeStamp, File xmpFile) {
        long lastModified = xmpFile.lastModified();
        this.timeXmpFileWarning = xmpFile.exists() && lastModified != repoTimeStamp ? TIME_WARNING_STRING : "";
    }

    private void setTimeImageFileWarning(long repoTimeStamp) {
        long lastModified = this.imageFile == null ? Long.MIN_VALUE : this.imageFile.lastModified();
        this.timeImageFileWarning = this.imageFile != null && this.imageFile.exists() && lastModified != repoTimeStamp ? TIME_WARNING_STRING : "";
    }

    private void setFilesExists() {
        this.imageFileExists = this.existsImageFile();
        this.xmpFileExists = this.imageFile != null && this.xmpSidecarFileResolver.suggestXmpSidecarFile(this.imageFile).exists();
    }

    private boolean existsImageFile() {
        return this.imageFile != null && this.imageFile.exists();
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public String getImageFilepath() {
        return this.imageFile == null ? null : this.imageFile.getAbsolutePath();
    }

    public Icon getImageFileIcon() {
        return this.imageFileIcon;
    }

    public boolean getImageFileExists() {
        return this.imageFileExists;
    }

    public Image getThumbnail() {
        return this.thumbnail;
    }

    public String getTimeImageFileInFileSystem() {
        return this.timeImageFileInFileSystem;
    }

    public String getTimeImageFileInRepository() {
        return this.timeImageFileInRepository;
    }

    public String getTimeXmpFileInFileSystem() {
        return this.timeXmpFileInFileSystem;
    }

    public String getTimeXmpFileInRepository() {
        return this.timeXmpFileInRepository;
    }

    public boolean getXmpFileExists() {
        return this.xmpFileExists;
    }

    public String getTimeImageFileWarning() {
        return this.timeImageFileWarning;
    }

    public String getTimeXmpFileWarning() {
        return this.timeXmpFileWarning;
    }

    public String getThumbnailSizeInfo() {
        return this.thumbnailSizeInfo;
    }
}

