/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repositoryfilebrowser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.JXRootPane;
import org.jphototagger.api.applifecycle.generics.Functor;
import org.jphototagger.api.branding.Branding;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.lib.lookup.LookupList;
import org.jphototagger.lib.lookup.NodesListModel;
import org.jphototagger.lib.swing.BooleanLabel;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.ImagePanel;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.swingx.BusyPanel;
import org.jphototagger.lib.swingx.ListTextFilter;
import org.jphototagger.repositoryfilebrowser.FileNode;
import org.jphototagger.repositoryfilebrowser.FileNodeAscendingComparator;
import org.jphototagger.repositoryfilebrowser.RepositoryImageFileInfo;
import org.openide.util.Lookup;

public final class RepositoryFileBrowserDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private RepositoryImageFileInfo imageFileInfo;
    private FileNode selectedFileNode;
    private final NodesListModel nodesListModel = new NodesListModel();
    private ListTextFilter listTextFilter;
    private final BusyPanel busyPanel = new BusyPanel(new Dimension(200, 200));
    private BooleanLabel booleanLabelImageFileExists;
    private BooleanLabel booleanLabelXmpFileExists;
    private JButton buttonApplyFilter;
    private ImagePanel imagePanel;
    private JLabel labelFileCount;
    private JLabel labelFileCountPrompt;
    private JLabel labelFilterPrompt;
    private JLabel labelPromptTimeXmpFileInFileSystem;
    private JLabel labelPromptTimeXmpFileInRepository;
    private JLabel labelSelectedFilepath;
    private JLabel labelSelectedFilepathPrompt;
    private JLabel labelThumbnailSizeInfo;
    private JLabel labelTimeImageFileWarning;
    private JLabel labelTimeXmpFileInFileSystem;
    private JLabel labelTimeXmpFileInRepository;
    private JLabel labelTimeXmpFileWarning;
    private JLabel labelimeImageFileInFileSystem;
    private JLabel labelimeImageFileInFileSystemPrompt;
    private JLabel labelimeImageFileInRepository;
    private JLabel labelimeImageFileInRepositoryPrompt;
    private LookupList listFiles;
    private JXRootPane panelContent;
    private JPanel panelDetails;
    private JPanel panelFilter;
    private JPanel panelImageFile;
    private JPanel panelInfo;
    private JPanel panelListInfo;
    private JPanel panelThumbnail;
    private JPanel panelXMPFile;
    private JProgressBar progressBarGetFiles;
    private JScrollPane scrollPaneFiles;
    private JTextField textFieldFilter;
    private BindingGroup bindingGroup;

    public RepositoryFileBrowserDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.initFileFilter();
        this.listFiles.addListSelectionListener((ListSelectionListener)new FileSelectionListener());
        MnemonicUtil.setMnemonics((Container)((Object)this));
        this.panelContent.setGlassPane((Component)this.busyPanel);
        this.busyPanel.setVisible(true);
    }

    private void initFileFilter() {
        this.listTextFilter = new ListTextFilter((JXList)this.listFiles);
        this.listTextFilter.filterOnActionPerformed((AbstractButton)this.buttonApplyFilter, this.textFieldFilter.getDocument());
    }

    public void setSelectedFileNode(FileNode fileNode) {
        RepositoryImageFileInfo oldImageFileInfo = this.imageFileInfo;
        FileNode oldSelectedFileNode = this.selectedFileNode;
        this.selectedFileNode = fileNode;
        this.imageFileInfo = new RepositoryImageFileInfo(fileNode);
        this.firePropertyChange("imageFileInfo", oldImageFileInfo, this.imageFileInfo);
        this.firePropertyChange("selectedFileNode", (Object)oldSelectedFileNode, (Object)this.selectedFileNode);
    }

    public RepositoryImageFileInfo getImageFileInfo() {
        return this.imageFileInfo;
    }

    public FileNode getSelectedFileNode() {
        return this.selectedFileNode;
    }

    private void insertImageFiles() {
        LookupImageFilesSwingWorker task = new LookupImageFilesSwingWorker();
        task.execute();
    }

    private void updateFileCountLabel() {
        int fileCount = this.nodesListModel.getSize();
        this.labelFileCount.setText(Integer.toString(fileCount));
        ComponentUtil.forceRepaint((Component)this.labelFileCount);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.insertImageFiles();
        }
        super.setVisible(visible);
    }

    protected void restoreSizeAndLocation() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        prefs.applySize(RepositoryFileBrowserDialog.class.getName(), (Component)((Object)this));
        prefs.applyLocation(RepositoryFileBrowserDialog.class.getName(), (Component)((Object)this));
    }

    protected void persistSizeAndLocation() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        prefs.setSize(RepositoryFileBrowserDialog.class.getName(), (Component)((Object)this));
        prefs.setLocation(RepositoryFileBrowserDialog.class.getName(), (Component)((Object)this));
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panelContent = new JXRootPane();
        this.panelFilter = new JPanel();
        this.labelFilterPrompt = new JLabel();
        this.textFieldFilter = new JTextField();
        this.buttonApplyFilter = new JButton();
        this.scrollPaneFiles = new JScrollPane();
        this.listFiles = new LookupList();
        this.panelListInfo = new JPanel();
        this.labelSelectedFilepathPrompt = new JLabel();
        this.labelSelectedFilepath = new JLabel();
        this.labelFileCountPrompt = new JLabel();
        this.labelFileCount = new JLabel();
        this.progressBarGetFiles = new JProgressBar();
        this.panelInfo = new JPanel();
        this.panelThumbnail = new JPanel();
        this.imagePanel = new ImagePanel();
        this.panelDetails = new JPanel();
        this.panelImageFile = new JPanel();
        this.booleanLabelImageFileExists = new BooleanLabel();
        this.labelimeImageFileInRepositoryPrompt = new JLabel();
        this.labelimeImageFileInRepository = new JLabel();
        this.labelimeImageFileInFileSystemPrompt = new JLabel();
        this.labelimeImageFileInFileSystem = new JLabel();
        this.labelTimeImageFileWarning = new JLabel();
        this.panelXMPFile = new JPanel();
        this.booleanLabelXmpFileExists = new BooleanLabel();
        this.labelPromptTimeXmpFileInRepository = new JLabel();
        this.labelTimeXmpFileInRepository = new JLabel();
        this.labelPromptTimeXmpFileInFileSystem = new JLabel();
        this.labelTimeXmpFileInFileSystem = new JLabel();
        this.labelTimeXmpFileWarning = new JLabel();
        this.labelThumbnailSizeInfo = new JLabel();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/repositoryfilebrowser/Bundle");
        this.setTitle(bundle.getString("RepositoryFileBrowserDialog.title"));
        this.setIconImages(((Branding)Lookup.getDefault().lookup(Branding.class)).getAppIcons());
        this.setName("Form");
        this.getContentPane().setLayout(new GridBagLayout());
        this.panelContent.setName("panelContent");
        this.panelContent.getContentPane().setLayout(new GridBagLayout());
        this.panelFilter.setName("panelFilter");
        this.panelFilter.setLayout(new GridBagLayout());
        this.labelFilterPrompt.setLabelFor(this.textFieldFilter);
        this.labelFilterPrompt.setText(bundle.getString("RepositoryFileBrowserDialog.labelFilterPrompt.text"));
        this.labelFilterPrompt.setName("labelFilterPrompt");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelFilter.add((Component)this.labelFilterPrompt, gridBagConstraints);
        this.textFieldFilter.setName("textFieldFilter");
        this.textFieldFilter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RepositoryFileBrowserDialog.this.textFieldFilterKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelFilter.add((Component)this.textFieldFilter, gridBagConstraints);
        this.buttonApplyFilter.setText(bundle.getString("RepositoryFileBrowserDialog.buttonApplyFilter.text"));
        this.buttonApplyFilter.setName("buttonApplyFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelFilter.add((Component)this.buttonApplyFilter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelContent.getContentPane().add((Component)this.panelFilter, gridBagConstraints);
        this.scrollPaneFiles.setName("scrollPaneFiles");
        this.scrollPaneFiles.setPreferredSize(new Dimension(400, 131));
        this.listFiles.setModel((ListModel)this.nodesListModel);
        this.listFiles.setSelectionMode(0);
        this.listFiles.setAutoCreateRowSorter(true);
        this.listFiles.setCellRenderer((ListCellRenderer)new FileNodeListCellRenderer());
        this.listFiles.setComparator((Comparator)FileNodeAscendingComparator.INSTANCE);
        this.listFiles.setName("listFiles");
        this.scrollPaneFiles.setViewportView((Component)this.listFiles);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.6;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelContent.getContentPane().add((Component)this.scrollPaneFiles, gridBagConstraints);
        this.panelListInfo.setName("panelListInfo");
        this.panelListInfo.setLayout(new GridBagLayout());
        this.labelSelectedFilepathPrompt.setText(bundle.getString("RepositoryFileBrowserDialog.labelSelectedFilepathPrompt.text"));
        this.labelSelectedFilepathPrompt.setName("labelSelectedFilepathPrompt");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.panelListInfo.add((Component)this.labelSelectedFilepathPrompt, gridBagConstraints);
        this.labelSelectedFilepath.setForeground(new Color(0, 0, 255));
        this.labelSelectedFilepath.setName("labelSelectedFilepath");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${imageFileInfo.imageFileIcon}"), (Object)this.labelSelectedFilepath, (Property)BeanProperty.create((String)"icon"));
        binding.setSourceNullValue(null);
        binding.setSourceUnreadableValue(null);
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${imageFileInfo.imageFilepath}"), (Object)this.labelSelectedFilepath, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelListInfo.add((Component)this.labelSelectedFilepath, gridBagConstraints);
        this.labelFileCountPrompt.setText(bundle.getString("RepositoryFileBrowserDialog.labelFileCountPrompt.text"));
        this.labelFileCountPrompt.setName("labelFileCountPrompt");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelListInfo.add((Component)this.labelFileCountPrompt, gridBagConstraints);
        this.labelFileCount.setName("labelFileCount");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelListInfo.add((Component)this.labelFileCount, gridBagConstraints);
        this.progressBarGetFiles.setName("progressBarGetFiles");
        this.progressBarGetFiles.setString(bundle.getString("RepositoryFileBrowserDialog.progressBarGetFiles.string"));
        this.progressBarGetFiles.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panelListInfo.add((Component)this.progressBarGetFiles, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelContent.getContentPane().add((Component)this.panelListInfo, gridBagConstraints);
        this.panelInfo.setName("panelInfo");
        this.panelInfo.setLayout(new GridBagLayout());
        this.panelThumbnail.setBorder(BorderFactory.createTitledBorder(bundle.getString("RepositoryFileBrowserDialog.panelThumbnail.border.title")));
        this.panelThumbnail.setName("panelThumbnail");
        this.panelThumbnail.setPreferredSize(new Dimension(150, 150));
        this.imagePanel.setImageIsAbsentText(bundle.getString("RepositoryFileBrowserDialog.imagePanel.imageIsAbsentText"));
        this.imagePanel.setName("imagePanel");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${imageFileInfo.thumbnail}"), (Object)this.imagePanel, (Property)BeanProperty.create((String)"image"));
        this.bindingGroup.addBinding((Binding)binding);
        GroupLayout imagePanelLayout = new GroupLayout((Container)this.imagePanel);
        this.imagePanel.setLayout((LayoutManager)imagePanelLayout);
        imagePanelLayout.setHorizontalGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 51, Short.MAX_VALUE));
        imagePanelLayout.setVerticalGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 219, Short.MAX_VALUE));
        GroupLayout panelThumbnailLayout = new GroupLayout(this.panelThumbnail);
        this.panelThumbnail.setLayout(panelThumbnailLayout);
        panelThumbnailLayout.setHorizontalGroup(panelThumbnailLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelThumbnailLayout.createSequentialGroup().addGap(126, 126, 126).addComponent((Component)this.imagePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        panelThumbnailLayout.setVerticalGroup(panelThumbnailLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelThumbnailLayout.createSequentialGroup().addComponent((Component)this.imagePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.weighty = 1.0;
        this.panelInfo.add((Component)this.panelThumbnail, gridBagConstraints);
        this.panelDetails.setBorder(BorderFactory.createTitledBorder(bundle.getString("RepositoryFileBrowserDialog.panelDetails.border.title")));
        this.panelDetails.setName("panelDetails");
        this.panelDetails.setPreferredSize(new Dimension(325, 229));
        this.panelDetails.setLayout(new GridBagLayout());
        this.panelImageFile.setBorder(BorderFactory.createTitledBorder(bundle.getString("RepositoryFileBrowserDialog.panelImageFile.border.title")));
        this.panelImageFile.setName("panelImageFile");
        this.panelImageFile.setLayout(new GridBagLayout());
        this.booleanLabelImageFileExists.setFalseText(bundle.getString("RepositoryFileBrowserDialog.booleanLabelImageFileExists.falseText"));
        this.booleanLabelImageFileExists.setTrueText(bundle.getString("RepositoryFileBrowserDialog.booleanLabelImageFileExists.trueText"));
        this.booleanLabelImageFileExists.setName("booleanLabelImageFileExists");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${imageFileInfo.imageFileExists}"), (Object)this.booleanLabelImageFileExists, (Property)BeanProperty.create((String)"isTrue"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelImageFile.add((Component)this.booleanLabelImageFileExists, gridBagConstraints);
        this.labelimeImageFileInRepositoryPrompt.setText(bundle.getString("RepositoryFileBrowserDialog.labelimeImageFileInRepositoryPrompt.text"));
        this.labelimeImageFileInRepositoryPrompt.setName("labelimeImageFileInRepositoryPrompt");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.panelImageFile.add((Component)this.labelimeImageFileInRepositoryPrompt, gridBagConstraints);
        this.labelimeImageFileInRepository.setName("labelimeImageFileInRepository");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${imageFileInfo.timeImageFileInRepository}"), (Object)this.labelimeImageFileInRepository, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelImageFile.add((Component)this.labelimeImageFileInRepository, gridBagConstraints);
        this.labelimeImageFileInFileSystemPrompt.setText(bundle.getString("RepositoryFileBrowserDialog.labelimeImageFileInFileSystemPrompt.text"));
        this.labelimeImageFileInFileSystemPrompt.setName("labelimeImageFileInFileSystemPrompt");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.panelImageFile.add((Component)this.labelimeImageFileInFileSystemPrompt, gridBagConstraints);
        this.labelimeImageFileInFileSystem.setName("labelimeImageFileInFileSystem");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${imageFileInfo.timeImageFileInFileSystem}"), (Object)this.labelimeImageFileInFileSystem, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.panelImageFile.add((Component)this.labelimeImageFileInFileSystem, gridBagConstraints);
        this.labelTimeImageFileWarning.setForeground(new Color(255, 0, 51));
        this.labelTimeImageFileWarning.setName("labelTimeImageFileWarning");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${imageFileInfo.timeImageFileWarning}"), (Object)this.labelTimeImageFileWarning, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 10, 3, 3);
        this.panelImageFile.add((Component)this.labelTimeImageFileWarning, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.panelDetails.add((Component)this.panelImageFile, gridBagConstraints);
        this.panelXMPFile.setBorder(BorderFactory.createTitledBorder(bundle.getString("RepositoryFileBrowserDialog.panelXMPFile.border.title")));
        this.panelXMPFile.setName("panelXMPFile");
        this.panelXMPFile.setLayout(new GridBagLayout());
        this.booleanLabelXmpFileExists.setFalseText(bundle.getString("RepositoryFileBrowserDialog.booleanLabelXmpFileExists.falseText"));
        this.booleanLabelXmpFileExists.setTrueText(bundle.getString("RepositoryFileBrowserDialog.booleanLabelXmpFileExists.trueText"));
        this.booleanLabelXmpFileExists.setName("booleanLabelXmpFileExists");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${imageFileInfo.xmpFileExists}"), (Object)this.booleanLabelXmpFileExists, (Property)BeanProperty.create((String)"isTrue"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelXMPFile.add((Component)this.booleanLabelXmpFileExists, gridBagConstraints);
        this.labelPromptTimeXmpFileInRepository.setText(bundle.getString("RepositoryFileBrowserDialog.labelPromptTimeXmpFileInRepository.text"));
        this.labelPromptTimeXmpFileInRepository.setName("labelPromptTimeXmpFileInRepository");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.panelXMPFile.add((Component)this.labelPromptTimeXmpFileInRepository, gridBagConstraints);
        this.labelTimeXmpFileInRepository.setName("labelTimeXmpFileInRepository");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${imageFileInfo.timeXmpFileInRepository}"), (Object)this.labelTimeXmpFileInRepository, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelXMPFile.add((Component)this.labelTimeXmpFileInRepository, gridBagConstraints);
        this.labelPromptTimeXmpFileInFileSystem.setText(bundle.getString("RepositoryFileBrowserDialog.labelPromptTimeXmpFileInFileSystem.text"));
        this.labelPromptTimeXmpFileInFileSystem.setName("labelPromptTimeXmpFileInFileSystem");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.panelXMPFile.add((Component)this.labelPromptTimeXmpFileInFileSystem, gridBagConstraints);
        this.labelTimeXmpFileInFileSystem.setName("labelTimeXmpFileInFileSystem");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${imageFileInfo.timeXmpFileInFileSystem}"), (Object)this.labelTimeXmpFileInFileSystem, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.panelXMPFile.add((Component)this.labelTimeXmpFileInFileSystem, gridBagConstraints);
        this.labelTimeXmpFileWarning.setForeground(new Color(255, 0, 51));
        this.labelTimeXmpFileWarning.setName("labelTimeXmpFileWarning");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${imageFileInfo.timeXmpFileWarning}"), (Object)this.labelTimeXmpFileWarning, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 10, 3, 3);
        this.panelXMPFile.add((Component)this.labelTimeXmpFileWarning, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.panelDetails.add((Component)this.panelXMPFile, gridBagConstraints);
        this.labelThumbnailSizeInfo.setName("labelThumbnailSizeInfo");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${imageFileInfo.thumbnailSizeInfo}"), (Object)this.labelThumbnailSizeInfo, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"");
        binding.setSourceUnreadableValue((Object)"");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelDetails.add((Component)this.labelThumbnailSizeInfo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelInfo.add((Component)this.panelDetails, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.4;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelContent.getContentPane().add((Component)this.panelInfo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.panelContent, gridBagConstraints);
        this.bindingGroup.bind();
        this.pack();
    }

    private void textFieldFilterKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.buttonApplyFilter.doClick();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RepositoryFileBrowserDialog dialog = new RepositoryFileBrowserDialog(new JFrame());
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private static class FileNodeListCellRenderer
    extends DefaultListCellRenderer {
        public static final ImageIcon ICON = IconUtil.getImageIcon(FileNodeListCellRenderer.class, (String)"icon_file.png");
        private static final long serialVersionUID = 1L;

        private FileNodeListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof FileNode) {
                FileNode fileNode = (FileNode)((Object)value);
                this.setText(fileNode.getDisplayName());
                this.setIcon(ICON);
            }
            return label;
        }
    }

    private class LookupImageFilesSwingWorker
    extends SwingWorker<Void, FileNode> {
        private LookupImageFilesSwingWorker() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            ImageFilesRepository repo = (ImageFilesRepository)Lookup.getDefault().lookup(ImageFilesRepository.class);
            repo.eachImage((Functor)new Functor<File>(){

                public void execute(File file) {
                    FileNode node = new FileNode(file);
                    LookupImageFilesSwingWorker.this.publish((Object[])new FileNode[]{node});
                }
            });
            return null;
        }

        @Override
        protected void process(List<FileNode> chunks) {
            RepositoryFileBrowserDialog.this.nodesListModel.addNodes(chunks);
        }

        @Override
        protected void done() {
            RepositoryFileBrowserDialog.this.panelListInfo.remove(RepositoryFileBrowserDialog.this.progressBarGetFiles);
            RepositoryFileBrowserDialog.this.updateFileCountLabel();
            RepositoryFileBrowserDialog.this.busyPanel.setVisible(false);
        }
    }

    private class FileSelectionListener
    implements ListSelectionListener {
        private FileSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                FileNode selectedNode = (FileNode)((Object)RepositoryFileBrowserDialog.this.listFiles.getSelectedValue());
                RepositoryFileBrowserDialog.this.setSelectedFileNode(selectedNode);
            }
        }
    }
}

