/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repositoryfilebrowser;

import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import org.jphototagger.lib.nodes.AbstractNode;

public final class FileNode
extends AbstractNode {
    private static final MessageFormat DISPLAY_NAME_FORMAT = new MessageFormat("{0} [{1}]");
    private static final MessageFormat HTML_DISPLAY_NAME_FORMAT = new MessageFormat(FileNode.createHtmlDisplayNamePattern());
    private final File file;

    public FileNode(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        this.file = file;
    }

    public Collection<?> getContent() {
        return Collections.singleton(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }

    public String getDisplayName() {
        return DISPLAY_NAME_FORMAT.format(new Object[]{this.file.getName(), this.file.getAbsolutePath()});
    }

    public String getHtmlDisplayName() {
        return HTML_DISPLAY_NAME_FORMAT.format(new Object[]{this.file.getName(), this.file.getAbsolutePath()});
    }

    private static String createHtmlDisplayNamePattern() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>").append("<b>").append("{0}").append("</b>").append("&nbsp;&nbsp;&nbsp;").append("[{1}]").append("</html>");
        return sb.toString();
    }
}

